# 快手广告鸿蒙-SDK接入文档

[TOC]

## 1. 接⼊准备

接入快手广告SDK前，请在快手广告平台申请您的AppId，广告位id等


## 2. SDK集成
### OHPM自动引入
命令行引入：

ohpm install ksadsdk

或package.json添加依赖：
```json5
{
  "dependencies": {
    "KSAdSDK": "{version}"
  }
}
```

### 手动引入har包

在oh-package.json5添加依赖

```json5
{
  "dependencies": {
    "KSAdSDK": "file:./KSAdSDK-{version}.har"
  }
}
```
工程级build-profile.json5中设置useNormalizedOHMUrl为true
```json5
{
  "app": {
    "products": [
      {
        "buildOption": {
          "strictMode": {
            "useNormalizedOHMUrl": true
          }
        }
      }
    ]
  }
}
```


### 添加权限
1. 打开app模块的module.json5文件
2. 添加以下权限：访问网络、获取网络状态、获取广告追踪标识（oaid）、传感器（可选）、振动（可选）

```json5
{
  "requestPermissions": [
    {
      "name": "ohos.permission.INTERNET",	//访问网络
      "reason": "$string:request_network"
    },
    {
      "name": "ohos.permission.GET_NETWORK_INFO", //获取网络状态
      "reason": "$string:request_network_info"
    },
    {
      "name": "ohos.permission.APP_TRACKING_CONSENT", //获取广告标识
      "reason": "$string:request_track"
    },
    {
      "name": "ohos.permission.ACCELEROMETER", // 传感器，用于实现扭动摇动
      "reason": "$string:request_sensor"
    },
    {
      "name": "ohos.permission.GYROSCOPE", // 传感器，用于实现扭动摇动
      "reason": "$string:request_sensor"
    },
    {
      "name": "ohos.permission.VIBRATE", // 振动，用于交互反馈
      "reason": "$string:request_vibrate"
    }
  ]
}
```