import relationalStore from '@ohos.data.relationalStore'; import systemDateTime from '@ohos.systemDateTime'; import { m4 } from "../o2/t2/u2"; import { stringify } from "../o2/p2"; import ArrayList from '@ohos.util.ArrayList'; import { j10 } from "./k3/l3"; const v7 = { name: "csj_ad.db", securityLevel: relationalStore.SecurityLevel.S1 }; const w7 = 'track'; const l10 = 'track_id'; const m10 = 'url'; const c8 = 'ts'; const d8 = 'retry_count'; const e8 = `CREATE TABLE IF NOT EXISTS ${w7}(
    ${l10} VARCHAR(255) PRIMARY KEY ,
    ${m10} TEXT,
    ${c8} TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    ${d8} INTEGER);`; const TAG = "csj_track"; const f8 = 1000 * 60 * 60 * 24 * 7; class n10 { init(context, callback) { relationalStore.getRdbStore(context, v7, (err, a12) => { this.store = a12; if (err) { callback(false); m4.e(TAG, `getStore failed, code is ${err.code},message is ${err.message}`); return; } m4.k5(TAG, 'getStore successfully.'); this.store.executeSql(e8, (err) => { if (err) { callback(false); m4.e(TAG, `createTabel failed, code is ${err.code},message is ${err.message}`); return; } callback(true); m4.k5(TAG, `createTable successfully`); }); }); } l5(dataList, v11) { if (!this.store) { v11(false); m4.e(TAG, "save failed，not init"); return; } if (dataList.length == 0) { m4.e(TAG, "save success"); v11(true); return; } let w11 = new Array(dataList.length); let time = systemDateTime.getTime(); dataList.forEach((data, index, array) => { const valueBucket = { 'track_id': data.getId(), 'url': data.getUrl(), 'retry_count': data.v5(), 'ts': time }; w11[index] = valueBucket; }); this.store.batchInsert(w7, w11, (err, rows) => { if (err) { v11(false); m4.e(TAG, `updated failed, code is ${err.code},message is ${err.message}`); return; } v11(true); }); } save(data) { if (!this.store) { return; } let time = systemDateTime.getTime(); const valueBucket = { 'track_id': data.getId(), 'url': data.getUrl(), 'retry_count': data.v5(), 'ts': time }; this.store.insert(w7, valueBucket, (err, rows) => { if (err) { m4.e(TAG, `updated failed, code is ${err.code},message is ${err.message}`); return; } }); } x5(max) { return new Promise((p11, q11) => { if (!this.store) { m4.e(TAG, "get failed"); return q11("get error"); } let predicates = new relationalStore.RdbPredicates(w7); predicates.limitAs(max); this.store.query(predicates, (err, resultSet) => { if (err) { m4.e(TAG, `get failed, code is ${err.code},message is ${err.message}`); return q11(`get error ${err}`); } let s11 = new ArrayList(); while (resultSet.goToNextRow()) { const url = resultSet.getString(resultSet.getColumnIndex(m10)); const t11 = resultSet.getLong(resultSet.getColumnIndex(d8)); const time = resultSet.getLong(resultSet.getColumnIndex(c8)); const localId = resultSet.getString(resultSet.getColumnIndex(l10)); let result = new j10(localId, url, t11); s11.add(result); } resultSet.close(); m4.k5(TAG, `getListMax finish , data is : ${s11.length}`); return p11(s11); }); }); } get(id, ...i11) { return new Promise((k11, l11) => { if (!this.store) { m4.e(TAG, "get failed"); return l11("error"); } let predicates = new relationalStore.RdbPredicates(w7); predicates.equalTo(l10, id); this.store.query(predicates, (err, resultSet) => { if (err) { m4.e(TAG, `get failed, code is ${err.code},message is ${err.message}`); return l11("error:" + err.message); } let result = undefined; if (resultSet.goToFirstRow()) { const url = resultSet.getString(resultSet.getColumnIndex(m10)); const n11 = resultSet.getLong(resultSet.getColumnIndex(d8)); const time = resultSet.getLong(resultSet.getColumnIndex(c8)); const localId = resultSet.getString(resultSet.getColumnIndex(l10)); result = new j10(localId, url, n11); } resultSet.close(); return k11(result); }); }); } delete(ids) { return new Promise((d11, e11) => { if (!this.store) { m4.d(TAG, "store delete error"); return e11("store is false"); } let f11 = new relationalStore.RdbPredicates(w7); for (let index = 0; index < ids.length; index++) { let id = ids[index]; f11.equalTo(l10, id); if (index != ids.length - 1) { f11.or(); } } this.store.delete(f11).then((num) => { m4.d(TAG, `store delete num:${num}`); d11(num); }).catch((err) => { m4.e(TAG, `store delete err:${stringify(err)}`); e11(err); }); }); } q5() { return new Promise((x10, y10) => { if (!this.store) { m4.e(TAG, "qc failed"); return y10("error"); } this.store.querySql("select count(*) from " + w7 + ";") .then((result) => { if (result && result.goToNextRow()) { let b11 = result.getLong(0); m4.e(TAG, "qc result:" + b11); result.close(); x10(b11); } else { y10("queryCount result is error"); } }).catch((error) => { return y10("queryCount error " + error?.message); }); }); } r5(...p10) { return new Promise((r10, s10) => { if (!this.store) { m4.e(TAG, "get failed"); return s10("error"); } let predicates = new relationalStore.RdbPredicates(w7); predicates.limitAs(10); this.store.query(predicates, (err, resultSet) => { if (err) { m4.e(TAG, `get failed, code is ${err.code},message is ${err.message}`); return s10(`error ${err}`); } let u10 = new Array(); while (resultSet.goToNextRow()) { const url = resultSet.getString(resultSet.getColumnIndex(m10)); const v10 = resultSet.getLong(resultSet.getColumnIndex(d8)); const time = resultSet.getLong(resultSet.getColumnIndex(c8)); const localId = resultSet.getString(resultSet.getColumnIndex(l10)); let result = new j10(localId, url, v10); u10.push(result); } resultSet.close(); return r10(u10); }); }); } updateState(state) { let predicates = new relationalStore.RdbPredicates(w7); predicates.equalTo(l10, state.getId()); let time = systemDateTime.getTime(); const valueBucket = { 'track_id': state.getId(), 'url': state.getUrl(), 'retry_count': state.v5(), 'ts': time }; this.store.update(valueBucket, predicates, relationalStore.ConflictResolution.ON_CONFLICT_REPLACE); } s5(id) { let predicates = new relationalStore.RdbPredicates(w7); predicates.equalTo(l10, id); let value = systemDateTime.getTime(); const valueBucket = { timestamp: value }; return this.store.update(valueBucket, predicates, relationalStore.ConflictResolution.ON_CONFLICT_REPLACE); } } export const o10 = new n10(); 