import relationalStore from '@ohos.data.relationalStore'; import systemDateTime from '@ohos.systemDateTime'; import HashMap from "@ohos.util.HashMap"; import { TemplateIdl } from "./u21"; import { m4 } from "../../../o2/t2/u2"; const y175 = { name: "Csj_Template.db", securityLevel: relationalStore.SecurityLevel.S1 }; const z175 = "Template"; const a176 = `CREATE TABLE IF NOT EXISTS ${z175} (
    templateId VARCHAR(255) PRIMARY KEY,
    templateMd5 VARCHAR(255),
    templateData LONGTEXT,
    timestamp TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);`; const TAG = "TemplateDb"; const f8 = 1000 * 60 * 60 * 24 * 7; export class b176 { o133(context, w176) { relationalStore.getRdbStore(context, y175, (err, y176) => { this.store = y176; if (err) { console.error(TAG, `getStore failed, code is ${err.code},message is ${err.message}`); return; } console.info(TAG, 'getStore successfully.'); this.store.executeSql(a176, (err) => { if (err) { console.error(TAG, `createDb failed, code is ${err.code},message is ${err.message}`); return; } console.info(TAG, `createDb successfully`); systemDateTime.getCurrentTime().then(time => { let predicates = new relationalStore.RdbPredicates(z175); predicates.lessThan("timestamp", time - f8); this.store.delete(predicates).then((rows) => { console.info(TAG, `clear Datas rows : ${rows}`); this.c108(w176); }).catch((error) => { console.info(TAG, `get time failed : ${error}`); this.c108(w176); }); }); }); }); } h108(templateId, s176, t176) { if (!this.store) { console.error(TAG, "saveTemplateData 失败，未初始化"); return; } systemDateTime.getCurrentTime().then((time) => { const valueBucket = { "templateId": templateId, "templateMd5": s176, "templateData": t176, "timestamp": time }; let predicates = new relationalStore.RdbPredicates(z175); predicates.equalTo("templateId", templateId); this.store.insert(z175, valueBucket, (err, rows) => { if (err) { console.error(TAG, `saveTemplateData Updated failed, code is ${err.code},message is ${err.message}`); return; } console.info(TAG, `saveTemplateData Updated row count: ${rows}`); }); }); } c95(templateId, l176) { return new Promise((n176, o176) => { if (!this.store) { console.error(TAG, "getTemplateData failed"); return n176(""); } let predicates = new relationalStore.RdbPredicates(z175); predicates.equalTo("templateId", templateId); this.store.query(predicates, (err, resultSet) => { if (err) { console.error(TAG, `getTemplateData failed, code is ${err.code},message is ${err.message}`); return n176(""); } let result = ""; while (resultSet.goToNextRow()) { let q176 = resultSet.getString(resultSet.getColumnIndex("templateData")); let r176 = resultSet.getString(resultSet.getColumnIndex("templateMd5")); let timeStamp = resultSet.getString(resultSet.getColumnIndex("timestamp")); console.info(TAG, "findTime:" + timeStamp); if (r176 == l176) { result = q176; this.s5(templateId); } } resultSet.close(); if (!result) { this.store.delete(predicates); } console.info(TAG, `getTemplateData finish , data is : ${result}`); return n176(result); }); }); } async c108(j176) { let predicates = new relationalStore.RdbPredicates(z175); this.store.query(predicates, (err, resultSet) => { if (err) { console.error(TAG, `getTemplateData failed, code is ${err.code},message is ${err.message}`); return; } let result = new HashMap(); console.log(TAG, "读取到多少个:" + resultSet.rowCount); while (resultSet.goToNextRow()) { let template = new TemplateIdl(); template.id = resultSet.getString(resultSet.getColumnIndex("templateId")); template.md5 = resultSet.getString(resultSet.getColumnIndex("templateMd5")); template.data = resultSet.getString(resultSet.getColumnIndex("templateData")); result.set(template.id, template); } resultSet.close(); j176.setAll(result); }); } s5(templateId) { let predicates = new relationalStore.RdbPredicates(z175); predicates.equalTo("templateId", templateId); systemDateTime.getCurrentTime().then((time) => { const valueBucket = { timestamp: time }; this.store.update(valueBucket, predicates, relationalStore.ConflictResolution.ON_CONFLICT_REPLACE); }); } r133(c176) { m4.d(TAG, "checkAndDelete start"); let predicates = new relationalStore.RdbPredicates(z175); predicates.orderByAsc("timestamp"); this.store.query(predicates, (err, resultSet) => { if (err) { console.error(TAG, `checkAndDelete failed, code is ${err.code},message is ${err.message}`); return; } console.log(TAG, "checkAndDelete now：" + resultSet.rowCount + "；max：" + c176); if (resultSet.rowCount > c176) { let e176 = Math.floor(c176 * 0.25); let f176 = -1; let g176 = 0; while (resultSet.goToNextRow()) { if (g176 < e176) { g176++; f176 = resultSet.getLong(resultSet.getColumnIndex("timestamp")); } else { break; } } if (f176 != -1) { predicates.lessThanOrEqualTo("timestamp", f176); this.store.delete(predicates).then((number) => { console.log(TAG, "checkAndDelete delete number:" + number); }); } } resultSet.close(); }); } } export const g175 = new b176(); 