import { code } from './WebConstant';
import router from "@ohos.router";
export default class JsBridge {
    constructor(l7) {
        this.controller = l7;
    }
    initJsBridge() {
        this.controller.runJavaScript(code);
    }
    onLoadIntercept(j7) {
        console.info(`【JsBridge.onLoadIntercept】requestUrl=${j7?.getRequestUrl()}、method=${j7?.getRequestMethod()}`);
        let k7 = j7?.getRequestUrl();
        if (k7) {
            if (k7.startsWith(JsBridge.JS_BRIDGE_PREFIX)) {
            }
            else if (JsBridge.H5_QUIT_TAG == k7) {
                router.back();
                return true;
            }
            else if (k7.startsWith('http://') || k7.startsWith('https://')) {
            }
            else if (k7.startsWith('store://appgallery.huawei.com/app/detail') || k7.startsWith('store://appgallery.huawei.com/app/preview')) {
                this.startAppGalleryDetailAbility(k7);
                return true;
            }
            else {
            }
        }
        return false;
    }
    startAppGalleryDetailAbility(d7) {
        let e7 = {
            action: 'ohos.want.action.appdetail',
            uri: d7,
        };
        const f7 = getContext(this);
        f7.startAbility(e7).then(() => {
            console.error('Start Ability successfully.');
        }).catch((i7) => {
            console.error(`Failed to startAbility. Code: ${i7.code}, message: ${i7.message}`);
        });
    }
}
JsBridge.JS_BRIDGE_PREFIX = "alipayjsbridge://";
JsBridge.H5_QUIT_TAG = "sdklite://h5quit";
