import util from '@ohos.util';
import { encodeRecord, mapToString, md5 } from './AFServerHelper';
let AFServiceSDKVersion = '15.8.03';
export class AFServiceTask {
    constructor(q4, r4, s4, t4, u4, v4) {
        this.extraInfo = new Map();
        this.session = '';
        this.isULink = false;
        this.callBackHandle = () => { };
        this.session = util.generateRandomUUID(true);
        this.appId = q4;
        this.bizParams = r4;
        this.extraInfo = t4;
        this.scheme = s4;
        this.wantParams = u4;
        this.callBackHandle = v4;
    }
    performWithBlock() {
        return this.buildUrlScheme().then((h4) => {
            let i4 = getContext(this);
            let j4 = {
                action: 'action.system.home',
                uri: h4
            };
            console.info("--------performWithBlock startAbility: scheme=" + h4);
            return i4.startAbility(j4).then(() => {
                return new Promise((p4) => {
                    p4(true);
                });
            }).catch(() => {
                return new Promise((n4) => {
                    n4(false);
                });
            });
        }).catch(() => {
            return new Promise((g4) => {
                g4(false);
            });
        });
    }
    performInH5() {
        return this.buildH5Url().then((u3) => {
            let v3 = getContext(this);
            let w3 = {
                "action": "ohos.want.action.viewData",
                "entities": ["entity.system.browsable"],
                "uri": u3
            };
            return v3.startAbility(w3).then(() => {
                return new Promise((c4) => {
                    c4(true);
                });
            }).catch(() => {
                return new Promise((a4) => {
                    a4(false);
                });
            });
        }).catch(() => {
            return new Promise((t3) => {
                t3(false);
            });
        });
    }
    async buildH5Url() {
        let j3 = new Map();
        if (this.appId) {
            j3.set('appId', this.appId);
        }
        if (this.bizParams) {
            this.bizParams.forEach((o3, p3) => {
                j3.set(p3, o3.toString());
            });
        }
        j3.set('mqpScheme', this.scheme ?? '');
        j3.set('mqpNotifyName', this.session);
        let k3 = getContext(this);
        j3.set('mqpPkgName', k3.applicationInfo.name);
        j3.set('mqpScene', 'landing');
        j3.set('nojump', 'true');
        let l3 = await this.appLinkTokenFromOrder(JSON.stringify(this.bizParams));
        j3.set('ap_link_token', l3);
        let m3 = mapToString(j3);
        return `https://render.alipay.com/p/s/i?scheme=alipays://platformapi/startapp?${m3}`;
    }
    async buildUrlScheme() {
        let g3 = {};
        g3['scheme'] = this.scheme ?? '';
        g3['session'] = this.session;
        let h3 = await this.urlByQueryParams();
        g3['authUrl'] = h3;
        g3['wantParams'] = JSON.stringify(this.wantParams);
        let i3 = encodeRecord(g3);
        return `apmqpdispatch://dispatch/payload?${i3}`;
    }
    async urlByQueryParams() {
        let f3 = await this.buildQuery();
        return `alipays://platformapi/startapp?${f3}`;
    }
    async buildQuery() {
        let u2 = new Map();
        if (this.appId) {
            u2.set('appId', this.appId);
        }
        if (this.bizParams) {
            this.bizParams.forEach((d3, e3) => {
                u2.set(e3, d3.toString());
            });
        }
        let v2 = {};
        if (this.extraInfo) {
            this.extraInfo.forEach((a3, b3) => {
                v2[b3] = a3;
            });
        }
        let w2 = getContext(this);
        let x2 = w2.applicationInfo.name;
        v2['ts_callsp'] = Date.now().toString();
        v2['ts_callsp_type'] = this.isULink ? 'ulink' : 'scheme';
        let y2 = await this.appLinkTokenFromOrder(JSON.stringify(this.bizParams));
        v2['token'] = y2;
        v2['sdk_ver'] = AFServiceSDKVersion;
        v2['app_name'] = x2;
        u2.set('mqpPkgName', x2);
        u2.set('mqpScene', 'sdk');
        u2.set('mqpLoc', encodeURIComponent(JSON.stringify(v2)));
        u2.set('mqpNotifyName', this.session);
        return mapToString(u2);
    }
    async appLinkTokenFromOrder(o2) {
        let p2 = getContext(this);
        let q2 = p2.applicationInfo.name;
        let r2 = Date.now().toString();
        let s2 = this.session;
        let t2 = await md5(`${o2}${q2}${r2}${s2}`);
        return `EP1${t2}${Date.now().toString()}`;
    }
}
