if (!("finalizeConstruction" in ViewPU.prototype)) {
    Reflect.set(ViewPU.prototype, "finalizeConstruction", () => { });
}
import web_webview from '@ohos.web.webview';
import router from "@ohos.router";
import { webRouterName } from './web/WebConstant';
import JSBridge from './web/JsBridge';
import window from '@ohos.window';
class AFServiceWeb extends ViewPU {
    constructor(w6, x6, y6, z6 = -1, a7 = undefined, b7) {
        super(w6, y6, z6, b7);
        if (typeof a7 === "function") {
            this.paramsGenerator_ = a7;
        }
        this.__pageParams = new ObservedPropertyObjectPU(router.getParams(), this, "pageParams");
        this.__progress = new ObservedPropertySimplePU(0, this, "progress");
        this.__hideProcess = new ObservedPropertySimplePU(true, this, "hideProcess");
        this.__webTitle = new ObservedPropertySimplePU('支付宝', this, "webTitle");
        this.__statusBarHeight = new ObservedPropertySimplePU(0, this, "statusBarHeight");
        this.webController = new web_webview.WebviewController();
        this.jsBridge = new JSBridge(this.webController);
        this.context = getContext(this);
        this.setInitiallyProvidedValue(x6);
        this.finalizeConstruction();
    }
    setInitiallyProvidedValue(v6) {
        if (v6.pageParams !== undefined) {
            this.pageParams = v6.pageParams;
        }
        if (v6.progress !== undefined) {
            this.progress = v6.progress;
        }
        if (v6.hideProcess !== undefined) {
            this.hideProcess = v6.hideProcess;
        }
        if (v6.webTitle !== undefined) {
            this.webTitle = v6.webTitle;
        }
        if (v6.statusBarHeight !== undefined) {
            this.statusBarHeight = v6.statusBarHeight;
        }
        if (v6.webController !== undefined) {
            this.webController = v6.webController;
        }
        if (v6.jsBridge !== undefined) {
            this.jsBridge = v6.jsBridge;
        }
        if (v6.context !== undefined) {
            this.context = v6.context;
        }
    }
    updateStateVars(u6) {
    }
    purgeVariableDependenciesOnElmtId(t6) {
        this.__pageParams.purgeDependencyOnElmtId(t6);
        this.__progress.purgeDependencyOnElmtId(t6);
        this.__hideProcess.purgeDependencyOnElmtId(t6);
        this.__webTitle.purgeDependencyOnElmtId(t6);
        this.__statusBarHeight.purgeDependencyOnElmtId(t6);
    }
    aboutToBeDeleted() {
        this.__pageParams.aboutToBeDeleted();
        this.__progress.aboutToBeDeleted();
        this.__hideProcess.aboutToBeDeleted();
        this.__webTitle.aboutToBeDeleted();
        this.__statusBarHeight.aboutToBeDeleted();
        SubscriberManager.Get().delete(this.id__());
        this.aboutToBeDeletedInternal();
    }
    get pageParams() {
        return this.__pageParams.get();
    }
    set pageParams(s6) {
        this.__pageParams.set(s6);
    }
    get progress() {
        return this.__progress.get();
    }
    set progress(r6) {
        this.__progress.set(r6);
    }
    get hideProcess() {
        return this.__hideProcess.get();
    }
    set hideProcess(q6) {
        this.__hideProcess.set(q6);
    }
    get webTitle() {
        return this.__webTitle.get();
    }
    set webTitle(p6) {
        this.__webTitle.set(p6);
    }
    get statusBarHeight() {
        return this.__statusBarHeight.get();
    }
    set statusBarHeight(o6) {
        this.__statusBarHeight.set(o6);
    }
    aboutToAppear() {
        this.getStatusBarHeight();
    }
    async getStatusBarHeight() {
        const k6 = getContext(this);
        let l6 = await k6.windowStage.getMainWindow();
        let m6 = l6?.getWindowProperties()?.isLayoutFullScreen ?? false;
        if (m6) {
            let n6 = l6?.getWindowAvoidArea(window.AvoidAreaType.TYPE_SYSTEM)?.topRect?.height ?? 0;
            this.statusBarHeight = px2vp(n6);
        }
        console.info(`[AFServiceWeb.getLastWindow] isLayoutFullScreen=${m6}, statusBarHeight=${this.statusBarHeight}`);
    }
    initialRender() {
        this.observeComponentCreation2((i6, j6) => {
            RelativeContainer.create();
            RelativeContainer.height('100%');
        }, RelativeContainer);
        this.observeComponentCreation2((g6, h6) => {
            Text.create();
            Text.height(this.statusBarHeight);
            Text.id("afs_web_status_bar");
            Text.alignRules({
                top: { anchor: '__container__', align: VerticalAlign.Top }
            });
        }, Text);
        Text.pop();
        this.observeComponentCreation2((e6, f6) => {
            Row.create();
            Row.height('8%');
            Row.width('100%');
            Row.padding({
                left: 12,
                top: 12,
                right: 12,
                bottom: 12
            });
            Row.alignItems(VerticalAlign.Center);
            Row.alignRules({
                top: { anchor: 'afs_web_status_bar', align: VerticalAlign.Bottom },
                left: { anchor: '__container__', align: HorizontalAlign.Start },
                right: { anchor: '__container__', align: HorizontalAlign.End }
            });
            Row.id("afs_web_title_bar");
        }, Row);
        this.observeComponentCreation2((b6, c6) => {
            Image.create({ "id": -1, "type": 20000, params: ["app.media.afs_ic_back"], "bundleName": "__harDefaultBundleName__", "moduleName": "__harDefaultModuleName__" });
            Image.width(24);
            Image.height(24);
            Image.objectFit(ImageFit.Fill);
            Image.onClick(() => {
                router.back();
            });
        }, Image);
        this.observeComponentCreation2((z5, a6) => {
            Text.create(this.webTitle);
            Text.width(100);
            Text.height(24);
            Text.fontSize(20);
            Text.fontWeight(700);
            Text.fontColor(Color.Black);
            Text.margin({ left: 15 });
        }, Text);
        Text.pop();
        this.observeComponentCreation2((x5, y5) => {
            Blank.create();
        }, Blank);
        Blank.pop();
        this.observeComponentCreation2((u5, v5) => {
            Image.create({ "id": -1, "type": 20000, params: ["app.media.afs_ic_refresh"], "bundleName": "__harDefaultBundleName__", "moduleName": "__harDefaultModuleName__" });
            Image.width(24);
            Image.height(24);
            Image.objectFit(ImageFit.Fill);
            Image.onClick(() => {
                this.progress = 0;
                this.webController.refresh();
            });
        }, Image);
        Row.pop();
        this.observeComponentCreation2((s5, t5) => {
            Progress.create({ total: 100, value: this.progress });
            Progress.color("#ff108EE9");
            Progress.visibility(this.hideProcess ? Visibility.None : Visibility.Visible);
            Progress.alignRules({
                top: { anchor: 'afs_web_title_bar', align: VerticalAlign.Bottom },
                left: { anchor: '__container__', align: HorizontalAlign.Start },
                right: { anchor: '__container__', align: HorizontalAlign.End }
            });
            Progress.id("afs_web_progress");
        }, Progress);
        this.observeComponentCreation2((i5, j5) => {
            Web.create({ src: this.pageParams?.['url'] ?? "", controller: this.webController });
            Web.onProgressChange(q5 => {
                let r5 = q5?.newProgress ?? 100;
                if (r5 >= this.progress) {
                    this.progress = r5;
                }
                if (this.progress >= 100) {
                    this.hideProcess = true;
                }
                else {
                    this.hideProcess = false;
                }
            });
            Web.javaScriptAccess(true);
            Web.fileAccess(true);
            Web.multiWindowAccess(true);
            Web.onLoadIntercept(p5 => {
                return this.jsBridge.onLoadIntercept(p5.data) ?? false;
            });
            Web.onTitleReceive(o5 => {
                console.info(`[AFServiceWeb.web.onTitleReceive] title=${o5?.title}`);
                if (o5?.title) {
                }
            });
            Web.onPageBegin(() => {
                this.jsBridge.initJsBridge();
            });
            Web.alignRules({
                top: { anchor: 'afs_web_progress', align: VerticalAlign.Bottom },
                left: { anchor: '__container__', align: HorizontalAlign.Start },
                right: { anchor: '__container__', align: HorizontalAlign.End },
                bottom: { anchor: '__container__', align: VerticalAlign.Bottom }
            });
            Web.id("afs_web_container");
        }, Web);
        RelativeContainer.pop();
    }
    rerender() {
        this.updateDirtyElements();
    }
    static getEntryName() {
        return "AFServiceWeb";
    }
}
{
    let x4 = webRouterName;
    registerNamedRoute(() => new AFServiceWeb(undefined, {}), x4, { bundleName: "__harDefaultBundleName__", moduleName: "__harDefaultModuleName__", pagePath: "__harDefaultPagePath__", pageFullPath: "", integratedHsp: "__harDefaultIntegratedHspType__" });
}
