/*
 * Decompiled with CFR 0.152.
 */
package com.bykv.vk.component.ttvideo;

import android.content.Context;
import android.net.Uri;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.SystemClock;
import android.text.TextUtils;
import android.view.Surface;
import android.view.SurfaceHolder;
import com.bykv.vk.component.ttvideo.AppInfo;
import com.bykv.vk.component.ttvideo.ILiveListener;
import com.bykv.vk.component.ttvideo.ILivePlayer;
import com.bykv.vk.component.ttvideo.ILiveSettingBundle;
import com.bykv.vk.component.ttvideo.INetworkClient;
import com.bykv.vk.component.ttvideo.LibraryLoader;
import com.bykv.vk.component.ttvideo.LiveConfigKey;
import com.bykv.vk.component.ttvideo.MyInvocationHandler;
import com.bykv.vk.component.ttvideo.log.LiveError;
import com.bykv.vk.component.ttvideo.log.LiveLoggerService;
import com.bykv.vk.component.ttvideo.log.LogBundle;
import com.bykv.vk.component.ttvideo.log.MyLog;
import com.bykv.vk.component.ttvideo.medialoader.MediaLoaderListener;
import com.bykv.vk.component.ttvideo.medialoader.MediaLoaderWrapper;
import com.bykv.vk.component.ttvideo.model.LiveInfoSource;
import com.bykv.vk.component.ttvideo.model.LiveStreamInfo;
import com.bykv.vk.component.ttvideo.model.LiveURL;
import com.bykv.vk.component.ttvideo.network.DnsHelper;
import com.bykv.vk.component.ttvideo.network.LiveDataFetcher;
import com.bykv.vk.component.ttvideo.player.Keep;
import com.bykv.vk.component.ttvideo.player.MediaPlayer;
import com.bykv.vk.component.ttvideo.player.TTPlayerConfiger;
import com.bykv.vk.component.ttvideo.playerwrapper.MediaPlayerWrapper;
import com.bykv.vk.component.ttvideo.playerwrapper.PlayerSetting;
import com.bykv.vk.component.ttvideo.retry.RetryProcessor;
import com.bykv.vk.component.ttvideo.utils.LiveThreadPool;
import com.bykv.vk.component.ttvideo.utils.LiveUtils;
import com.bytedance.sdk.component.g.t.pl;
import com.bytedance.sdk.component.g.t.t;
import com.bytedance.sdk.component.utils.q;
import com.bytedance.sdk.openadsdk.api.plugin.j;
import com.bytedance.sdk.openadsdk.dy.l;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Keep
public final class VideoLiveManager
implements ILivePlayer {
    private static final String TAG = "VideoLiveManager";
    public static final int KeyIsGetStreamMaxBitrate = 0;
    public static final int KeyIsGetSeiDelay = 100;
    private static final int INIT_MTU = 1200;
    private static final int AV_NO_SYNC_THRESHOLD = 10000;
    private static final int LIVE_ABR_CHECK_DEFAULT_INTERVAL = 1000;
    private static final int MEDIA_PLAYER_OPTION_SET_LIVE_PROTOCOL_HANDLE = 501;
    private final Handler mMyHandler = new Handler(Looper.myLooper());
    private static final int MSG_SEI_CHECK = 110;
    private static final int CHECK_SEI_INTERVAL = 3000;
    private static final int NOTIFY_ALL_SEI_THRESHOLD = 1000;
    private static final String SEI_PREFIX = "JSON";
    private static final int DEFAULT_RTC_FALLBACK_THRESHOLD = 5000;
    private static final int DEFAULT_RTC_MIN_JITTER_BUFFER = 300;
    private static final String HTTP_FLV_ABR_PREFIX = "mem://llash/";
    private LiveLoggerService mLogService;
    private final Context mContext;
    private final INetworkClient mNetworkClient;
    private final ILiveListener mListener;
    private final ILiveSettingBundle mSettingsBundle;
    private final int mPlayerType;
    private final DnsHelper mDnsParser;
    private final RetryProcessor mRetryProcessor;
    private final PlayerSetting mPlayerSetting;
    private final LiveInfoSource mURLSource = new LiveInfoSource();
    private MediaPlayer mPlayer;
    private LiveDataFetcher mFetcher;
    private SurfaceHolder mSurfaceHolder;
    private Surface mSurface;
    private int mEnableTextureRender = 0;
    private int mEnableTextureSR = 0;
    private boolean mResolutionDisableSR = true;
    private String mTextureSRBinPath = "none";
    private String mTextureSROclModuleName = "test";
    private String mTextureSRDspModuleName = "test";
    private String mTextureRenderErrorMsg = null;
    private int mEnableOpenMDL = 0;
    private boolean mIsMdlProtoRegister = false;
    private boolean mIsPlayWithMdl = false;
    private PlayerState mPrepareState = PlayerState.IDLE;
    private LivePlayerState mLivePlayerState = LivePlayerState.IDLE;
    private boolean mIsRequestCanceled = false;
    private boolean mShowedFirstFrame = false;
    private boolean mHasRetry = false;
    private boolean mLooping = false;
    private int mPlayerCache = 0;
    private int mEnhancementType = 0;
    private int mScaleType = 0;
    private int mLayoutType = 0;
    private int mRenderType = 3;
    private int mHardwareDecodeEnable = 0;
    private int mHardwareRTCDecodeEnable = 0;
    private int mCacheFileEnable = -1;
    private int mTestAction = -1;
    private int mUseExternalDir = -1;
    private int mMaxFileCacheSize = -1;
    private int mByteVC1DecoderType = 1;
    private int mBufferDataSeconds = -1;
    private int mBufferTimeout = -1;
    private int mNetworkTimeout = -1;
    private int mPlayerDegradeMode = 0;
    private int mEnableSharp = 0;
    private int mDefaultCodecId = -1;
    private int mEnableMediaCodecASYNCInit = 0;
    private int mHurryType = -1;
    private int mHurryTime = 0;
    private float mCatchSpeed = -1.0f;
    private int mSlowPlayTime = -1;
    private float mSlowPlaySpeed = -1.0f;
    private int mEnableHurryFlag = -1;
    private String mCacheFilePath = null;
    private String mCacheFileKey = null;
    private boolean mIsCacheHasComplete = false;
    private String mCurrentPlayURL = null;
    private String mCurrentIP = null;
    private int mStallCount = 0;
    private boolean mIsStalling = false;
    private boolean mEnableResolutionAutoDegrade = false;
    private String mAbrStrategy = "rad";
    private boolean mHasAbrInfo = false;
    private int mDefaultResBitrate = -1;
    private int mStallCountThresOfResolutionDegrade = 4;
    private boolean mEnableSwitchMainAndBackupUrl = true;
    private int mEnableVideoMpdRefresh = 1;
    private int mEnableCmafFastMode = 0;
    private int mEnableCmafOptimizeRetry = 0;
    private int mEnableDTSCheck = 0;
    private int mEnablePreventDTSBack = 0;
    private long mFrameDroppingDTSMaxDiff = 10000L;
    private long mFrameTerminatedDTS = -1L;
    private long mLatestAudioPacketDTS = -1L;
    private String mSessionId = null;
    private int mEnableCheckFrame = 0;
    private int mEnableCheckSEI = 0;
    private int mGopDuration = 4;
    private Object mFrameMetaDataListener = null;
    private MyInvocationHandler mInvocationHandler = null;
    private String mLocalURL = null;
    private boolean mIsLocalURL = false;
    private long mALogWriteAddr = -1L;
    private String mResolution = "origin";
    private int mResolutionIndex = -1;
    private String mLevel = "main";
    private String mStreamFormat = "flv";
    private String mSuggestProtocol = "none";
    private String mTransportProtocol = "tcp";
    private String mURLProtocol = "none";
    private String mEnableAvLines = "";
    private String mVideoOnly = "";
    private String mAudioOnly = "";
    private String mReliable = "";
    private int mForceDecodeSwitch = 0;
    private int mForceDecodeMsGaps = 0;
    private int mForceRenderMsGaps = 0;
    private int mFramesDrop = 15;
    private int mAVPHDnsParseEnable = 0;
    private int mAVPHDnsTimeout = 2000000;
    private int mAVPHVideoProbesize = 4096;
    private int mAVPHVideoMaxDuration = 100000;
    private int mAVPHAudioProbesize = 4096;
    private int mAVPHAudioMaxDuration = 100000;
    private int mAVPHOpenVideoFirst = 1;
    private int mAVPHMaxAVDiff = 10000;
    private int mAVPHAutoExit = 1;
    private int mAVPHEnableAutoReopen = 0;
    private int mAVPHVideoDiffThreshold = 15000;
    private int mAVPHReadRetryCount = 100;
    private int mAVPHReadErrorExit = 1;
    private int mEnableSkipFindUnnecessaryStream = 0;
    private static int mVideoRenderStallThreshold = 500;
    private static int mAudioRenderStallThreshold = 200;
    private int mEnableRenderStall = 1;
    private long mAudioLastRenderTime = -1L;
    private long mVideoLastRenderTime = -1L;
    private boolean mIsRetrying = false;
    private int mEnableDemuxerStall = 1;
    private int mEnableDecoderStall = 1;
    private static int mDemuxerStallThreshold = 900;
    private static int mDecoderStallThreshold = 600;
    private static int mFastOpenDuration = -1;
    private int mEnableStallCounter = 0;
    private int mStallCounterInterval = 2000;
    private int mEnableClosePlayRetry = 0;
    private int mEnableCheckDropAudio = 0;
    private int mURLAbility = 1;
    private long mStallStartTime = 0L;
    private long mStallTotalTime = 0L;
    private long mRetryStartTime = 0L;
    private int mEnableNTP = 0;
    private int mEnableNTPTask = 0;
    private boolean mEnableDns = true;
    private boolean mEnableDnsOptimizer = false;
    private boolean mEnableUploadSessionSeries = false;
    private int mEnableH264HardwareDecode = 0;
    private int mEnableByteVC1HardwareDecode = 0;
    private int mMaxCacheSeconds = -1;
    private int mEnableSplitStream = 0;
    private int mOpenCheckSideData = 1;
    private int mEnableHttpkDegrade = 0;
    private int mEnableQuicDegrade = 1;
    private int mEnableFastOpenStream = 1;
    private int mEnableUploadSei = 1;
    private static boolean mIsSettingsUpdate = false;
    private static JSONObject mSettingsInfo = null;
    private long mSeiDiffThres = 8000L;
    private boolean mEnableSeiCheck = false;
    private boolean mHasSeiInfo = false;
    private long mGetSeiCurrentTime = 0L;
    private long mStartPlayBufferThres = 0L;
    private int mCheckBufferingEndIgnoreVideo = 0;
    private int mStartDirectAfterPrepared = 0;
    private int mCheckBufferingEndAdvanceEnable = 0;
    private int mEnableTcpFastOpen = 0;
    private int mEnableCheckPacketCorrupt = 0;
    private int mEnableLowLatencyFLV = 0;
    private JSONObject mLowLatencyFLVStrategy = null;
    private int mEnableDroppingDTSRollFrame = 0;
    private String mUuid;
    private int mIsInMainLooper = 1;
    private boolean mCmafEnable = false;
    private boolean mQuicEnable = false;
    private int mQuicVersion = 39;
    private boolean mEnableSaveSCFG = false;
    private boolean mEnableQuicCertVerify = false;
    private int mQuicInitMTU = 1200;
    private int mEnableQuicMTUDiscovery = 0;
    private int mQuicPadHello = 1;
    private int mQuicFixWillingAndAbleToWrite = 1;
    private int mQuicFixProcessTimer = 1;
    private int mQuicReadBlockTimeout = 100;
    private int mQuicReadBlockMode = 0;
    private int mQuicFixStreamFinAndRst = 0;
    private int mQuicConfigOptimize = 0;
    private int mQuicTimerVersion = 1;
    private boolean mQuicPull = false;
    private int mQuicInitRtt = 0;
    private int mQuicMaxCryptoRetransmissions = 0;
    private int mQuicMaxCryptoRetransmissionTimeMs = 0;
    private int mQuicMaxRetransmissions = 0;
    private int mQuicMaxRetransmissionTimeMs = 0;
    private int mQuicMaxAckDelay = 0;
    private int mQuicMinReceivedBeforeAckDecimation = 0;
    private int mSessionReceiveWindow = -1;
    private int mStreamReceiveWindow = -1;
    private int mAVNoSyncThreshold = 10000;
    private int mIsAlwaysDoAVSync = 0;
    private int mEnableFlvABR = 0;
    private int mEnableLLASHFastOpen = 0;
    private boolean mForceHttpDns = false;
    private String mHttpDNSServerHost = null;
    private boolean mCancelSDKDNSFailRetry = false;
    private int mUrlSettingMethod = -1;
    private boolean mUserSwitchResoultion = false;
    private boolean mEnterStallRetryInstantly = false;
    private int mEnableStallRetryInstantly = 1;
    private static final int VIDEOSTREAM = 0;
    private static final int AUDIOSTREAM = 1;
    private static final int BOTHSTREAM = 2;
    private List<String> mNodeOptimizeResults = null;
    private boolean mRedoDns = false;
    private int mEnableOptimizeBackup = 0;
    private boolean mSupportBackupIp = true;
    public static final int TEX_VOD = 0;
    public static final int TEX_LIVE = 1;
    public int mTextureSRMode = 0;
    public long mRenderStartNotifyTimeStamp = 0L;
    public boolean mRenderStartEntered = false;
    private int mEnableAudioVolumeBalance = 0;
    private float mAudioVolumeBalancePregain = -1.0f;
    private float mAudioVolumeBalanceThreshold = -1.0f;
    private float mAudioVolumeBalanceRatio = -1.0f;
    private float mAudioVolumeBalancePredelay = -1.0f;
    private int mEnableCacheSei = 0;
    private int mEnableDecodeMultiSei = 0;
    private int mEnableDecodeSeiOnce = 0;
    private int mEnableSkipFlvNullTag = 0;
    private int mEnableNotifySeiImmediatelyBeforeFirstFrame = 1;
    private int mEnableLiveAbrCheckEnhance = 0;
    private int mLiveABRCheckInterval = 1000;
    private int mABRMethod = -1;
    private int mABRBufferThreshold = -1;
    private int mTslTimeShift = -1;
    private int mTslMinTimeShit = 60;
    private boolean mEnableOriginResolution = false;
    private long mTargetOriginBitRate = -1L;
    private int mEnableAbrStallDegradeImmediately = 1;
    private int mHlsLiveStartIndex = -3;
    private String mCdnSessionPath = null;
    private String mCdnAbrResolution = null;
    private int mAudioTimescaleEnable = -1;
    public long mStallRetryTimeIntervalManager = 10000L;
    public boolean mMediaSupportSR = false;
    public int mSupportSRScene = 0;
    public boolean mCheckSupportSR = false;
    private HandlerThread mStallCounterThread = null;
    private Handler mStallCounterHandler = null;
    private final VideoStallCountTask mVideoStallCountTask = new VideoStallCountTask();
    private final Object mStallCounterLock = new Object();
    private volatile boolean mStallCounterIsRunning = false;
    private int mEnableRtcPlay = 0;
    private static final int RTC_VENDER_TYPE_BYTE = 0;
    private static final int RTC_VENDER_TYPE_ALIBABA = 1;
    private static final int RTC_VENDER_TYPE_TECENT = 2;
    private static final int RTC_VENDER_TYPE_OTHERS = 3;
    private static final String RTC_LOG_PREFIX = "rtc_log_level";
    private int mRtcPlayFallBack = 0;
    private int mRtcFallbackThreshold = 5000;
    private int mRtcEnableDtls = 1;
    private int mRtcMinJitterBuffer = 300;
    private int mRtcMaxJitterBuffer = 2000;
    private int mRtcEnableSDKDns = 0;
    private int mRtcEarlyInitRender = 0;
    private int mRtcMaxRetryCount = 0;
    private int mRtcSupportMiniSdp = 0;
    private int mCurrentRetryCount = 0;
    private int mRtcPlayLogInterval = 5000;
    private int mRtcEnableRtcUninitLockFree = 0;
    private static final int BITRATE_NORMAL = 0;
    private static final int BITRATE_ABNORNAL = 1;
    public int mEnableRadioLiveDisableRender = 0;
    private int mSwitchToB = 0;
    private String mMoudleIDToB = "";
    private String mURLHost = "";
    private static final int STALl_NO_RECOVER = 0;
    private static final int STALL_RECOVER_FROM_BUFFERINGEND = 1;
    private static final int STALL_RECOVER_FROM_RETRY = 2;
    private int mABRDisableAlgorithm = 0;
    private boolean mTextureRenderFirstFrame = false;
    private boolean mUsePlayerRenderStart = false;
    private int mMaxTextureWidth = 0;
    private int mMaxTextureHeight = 0;
    private int mEnableReportSessionStop = 0;
    private int mSessionNum = 0;
    private long mSessionStartTime = 0L;
    private long mSessionRenderStartTime = 0L;
    private boolean mIsLiveIOProtoRegister = false;
    private int mEnableOpenLiveIO = 0;
    private boolean mIsPlayWithLiveIO = false;
    private int mEnableLiveIOPlay = 0;
    private int mEnableLiveIOP2P = 0;
    private int mEnableHttpPrepare = 0;
    private int mEnableFreeFlow = 0;
    private int mEnableP2pUp = 0;
    private int mLiveIOABGroupID = 0;
    private int mNoSyncReportMinDuration = 5000;
    private int mNoSyncReportReportThres = 2000;
    private int mEnableUseLiveThreadPool = 0;
    private ExecutorService mExecutor = null;
    public int mEnableSharpen = 0;
    private int mSharpenMode = 0;
    private boolean mMediaSupportSharpen = false;
    private int mSupportSharpenScene = -1;
    private int mSharpenMaxWidth = 1920;
    private int mSharpenMaxHeight = 1080;
    private int mSharpenPowerLevel = 0;
    private float mSharpenAmount = -1.0f;
    private float mSharpenOverRatio = -1.0f;
    private float mSharpenEdgeWeightGamma = 6.0f;
    private int mSharpenSceneMode = 1;
    private JSONObject mSharpenSdkParams = null;

    private void runOnCurrentThread(Runnable runnable) {
        this.mMyHandler.post(runnable);
    }

    private void runOnCurrentThreadDelay(Runnable runnable, long l2) {
        this.mMyHandler.postDelayed(runnable, l2);
    }

    private void runOnFrontCurrentThread(Runnable runnable) {
        this.mMyHandler.postAtFrontOfQueue(runnable);
    }

    private VideoLiveManager(Builder builder) {
        this.mContext = builder.mContext;
        this.mListener = builder.mListener;
        this.mSettingsBundle = builder.mSettingsBundle;
        builder.setStallRetryInterval(this.mStallRetryTimeIntervalManager);
        if (this.mSettingsBundle != null) {
            this.mEnableReportSessionStop = this.mSettingsBundle.getSettingsValueForKey("live_sdk_should_report_session_stop", 0);
            this.mEnableUseLiveThreadPool = this.mSettingsBundle.getSettingsValueForKey("live_sdk_enable_use_live_threadpool", 0);
        }
        if (this.mEnableUseLiveThreadPool == 1 && builder.mLiveThreadPool != null) {
            MyLog.i(TAG, "use live threadpool");
            this.mExecutor = builder.mLiveThreadPool;
            this.mLogService.mUseLiveThreadPool = 1;
        } else {
            MyLog.i(TAG, "create new threadpool");
            this.mExecutor = new t(1, 3, 60L, TimeUnit.SECONDS, (BlockingQueue)new LinkedBlockingDeque(), (ThreadFactory)new NamedThreadFactory(){});
        }
        VideoLiveManager videoLiveManager = this;
        this.mLogService = new LiveLoggerService(videoLiveManager, videoLiveManager.mListener, builder.mUploadLogInterval, builder.mStallRetryTimeInterval, this.mContext, this.mEnableReportSessionStop);
        this.mLogService.setProjectKey(builder.mProjectKey);
        MediaLoaderWrapper.getDataLoader().setLogService(this.mLogService);
        this.mRetryProcessor = new RetryProcessor(new MyRetryListener(this), builder.mRetryTimeout, builder.mStallRetryTimeInterval, this.mLogService);
        this.mPlayerSetting = new PlayerSetting(this.mContext, null);
        this.mLogService.mEnableHttpDns = this.mForceHttpDns = builder.mForceHttpDns;
        this.mNetworkClient = builder.mNetworkClient;
        this.mDnsParser = new DnsHelper(this.mContext, this.mExecutor, this.mNetworkClient);
        this.mDnsParser.updateDNSServerIP();
        this.mPlayerType = builder.mPlayerType;
        this.mStreamFormat = builder.mVideoFormat;
        this.mResolution = builder.mResolution;
        this.mStallCount = 0;
        this.mEnableResolutionAutoDegrade = builder.mEnableResolutionAutoDegrade;
        this.mEnableSwitchMainAndBackupUrl = builder.mEnableSwitchMainAndBackupUrl;
        this.mSeiDiffThres = builder.mSeiCheckTimeOut;
    }

    @Override
    public void setSurfaceHolder(SurfaceHolder surfaceHolder) {
        this.checkMainLooper("setSurfaceHolder");
        this.mSurfaceHolder = surfaceHolder;
        if (this.mPlayer != null) {
            this.mLogService.mSetSurfaceTime = System.currentTimeMillis();
            this.mPlayer.setDisplay(surfaceHolder);
            this.mLogService.mSetSurfaceCost = System.currentTimeMillis() - this.mLogService.mSetSurfaceTime;
        }
    }

    @Override
    public void setSurface(Surface surface) {
        this.checkMainLooper("setSurface");
        MyLog.i(TAG, "setsurface: " + surface);
        this.mSurface = surface;
        if (this.mPlayer != null) {
            this.mLogService.mSetSurfaceTime = System.currentTimeMillis();
            this.mPlayer.setSurface(surface);
            this.mLogService.mSetSurfaceCost = System.currentTimeMillis() - this.mLogService.mSetSurfaceTime;
        }
    }

    @Override
    public void setPlayURLs(LiveURL[] liveURLArray) {
        MyLog.i(TAG, "setPlayUrls, sdkParam:" + liveURLArray[0].sdkParams);
        this.checkMainLooper("setPlayURLS");
        this.mURLSource.setPlayURLs(liveURLArray);
        this.mUrlSettingMethod = 0;
        if (this.mCurrentPlayURL != null && this.mURLSource.getPlayLiveURL().mainURL != this.mCurrentPlayURL) {
            this._reset("setPlayURLs");
        }
    }

    @Override
    public boolean playResolution(String string) {
        MyLog.i(TAG, "playResolution:" + string);
        this.checkMainLooper("playResolution");
        if (this.mURLSource.getSourceType() != 2 || this.mPrepareState != PlayerState.PREPARED) {
            return false;
        }
        if (this.mResolution.equals(string)) {
            MyLog.i(TAG, "playResolution: same res=" + string);
            return true;
        }
        this.mRetryProcessor.reset();
        this.mResolutionIndex = -1;
        this.mStallCount = 0;
        String string2 = "none";
        this.mLogService.onSwitch(this.mCurrentPlayURL, string2, "setting_" + this.mResolution + "_to_" + string, 0);
        this.mLogService.mAbrSwitchInfo = "manual_abr_" + this.mResolution + "_to_" + string;
        this.saveCurrentResolution();
        this.mResolution = string;
        if (this.mAbrStrategy.equals("abr_bb_4live") || this.mAbrStrategy.equals("rad") && !string.equals("auto")) {
            string2 = this.mURLSource.getPlayURLForResolution(this.mResolution.equals("auto") ? this.mURLSource.getDefaultResolution() : this.mResolution, this.mStreamFormat, this.mLevel);
            if (TextUtils.isEmpty((CharSequence)string2)) {
                MyLog.w(TAG, string + " playUrl not exist");
                return false;
            }
            this.updateDownloadSizeStat();
            this.mLogService.onSessionStop();
            this.mIsRetrying = true;
            this._stopPlayer();
            this._resetPlayer();
            this.mLogService.onSwitchURL(string2);
            this.mUserSwitchResoultion = true;
            this.mLogService.mSessionStartTime = System.currentTimeMillis();
            this.parsePlayDNS(string2);
        }
        return true;
    }

    @Override
    public void setStreamInfo(String string) {
        MyLog.i(TAG, "setStreamInfo:" + string);
        this.mLogService.mStreamData = string;
        this.checkMainLooper("setStreamInfo");
        try {
            string = new JSONObject(string);
        }
        catch (JSONException jSONException) {
            string = null;
            q.d(jSONException);
        }
        if (string == null) {
            return;
        }
        this._reset("setStreamInfo");
        this.mURLSource.setStreamInfo(new LiveStreamInfo((JSONObject)string));
        this.mUrlSettingMethod = 1;
        this._setLooseSync();
    }

    private void _setLooseSync() {
        if (this.mURLSource == null) {
            return;
        }
        String string = this.mURLSource.getSDKParams(this.mResolution, this.mLevel);
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        try {
            string = new JSONObject(string);
            if (string.has("ForceDecodeSwitch")) {
                this.mForceDecodeSwitch = string.optInt("ForceDecodeSwitch");
            }
            if (string.has("ForceDecodeMsGaps")) {
                this.mForceDecodeMsGaps = string.optInt("ForceDecodeMsGaps");
            }
            if (string.has("ForceRenderMsGaps")) {
                this.mForceRenderMsGaps = string.optInt("ForceRenderMsGaps");
            }
            return;
        }
        catch (JSONException jSONException) {
            q.d(jSONException);
            return;
        }
    }

    private void _setStreamFormat() {
        String string = this.mURLSource.getSuggestFormat(this.mResolution, this.mLevel);
        if (string != null) {
            String string2 = string;
            if (string.equals("cmaf") && !this.mCmafEnable) {
                try {
                    LibraryLoader.loadLibrary("ttmcmaf");
                    this.mCmafEnable = true;
                    MyLog.i(TAG, "cmaf lib is load success");
                }
                catch (Throwable throwable) {
                    this.mURLSource.setStreamInfoFlag(1);
                    string2 = this.mStreamFormat;
                    this.mCmafEnable = false;
                    MyLog.i(TAG, "cmaf lib is load failed. change default format");
                }
            } else if (string.equals("lls")) {
                this.mEnableRtcPlay = 1;
                this.mLogService.mEnableRtcPlay = 1;
                try {
                    MyLog.i(TAG, "lls load bytertc library");
                    l.d("byteaudio");
                    l.d("bytenn");
                    l.d("bytertc");
                    MyLog.i(TAG, "lls load bytertc library done");
                }
                catch (Throwable throwable) {
                    this.mURLSource.setStreamInfoFlag(2);
                    string2 = this.mStreamFormat;
                    this.mEnableRtcPlay = 0;
                    this.mLogService.mEnableRtcPlay = 0;
                    MyLog.i(TAG, "bytertc lib is load failed. change default format");
                }
            }
            this.mStreamFormat = string2;
            this.mLogService.setFormatInfo(string, this.mStreamFormat);
        } else {
            this.mStreamFormat = "flv";
            this.mLogService.setFormatInfo("none", this.mStreamFormat);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mStreamFormat) && this.mStreamFormat.equals("flv")) {
            this._setAvLines();
            if (!this.mEnableAvLines.isEmpty() && !this.mVideoOnly.isEmpty() && !this.mAudioOnly.isEmpty() && this.mEnableAvLines.equals("true") && this.mVideoOnly.equals("only_video=1") && this.mAudioOnly.equals("only_audio=1")) {
                this.mStreamFormat = "avph";
                this.mLogService.setFormatInfo("avph", this.mStreamFormat);
            }
        }
        if (!TextUtils.isEmpty((CharSequence)this.mStreamFormat) && this.mStreamFormat.equals("avph")) {
            this._configAvphNeqStrategy();
        }
    }

    private void _setProtocol() {
        String string = this.mURLSource.getPlayURLForResolution(this.mResolution.equals("auto") ? this.mURLSource.getDefaultResolution() : this.mResolution, this.mStreamFormat, this.mLevel);
        if (string != null) {
            this.mLogService.setOriginUrl(string);
            if (string.startsWith("http")) {
                this.mTransportProtocol = "tcp";
            }
            if (string.startsWith("httpk")) {
                this.mTransportProtocol = "kcp";
            }
            if (string.startsWith("https")) {
                this.mTransportProtocol = "tls";
            }
            this.mURLProtocol = this.mTransportProtocol;
        }
        this.mSuggestProtocol = this.mURLSource.getSuggestProtocol(this.mResolution, this.mLevel);
        if (this.mSuggestProtocol != null) {
            string = this.mSuggestProtocol;
            if ((this.mSuggestProtocol.equals("quic") || this.mSuggestProtocol.equals("quicu")) && !this.mQuicEnable) {
                try {
                    LibraryLoader.loadLibrary("ttquic");
                    this.mQuicEnable = true;
                    MyLog.i(TAG, "ttquic lib is load success");
                    this.mLogService.setQuicLibLoader(1);
                }
                catch (Throwable throwable) {
                    string = this.mTransportProtocol;
                    this.mQuicEnable = false;
                    MyLog.i(TAG, "ttquic lib is load failed. change default protocol");
                    this.mLogService.setQuicLibLoader(0);
                }
            }
            this.mTransportProtocol = string;
            return;
        }
        this.mSuggestProtocol = "none";
    }

    private void _configAvphNeqStrategy() {
        String string = this.mSettingsBundle.getSettingsValueForKey("live_sdk_low_latency_flv_default_strategy_map", "");
        JSONObject jSONObject = null;
        if (string.length() > 0) {
            try {
                jSONObject = new JSONObject(string);
            }
            catch (JSONException jSONException) {
                q.d(jSONException);
            }
        }
        if (jSONObject == null) {
            return;
        }
        if (jSONObject.has("net_effective_connection_type_strategy")) {
            string = null;
            try {
                string = jSONObject.getJSONObject("net_effective_connection_type_strategy");
            }
            catch (JSONException jSONException) {
                q.d(jSONException);
            }
            if (string == null) {
                return;
            }
            return;
        }
    }

    public void _setAvLines() {
        String string = this.mURLSource.getAvLinesParams(this.mResolution, this.mLevel);
        String string2 = null;
        String string3 = null;
        String string4 = null;
        if (string == null) {
            return;
        }
        try {
            string = new JSONObject(string);
            if (string.has("IsEnable")) {
                string2 = string.optString("IsEnable");
            }
            if (string.has("VideoOnly")) {
                string3 = string.optString("VideoOnly");
            }
            if (string.has("AudioOnly")) {
                string4 = string.optString("AudioOnly");
            }
        }
        catch (JSONException jSONException) {
            q.d(jSONException);
        }
        if (string2 != null) {
            this.mEnableAvLines = string2;
        }
        if (string3 != null) {
            this.mVideoOnly = string3;
        }
        if (string4 != null) {
            this.mAudioOnly = string4;
        }
    }

    public String set_url_port_scheme(String string, String string2) {
        String string3 = ".com";
        String string4 = ".com:";
        int n2 = string.indexOf(string3);
        int n3 = string.indexOf(string4);
        StringBuilder stringBuilder = new StringBuilder(string);
        if (string2 != null) {
            int n4;
            if (n3 != -1) {
                int n5;
                for (n5 = n3 + string4.length() + 1; n5 < stringBuilder.length() && stringBuilder.charAt(n5) - 48 >= 0 && stringBuilder.charAt(n5) - 48 <= 9; ++n5) {
                }
                stringBuilder.replace(n3 + string4.length(), n5, string2);
            } else if (n2 != -1 && ((n4 = string.indexOf("vhost")) == -1 || n4 > n2)) {
                stringBuilder.insert(n2 + string3.length(), ":" + string2);
            }
        }
        string = stringBuilder.toString();
        stringBuilder = new StringBuilder(string);
        int n6 = stringBuilder.indexOf("://");
        if (this.mURLSource.getSourceType() == 2) {
            if (this.mTransportProtocol.equals("kcp")) {
                if (n6 != -1) {
                    stringBuilder.replace(0, n6, "httpk");
                }
            } else if (this.mTransportProtocol.equals("quic") || this.mTransportProtocol.equals("quicu")) {
                if (n6 != -1) {
                    stringBuilder.replace(0, n6, "httpq");
                }
            } else if (this.mTransportProtocol.equals("tls")) {
                if (n6 != -1) {
                    stringBuilder.replace(0, n6, "https");
                }
            } else if (this.mTransportProtocol.equals("tcp") && n6 != -1) {
                stringBuilder.replace(0, n6, "http");
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public void setLocalURL(String string) {
        this.checkMainLooper("setLocalURL");
        if (string != null && !string.equals(this.mLocalURL) && this.mLocalURL != null) {
            this.reset();
        }
        this.mLocalURL = string;
        this.mIsLocalURL = true;
    }

    @Override
    public void setLooping(boolean bl) {
        this.mLooping = bl;
        if (this.mPlayer != null && this.mIsLocalURL && !TextUtils.isEmpty((CharSequence)this.mLocalURL)) {
            this.mPlayer.setLooping(this.mLooping);
        }
    }

    @Override
    public void setPreviewFlag(boolean bl) {
        if (this.mLogService != null) {
            this.mLogService.setPreviewFlag(bl);
        }
    }

    @Override
    public void setCommonFlag(String string) {
        if (this.mLogService != null) {
            this.mLogService.setCommonFlag(string);
        }
    }

    @Override
    public void setProjectKey(String string) {
        this.mLogService.setProjectKey(string);
    }

    @Override
    public void openNTP() {
        this.mEnableNTPTask = 1;
        this.mLogService.openNTP();
    }

    @Override
    public void closeDNS() {
        this.mEnableDns = false;
    }

    @Override
    public void enableUploadSessionSeries() {
        this.mEnableUploadSessionSeries = true;
        this.mLogService.mEnableUploadSessionSeries = true;
    }

    @Override
    public void enableSeiCheck() {
        this.mEnableSeiCheck = true;
        this.mLogService.mEnableSeiCheck = true;
    }

    @Override
    public void closeSeiCheck() {
        this.mEnableSeiCheck = false;
        this.mLogService.mEnableSeiCheck = false;
    }

    @Override
    public long getSeiDelay() {
        return this.mLogService.getInt64Value(100, 0L);
    }

    private void configPlayerEventHandler() {
        this.mPlayer.setOnPreparedListener(new MyPreparedListener(this));
        this.mPlayer.setOnErrorListener(new MyErrorListener(this));
        this.mPlayer.setOnInfoListener(new MyInfoListener(this));
        this.mPlayer.setOnCompletionListener(new MyCompletionListener(this));
        this.mPlayer.setOnVideoSizeChangedListener(new MyOnVideoSizeChangedListener(this));
    }

    private void configPlayerGlobalOption() {
        String string;
        LiveURL liveURL;
        this.mPlayer.setIntOption(9, this.mNetworkTimeout * 1000000);
        this.mPlayer.setIntOption(83, this.mTestAction);
        this.mPlayer.setIntOption(37, this.mEnhancementType);
        this.mPlayer.setIntOption(38, this.mScaleType);
        StringBuilder stringBuilder = new StringBuilder();
        this.mPlayer.setIntOption(325, 0);
        this.mPlayer.setIntOption(36, this.mLayoutType);
        this.mPlayer.setIntOption(110, 5000);
        this.mPlayer.setIntOption(64, 0);
        this.mPlayer.setIntOption(94, 1);
        this.mPlayer.setIntOption(56, this.mRenderType);
        this._configLiveSettingBundle();
        this._configWithSDKParams();
        this.configToBParams();
        this.mLogService.mEnableFastOpenStream = this.mEnableFastOpenStream;
        this.mPlayer.setIntOption(220, this.mEnableFastOpenStream);
        MyLog.i(TAG, "set fast open stream");
        this.mPlayer.setIntOption(56, this.mRenderType);
        this.mPlayer.setIntOption(340, this.mEnableCheckDropAudio);
        this.mPlayer.setIntOption(52, this.mEnableUploadSei);
        if (this.mEnableDTSCheck == 1 || this.mEnableCheckFrame == 1 || this.mEnableCheckSEI == 1) {
            this.mPlayer.setIntOption(640, 1);
        }
        this.mPlayer.setIntOption(641, 1);
        if (this.mEnableClosePlayRetry == 1) {
            this.mPlayer.setIntOption(197, 0);
            this.mPlayer.setIntOption(82, 0);
        }
        this.mLogService.mHasAbrInfo = this.mHasAbrInfo;
        this.mLogService.mAbrStrategy = this.mAbrStrategy;
        this.mLogService.mEnableResolutionAutoDegrade = this.mEnableResolutionAutoDegrade;
        this.mLogService.mStallCountThresOfResolutionDegrade = this.mStallCountThresOfResolutionDegrade;
        this.mLogService.mStallRetryTimeInterval = this.mStallRetryTimeIntervalManager;
        this.mRetryProcessor.setStallRetryTimeInterval(this.mStallRetryTimeIntervalManager);
        if (this.mEnableSharp == 1) {
            this.mPlayer.setIntOption(189, this.mEnableSharp);
            if (this.mLogService != null) {
                this.mLogService.enableSharp();
            }
        }
        String string2 = null;
        if (this.mURLSource.getSourceType() == 2) {
            string2 = this.mURLSource.getVCodec(this.mResolution, this.mLevel);
        } else if (this.mURLSource.getSourceType() == 1 && (liveURL = this.mURLSource.getPlayLiveURL()) != null) {
            string2 = liveURL.getVCodec();
        }
        if (string2 != null) {
            if (string2 != null && string2.equals("h264")) {
                this.mHardwareDecodeEnable = this.mEnableH264HardwareDecode;
                this.mDefaultCodecId = 0;
            } else if (string2 != null && string2.equals("bytevc1")) {
                this.mHardwareDecodeEnable = this.mEnableByteVC1HardwareDecode;
                this.mDefaultCodecId = 1;
            } else {
                this.mHardwareDecodeEnable = 0;
            }
            this.mLogService.mUrlAbility = string2 != null ? string2 : "";
        } else {
            this.mHardwareDecodeEnable = 0;
        }
        this.mHardwareDecodeEnable = 1;
        this.mEnableMediaCodecASYNCInit = 1;
        this.mPlayer.setIntOption(800, this.mEnableRtcPlay);
        if (this.mEnableRtcPlay == 1) {
            MyLog.i(TAG, "rtc close hardware decode");
            this.mPlayer.setIntOption(59, 0);
            this.mPlayer.setIntOption(181, 0);
            int n2 = 0;
            if (this.mHardwareRTCDecodeEnable == 1 && this.mHardwareDecodeEnable == 1) {
                n2 = 1;
            }
            MyLog.i(TAG, "rts decode mHardwareDecodeEnable:" + this.mHardwareDecodeEnable + ", mHardwareRTCDecodeEnable: " + this.mHardwareRTCDecodeEnable);
            MyLog.i(TAG, "rts decode  hardware decode " + (n2 == 1 ? "True" : "False"));
            this.mPlayer.setIntOption(880, n2);
        } else {
            this.mPlayer.setIntOption(59, this.mHardwareDecodeEnable);
            this.mLogService.enableHardDecode(this.mHardwareDecodeEnable == 1);
            if (this.mHardwareDecodeEnable == 1) {
                MyLog.i(TAG, "enable hardware decode");
                if (this.mDefaultCodecId != -1) {
                    MyLog.i(TAG, "set hardware async init");
                    this.mPlayer.setIntOption(181, this.mEnableMediaCodecASYNCInit);
                    this.mPlayer.setIntOption(182, this.mDefaultCodecId);
                    this.mLogService.mMediaCodecAsyncInit = this.mEnableMediaCodecASYNCInit;
                    this.mLogService.mDefaultCodecID = this.mDefaultCodecId;
                }
            }
            this.mPlayer.setIntOption(97, this.mHardwareDecodeEnable);
            this.mPlayer.setIntOption(536, 500000);
        }
        if (this.mByteVC1DecoderType != -1 && this.mEnableByteVC1HardwareDecode != 1) {
            this.mPlayer.setIntOption(67, this.mByteVC1DecoderType);
        }
        if (this.mBufferTimeout != -1) {
            this.mPlayer.setIntOption(81, this.mBufferTimeout);
        }
        if (this.mCatchSpeed > 0.0f) {
            this.mPlayer.setFloatOption(80, this.mCatchSpeed);
            this.mLogService.mCatchSpeed = this.mCatchSpeed;
        }
        if (this.mCacheFileEnable == -1 && this.mCacheFilePath != null) {
            this.mCacheFileKey = "" + System.currentTimeMillis();
            this.mPlayer.setStringOption(17, this.mCacheFileKey);
            this.mPlayer.setIntOption(14, 1);
            this.mPlayer.setCacheFile(this.mCacheFilePath, 1);
        }
        if (this.mHurryType != -1) {
            this.mPlayer.setIntOption(84, this.mHurryType);
            this.mLogService.mEnableHurry = true;
        }
        if (this.mHurryType == 0 && this.mHurryTime != 0) {
            this.mPlayer.setIntOption(15, this.mHurryTime);
            this.mLogService.mHurryTime = this.mHurryTime;
        }
        if (this.mIsLocalURL && !TextUtils.isEmpty((CharSequence)this.mLocalURL) && this.mLooping) {
            this.mPlayer.setLooping(this.mLooping);
        }
        if (this.mBufferDataSeconds != -1) {
            this.mPlayer.setIntOption(86, this.mBufferDataSeconds);
        }
        if (this.mSlowPlayTime != -1) {
            this.mPlayer.setIntOption(190, this.mSlowPlayTime);
            this.mLogService.mSlowPlayTime = this.mSlowPlayTime;
        }
        if (this.mSlowPlaySpeed > 0.0f) {
            this.mPlayer.setFloatOption(191, this.mSlowPlaySpeed);
            this.mLogService.mSlowSpeed = this.mSlowPlaySpeed;
        }
        if (this.mMaxCacheSeconds != -1) {
            this.mPlayer.setIntOption(24, this.mMaxCacheSeconds);
            this.mPlayer.setIntOption(198, this.mMaxCacheSeconds);
            this.mLogService.mMaxCacheSeconds = this.mMaxCacheSeconds;
        }
        if (this.mEnableSplitStream != 0) {
            this.mPlayer.setIntOption(87, this.mEnableSplitStream);
            this.mLogService.mEnableSplitStream = this.mEnableSplitStream;
        }
        if (this.mStartPlayBufferThres > 0L) {
            this.mPlayer.setLongOption(309, this.mStartPlayBufferThres);
            this.mLogService.mStartPlayBufferThres = this.mStartPlayBufferThres;
        }
        if (this.mCheckBufferingEndIgnoreVideo == 1) {
            this.mPlayer.setIntOption(310, this.mCheckBufferingEndIgnoreVideo);
            this.mLogService.mCheckBufferingEndIgnoreVideo = this.mCheckBufferingEndIgnoreVideo;
        }
        if (this.mStartDirectAfterPrepared == 1) {
            this.mPlayer.setIntOption(311, this.mStartDirectAfterPrepared);
            this.mLogService.mStartDirectAfterPrepared = this.mStartDirectAfterPrepared;
        }
        if (this.mCheckBufferingEndAdvanceEnable == 1) {
            this.mPlayer.setIntOption(313, this.mCheckBufferingEndAdvanceEnable);
            this.mLogService.mCheckBufferingEndAdvanceEnable = this.mCheckBufferingEndAdvanceEnable;
        }
        if (this.mOpenCheckSideData == 1) {
            this.mPlayer.setIntOption(132, this.mOpenCheckSideData);
        }
        if (this.mAudioTimescaleEnable != -1) {
            this.mPlayer.setIntOption(460, this.mAudioTimescaleEnable);
            this.mLogService.mAudioTimescaleEnable = this.mAudioTimescaleEnable;
        }
        this.mLogService.mEnableUploadSessionSeries = this.mEnableUploadSessionSeries;
        if (this.mEnableNTPTask == 1) {
            this.mLogService.openNTP();
        }
        if (this.mEnableOpenMDL == 1) {
            this.mLogService.mEnableOpenMDL = (int)MediaLoaderWrapper.getDataLoader().getLongValueFromLoader(8100);
            this.mLogService.mEnableP2P = (int)MediaLoaderWrapper.getDataLoader().getLongValueFromLoader(8101);
            this.mLogService.mMDLVersion = MediaLoaderWrapper.getDataLoader().getStringValueFromLoader(11);
            this.mLogService.mEnableMdlProto = (int)MediaLoaderWrapper.getDataLoader().getLongValueFromLoader(8102);
            MediaLoaderWrapper.getDataLoader().setListener(new MyMediaLoaderListener(this));
            if (!this.mIsMdlProtoRegister && MediaLoaderWrapper.getDataLoader().getLongValueFromLoader(8102) == 1L) {
                long l2 = MediaLoaderWrapper.getDataLoader().getLongValueFromLoader(7218);
                if (l2 != -1L) {
                    long l3 = this.mPlayer.setLongOption(500, l2);
                    this.mIsMdlProtoRegister = l3 == 0L;
                }
                MyLog.i(TAG, "get mdl proto ret:" + l2 + ", register ret:" + this.mIsMdlProtoRegister);
            }
        }
        this.mEnableOpenLiveIO = 0;
        this.mEnableLiveIOPlay = 0;
        this.mEnableRtcPlay = 0;
        if (this.mALogWriteAddr != -1L) {
            this.mPlayer.setLongOption(231, this.mALogWriteAddr);
            this.mPlayer.setIntOption(223, 1);
        }
        if (this.mStreamFormat != null) {
            this.mPlayer.setStringOption(315, this.mStreamFormat);
        }
        if (this.mStreamFormat != null && this.mStreamFormat.equals("avph")) {
            this.prepareAvphPlay();
        }
        this.mPlayer.setIntOption(347, this.mAVNoSyncThreshold);
        this.mPlayer.setIntOption(348, this.mIsAlwaysDoAVSync);
        this.mPlayer.setIntOption(323, this.mEnableRenderStall);
        if (this.mEnableRenderStall == 1) {
            this.mPlayer.setIntOption(321, mAudioRenderStallThreshold);
            this.mPlayer.setIntOption(322, mVideoRenderStallThreshold);
        }
        this.mPlayer.setIntOption(360, this.mEnableDemuxerStall);
        this.mPlayer.setIntOption(461, this.mNoSyncReportReportThres);
        if (this.mEnableDemuxerStall == 1) {
            this.mPlayer.setIntOption(362, mDemuxerStallThreshold);
            this.mPlayer.setLongOption(364, -1L);
            this.mPlayer.setLongOption(365, -1L);
        }
        this.mPlayer.setIntOption(361, this.mEnableDecoderStall);
        if (this.mEnableDecoderStall == 1) {
            this.mPlayer.setIntOption(363, mDecoderStallThreshold);
            this.mPlayer.setLongOption(366, -1L);
            this.mPlayer.setLongOption(367, -1L);
        }
        this.mPlayer.setIntOption(380, this.mEnableStallCounter);
        if (this.mEnableTcpFastOpen == 1 && this.mPlayer != null) {
            this.mLogService.mEnableTcpFastOpen = this.mEnableTcpFastOpen;
            this.mPlayer.setIntOption(316, this.mEnableTcpFastOpen);
            stringBuilder.append("live_enable_tcp_fast_open:1,");
        }
        if (this.mPlayer != null) {
            if (this.mEnableCmafFastMode == 1) {
                this.mPlayer.setIntOption(611, this.mEnableCmafFastMode);
                stringBuilder.append("live_enable_cmaf_fast_mode:1 ");
            }
            this.mPlayer.setIntOption(680, this.mEnableCmafOptimizeRetry);
        }
        if (this.mPlayer != null) {
            this.mPlayer.setIntOption(642, this.mEnableVideoMpdRefresh);
        }
        if (this.mEnableCheckPacketCorrupt == 1 && this.mPlayer != null) {
            this.mPlayer.setIntOption(317, this.mEnableCheckPacketCorrupt);
            stringBuilder.append("live_enable_check_packet_corrupt:1,");
        }
        if (this.mEnableResolutionAutoDegrade && this.mURLSource.getSourceType() == 2 && this.mAbrStrategy.equals("abr_bb_4live") && this.mABRDisableAlgorithm == 1) {
            this.mPlayer.setIntOption(651, 1);
        }
        if (this.mEnableFlvABR == 1) {
            stringBuilder.append("live_enable_flv_abr:1,");
        }
        if (this.mEnableOptimizeBackup == 1) {
            stringBuilder.append("live_enable_optimize_backup:1,");
        }
        if (this.mEnableStallRetryInstantly == 1) {
            stringBuilder.append("live_enable_stall_retry_instantly:1 ");
        } else {
            stringBuilder.append("live_enable_stall_retry_instantly:0 ");
        }
        if (this.mEnableCacheSei == 1) {
            stringBuilder.append("live_enable_sei_pts_sync:1 ");
            this.mPlayer.setIntOption(368, 1);
            this.mPlayer.setIntOption(369, 1000);
        }
        if (this.mEnableDecodeMultiSei == 1) {
            stringBuilder.append("live_enable_decode_multi_sei:1 ");
            this.mPlayer.setIntOption(372, 1);
        }
        if (this.mEnableDecodeSeiOnce == 1) {
            stringBuilder.append("live_enable_decode_sei_once:1 ");
            this.mPlayer.setIntOption(648, 1);
        }
        if (this.mSettingsBundle != null) {
            if (this.mSettingsBundle.getSettingsValueForKey("live_sdk_super_resolution_enable", 0) == 1) {
                stringBuilder.append("live_sdk_super_resolution_enable:1 ");
            } else {
                stringBuilder.append("live_sdk_super_resolution_enable:0 ");
            }
        }
        if (this.mEnableTextureRender == 1) {
            stringBuilder.append("live_sdk_texture_render_enable:1 ");
        } else {
            stringBuilder.append("live_sdk_texture_render_enable:0 ");
        }
        if (this.mSettingsBundle != null) {
            if (this.mSettingsBundle.getSettingsValueForKey("live_sdk_sharpen_enable", 0) == 1) {
                stringBuilder.append("live_sdk_sharpen_enable:1 ");
            } else {
                stringBuilder.append("live_sdk_sharpen_enable:0 ");
            }
        }
        if (this.mEnableOpenLiveIO == 1) {
            stringBuilder.append("live_sdk_enable_liveio:1 ");
        }
        if (this.mEnableAudioVolumeBalance == 1) {
            stringBuilder.append("live_sdk_audio_volume_balance_enable:1 ");
            if (this.mAudioVolumeBalancePregain != -1.0f) {
                stringBuilder.append("live_sdk_audio_volume_balance_pregain:" + this.mAudioVolumeBalancePregain + " ");
            }
            if (this.mAudioVolumeBalanceThreshold != -1.0f) {
                stringBuilder.append("live_sdk_audio_volume_balance_threshold:" + this.mAudioVolumeBalanceThreshold + " ");
            }
            if (this.mAudioVolumeBalanceRatio != -1.0f) {
                stringBuilder.append("live_sdk_audio_volume_balance_ratio:" + this.mAudioVolumeBalanceRatio + " ");
            }
            if (this.mAudioVolumeBalancePredelay != -1.0f) {
                stringBuilder.append("live_sdk_audio_volume_balance_predelay:" + this.mAudioVolumeBalancePredelay + " ");
            }
        }
        if (this.mEnableNotifySeiImmediatelyBeforeFirstFrame == 1) {
            stringBuilder.append("live_sdk_notifysei_immediately_before_firstframe:1 ");
            this.mPlayer.setIntOption(649, 1);
        }
        if (this.mEnableRadioLiveDisableRender == 1) {
            stringBuilder.append("live_sdk_enable_radiolive_disable_render:1 ");
        }
        if (this.mLogService.mHostNTPUrl != null) {
            stringBuilder.append("live_sdk_ntp_server_name:" + this.mLogService.mHostNTPUrl + " ");
        }
        if (this.mEnableReportSessionStop == 1) {
            stringBuilder.append("live_sdk_should_report_session_stop:1 ");
            this.mLogService.mEnableReportSessionStop = 1;
        }
        if (this.mUsePlayerRenderStart) {
            stringBuilder.append("live_sdk_texturerender_use_player_renderstart:1 ");
        }
        if (this.mEnableFreeFlow == 1) {
            stringBuilder.append("live_sdk_isfreeflow:1 ");
        }
        if (this.mEnableDroppingDTSRollFrame == 1) {
            stringBuilder.append("live_sdk_dropping_dts_rollback_frame_enabled:1 ");
            this.mPlayer.setIntOption(148, this.mEnableDroppingDTSRollFrame);
        }
        if (this.mEnableUseLiveThreadPool == 1) {
            stringBuilder.append("live_sdk_enable_use_live_threadpool:1 ");
        }
        this.mLogService.mIsInMainLooper = this.mIsInMainLooper;
        if (stringBuilder.length() == 0) {
            string = "none";
        } else {
            StringBuilder stringBuilder2 = stringBuilder;
            string = this.mLogService.mSettingsInfo = stringBuilder2.deleteCharAt(stringBuilder2.length() - 1).toString();
        }
        if (!TextUtils.isEmpty((CharSequence)this.mStreamFormat) && (this.mStreamFormat.equals("hls") || this.mStreamFormat.equals("tsl"))) {
            this.mPlayer.setIntOption(298, this.mHlsLiveStartIndex);
        }
        this.mLogService.mEnableLowLatencyFLV = this.mEnableLowLatencyFLV;
        this.mLogService.mFastOpenDuration = mFastOpenDuration;
    }

    private void configToBParams() {
        if (this.mSwitchToB == 1 && this.mPlayer != null) {
            this.mPlayer.setStringOption(509, this.mMoudleIDToB);
        }
    }

    private void configPlayerInstanceOption() {
        this.mLogService.setProtocolInfo(this.mSuggestProtocol, this.mTransportProtocol);
        String string = this.mURLSource.getSDKParams(this.mResolution, this.mLevel);
        this.mLogService.setSdkParams(string);
        if (this.mPlayer != null && this.mStreamFormat != null) {
            this.mPlayer.setStringOption(315, this.mStreamFormat);
        }
        if (this.mPlayer != null && this.mEnableAudioVolumeBalance == 1) {
            this.mPlayer.setIntOption(302, 1);
            if (this.mAudioVolumeBalancePregain != -1.0f) {
                this.mPlayer.setFloatOption(303, this.mAudioVolumeBalancePregain);
            }
            if (this.mAudioVolumeBalanceThreshold != -1.0f) {
                this.mPlayer.setFloatOption(304, this.mAudioVolumeBalanceThreshold);
            }
            if (this.mAudioVolumeBalanceRatio != -1.0f) {
                this.mPlayer.setFloatOption(305, this.mAudioVolumeBalanceRatio);
            }
            if (this.mAudioVolumeBalancePredelay != -1.0f) {
                this.mPlayer.setFloatOption(306, this.mAudioVolumeBalancePredelay);
            }
        }
    }

    private void _configLiveSettingBundle() {
        if (this.mSettingsBundle == null) {
            return;
        }
        this.mEnableCheckDropAudio = this.mSettingsBundle.getSettingsValueForKey("live_enable_check_drop_audio", 0);
        this.mRenderType = this.mSettingsBundle.getSettingsValueForKey("live_option_render_type", 3);
        this.mEnableCmafFastMode = this.mSettingsBundle.getSettingsValueForKey("live_enable_cmaf_fast_mode", 0);
        this.mStartPlayBufferThres = this.mSettingsBundle.getSettingsValueForKey("live_start_play_buffer_thres", 0L);
        this.mCheckBufferingEndIgnoreVideo = this.mSettingsBundle.getSettingsValueForKey("live_check_buffering_end_ignore_video", 0);
        this.mStartDirectAfterPrepared = this.mSettingsBundle.getSettingsValueForKey("live_direct_start_after_prepared", 0);
        this.mCheckBufferingEndAdvanceEnable = this.mSettingsBundle.getSettingsValueForKey("live_check_buffering_end_advance", 0);
        if (!this.mHasAbrInfo) {
            this.mEnableResolutionAutoDegrade = this.mSettingsBundle.getSettingsValueForKey("live_enable_resolution_degrade", Boolean.FALSE);
            this.mStallCountThresOfResolutionDegrade = this.mSettingsBundle.getSettingsValueForKey("live_stall_count_thres_for_degrade", 4);
        }
        MyLog.i(TAG, "mEnableResolutionAutoDegrade:" + this.mEnableResolutionAutoDegrade + " mStallCountThresOfResolutionDegrade:" + this.mStallCountThresOfResolutionDegrade);
        this.mEnableOpenMDL = this.mSettingsBundle.getSettingsValueForKey("live_open_mdl_enable", 0);
        MyLog.i(TAG, "enable mdl:" + this.mEnableOpenMDL);
        this.mEnableTcpFastOpen = this.mSettingsBundle.getSettingsValueForKey("live_enable_tcp_fast_open", 0);
        MyLog.i(TAG, "enable tfo:" + this.mEnableTcpFastOpen);
        this.mEnableCheckPacketCorrupt = this.mSettingsBundle.getSettingsValueForKey("live_enable_check_packet_corrupt", 0);
        this.mEnableFlvABR = this.mSettingsBundle.getSettingsValueForKey("live_enable_flv_abr", 0);
        this.mForceHttpDns = this.mSettingsBundle.getSettingsValueForKey("live_sdk_http_dns_enabled", Boolean.FALSE);
        this.mHttpDNSServerHost = this.mSettingsBundle.getSettingsValueForKey("live_sdk_http_dns_server_host", String.valueOf("null"));
        this.mLogService.mEnableHttpDns = this.mForceHttpDns;
        MyLog.i(TAG, "enable http dns:" + this.mForceHttpDns + " http dns server: " + this.mHttpDNSServerHost);
        this.mLogService.mHostNTPUrl = this.mSettingsBundle.getSettingsValueForKey("live_sdk_ntp_server_name", String.valueOf("null"));
        this.mCancelSDKDNSFailRetry = this.mSettingsBundle.getSettingsValueForKey("live_sdk_cancel_sdk_dns_fail_retry", Boolean.FALSE);
        this.mEnableClosePlayRetry = this.mSettingsBundle.getSettingsValueForKey("live_enable_close_play_retry", 0);
        this.mEnableOptimizeBackup = this.mSettingsBundle.getSettingsValueForKey("live_sdk_optimize_backup_enabled", 0);
        MyLog.i(TAG, "enable optimize backup ip:" + this.mEnableOptimizeBackup);
        this.mEnableStallRetryInstantly = this.mSettingsBundle.getSettingsValueForKey("live_sdk_stall_retry_instantly_enabled", 1);
        this.mEnableAudioVolumeBalance = this.mSettingsBundle.getSettingsValueForKey("live_sdk_audio_volume_balance_enable", 0);
        this.mAudioVolumeBalancePregain = this.mSettingsBundle.getSettingsValueForKey("live_sdk_audio_volume_balance_pregain", Float.valueOf(-1.0f)).floatValue();
        this.mAudioVolumeBalanceThreshold = this.mSettingsBundle.getSettingsValueForKey("live_sdk_audio_volume_balance_threshold", Float.valueOf(-1.0f)).floatValue();
        this.mAudioVolumeBalanceRatio = this.mSettingsBundle.getSettingsValueForKey("live_sdk_audio_volume_balance_ratio", Float.valueOf(-1.0f)).floatValue();
        this.mAudioVolumeBalancePredelay = this.mSettingsBundle.getSettingsValueForKey("live_sdk_audio_volume_balance_predelay", Float.valueOf(-1.0f)).floatValue();
        MyLog.i(TAG, "audio balance:" + this.mEnableAudioVolumeBalance + "," + this.mAudioVolumeBalancePregain + "," + this.mAudioVolumeBalanceThreshold + "," + this.mAudioVolumeBalanceRatio + "," + this.mAudioVolumeBalancePredelay);
        this.mEnableCacheSei = this.mSettingsBundle.getSettingsValueForKey("live_sdk_enable_sei_pts_synced", 0);
        MyLog.i(TAG, "enable sei pts sync:" + this.mEnableCacheSei);
        this.mStallRetryTimeIntervalManager = this.mSettingsBundle.getSettingsValueForKey("stall_retry_time_interval_manager", 10000L);
        this.mEnableDecodeMultiSei = this.mSettingsBundle.getSettingsValueForKey("live_sdk_enable_decode_multi_sei", 0);
        this.mEnableRadioLiveDisableRender = this.mSettingsBundle.getSettingsValueForKey("live_sdk_enable_radiolive_disable_render", 0);
        this.mEnableOpenLiveIO = this.mSettingsBundle.getSettingsValueForKey("live_sdk_enable_liveio", 0);
        this.mEnableDecodeSeiOnce = this.mSettingsBundle.getSettingsValueForKey("live_sdk_enable_decode_sei_once", 0);
        this.mEnableNotifySeiImmediatelyBeforeFirstFrame = this.mSettingsBundle.getSettingsValueForKey("live_sdk_notify_sei_immediately_before_first_frame_enabled", 0);
        this.mEnableNotifySeiImmediatelyBeforeFirstFrame = 1;
        this.mEnableDroppingDTSRollFrame = this.mSettingsBundle.getSettingsValueForKey("live_sdk_dropping_dts_rollback_frame_enabled", 0);
        String string = this.mSettingsBundle.getSettingsValueForKey("live_sdk_low_latency_flv_default_strategy_map", "");
        if (string.length() > 0) {
            try {
                this.mLowLatencyFLVStrategy = new JSONObject(string);
                return;
            }
            catch (JSONException jSONException) {
                this.mLowLatencyFLVStrategy = null;
                q.d(jSONException);
                MyLog.e(TAG, "strategy settings invalid");
            }
        }
    }

    private void _configWithSDKParams() {
        String string = this.mURLSource.getSDKParams(this.mResolution, this.mLevel);
        if (string != null) {
            try {
                JSONObject jSONObject;
                string = new JSONObject(string);
                if (!this.mHasAbrInfo && string.has("Auto") && (jSONObject = string.getJSONObject("Auto")) != null) {
                    JSONObject jSONObject2;
                    if (jSONObject.has("Enable")) {
                        int n2 = jSONObject.optInt("Enable");
                        boolean bl = this.mEnableResolutionAutoDegrade = n2 == 1;
                    }
                    if (jSONObject.has("Demotion") && (jSONObject2 = jSONObject.getJSONObject("Demotion")) != null && jSONObject2.has("StallCount")) {
                        this.mStallCountThresOfResolutionDegrade = jSONObject2.getInt("StallCount");
                    }
                }
                if (string.has("vbitrate")) {
                    this.mDefaultResBitrate = string.optInt("vbitrate");
                }
                if (string.has("FramesDrop")) {
                    this.mFramesDrop = string.optInt("FramesDrop");
                }
                if (string.has("AVPHDnsParseEnable")) {
                    this.mAVPHDnsParseEnable = string.optInt("AVPHDnsParseEnable");
                }
                if (string.has("AVPHDnsTimeout")) {
                    this.mAVPHDnsTimeout = string.optInt("AVPHDnsTimeout");
                }
                if (string.has("AVPHVideoProbesize")) {
                    this.mAVPHVideoProbesize = string.optInt("AVPHVideoProbesize");
                }
                if (string.has("AVPHVideoMaxDuration")) {
                    this.mAVPHVideoMaxDuration = string.optInt("AVPHVideoMaxDuration");
                }
                if (string.has("AVPHAudioProbesize")) {
                    this.mAVPHAudioProbesize = string.optInt("AVPHAudioProbesize");
                }
                if (string.has("AVPHAudioMaxDuration")) {
                    this.mAVPHAudioMaxDuration = string.optInt("AVPHAudioMaxDuration");
                }
                if (string.has("AVPHOpenVideoFirst")) {
                    this.mAVPHOpenVideoFirst = string.optInt("AVPHOpenVideoFirst");
                }
                if (string.has("AVPHMaxAVDiff")) {
                    this.mAVPHMaxAVDiff = string.optInt("AVPHMaxAVDiff");
                }
                if (string.has("AVPHAutoExit")) {
                    this.mAVPHAutoExit = string.optInt("AVPHAutoExit");
                }
                if (string.has("AVPHAutoReopen")) {
                    this.mAVPHEnableAutoReopen = string.optInt("AVPHAutoReopen");
                }
                if (string.has("AVPHVideoDiffThreshold")) {
                    this.mAVPHVideoDiffThreshold = string.optInt("AVPHVideoDiffThreshold");
                }
                if (string.has("AVPHReadRetryCount")) {
                    this.mAVPHReadRetryCount = string.optInt("AVPHReadRetryCount");
                }
                if (string.has("AVPHReadErrorExit")) {
                    this.mAVPHReadErrorExit = string.optInt("AVPHReadErrorExit");
                }
                if (string.has("EnableSkipFindUnnecessaryStream")) {
                    this.mEnableSkipFindUnnecessaryStream = string.optInt("EnableSkipFindUnnecessaryStream");
                }
                if (string.has("EnableRenderStall")) {
                    this.mEnableRenderStall = string.optInt("EnableRenderStall");
                }
                if (string.has("VideoRenderStallThreshold")) {
                    mVideoRenderStallThreshold = string.optInt("VideoRenderStallThreshold");
                }
                if (string.has("AudioRenderStallThreshold")) {
                    mAudioRenderStallThreshold = string.optInt("AudioRenderStallThreshold");
                }
                if (string.has("EnableDemuxerStall")) {
                    this.mEnableDemuxerStall = string.optInt("EnableDemuxerStall");
                }
                if (string.has("EnableDecoderStall")) {
                    this.mEnableDecoderStall = string.optInt("EnableDecoderStall");
                }
                if (string.has("DemuxerStallThreshold")) {
                    mDemuxerStallThreshold = string.optInt("DemuxerStallThreshold");
                }
                if (string.has("DecoderStallThreshold")) {
                    mDecoderStallThreshold = string.optInt("DecoderStallThreshold");
                }
                if (string.has("StallCounter") && (jSONObject = string.getJSONObject("StallCounter")) != null) {
                    if (jSONObject.has("Enable")) {
                        this.mEnableStallCounter = jSONObject.optInt("Enable");
                    }
                    if (jSONObject.has("TimeInterval")) {
                        this.mStallCounterInterval = jSONObject.optInt("TimeInterval");
                    }
                }
                if (string.has("DTSCheckEnabled")) {
                    this.mEnableDTSCheck = string.optInt("DTSCheckEnabled");
                }
                if (string.has("DroppingRepeatingDataEnabled")) {
                    this.mEnablePreventDTSBack = string.optInt("DroppingRepeatingDataEnabled");
                }
                if (string.has("DroppingRepeatingDataDTSMaxDiff")) {
                    this.mFrameDroppingDTSMaxDiff = string.optLong("DroppingRepeatingDataDTSMaxDiff");
                }
                if (string.has("EnableSaveSCFG")) {
                    boolean bl = this.mEnableSaveSCFG = string.optInt("EnableSaveSCFG") == 1;
                }
                if (string.has("EnableVideoMpdRefresh")) {
                    this.mEnableVideoMpdRefresh = string.optInt("EnableVideoMpdRefresh");
                }
                if (string.has("TransInfoCheck") && (jSONObject = string.optJSONObject("TransInfoCheck")).has("Enabled")) {
                    this.mEnableCheckFrame = jSONObject.optInt("Enabled");
                }
                if (string.has("SEICheck") && (jSONObject = string.optJSONObject("SEICheck")).has("Enabled")) {
                    this.mEnableCheckSEI = jSONObject.optInt("Enabled");
                    if (jSONObject.optInt("Enabled") == 1 || this.mLogService != null) {
                        this.mLogService.enableCheckSei();
                    }
                }
                if (string.has("EnableCacheSei")) {
                    this.mEnableCacheSei = string.optInt("EnableCacheSei");
                }
                if (string.has("gop")) {
                    this.mGopDuration = string.optInt("gop");
                }
                if (string.has("EnableLLASHFastOpen")) {
                    this.mEnableLLASHFastOpen = string.optInt("EnableLLASHFastOpen");
                }
                if (string.has("EnableABRCheckEnhance")) {
                    this.mEnableLiveAbrCheckEnhance = string.optInt("EnableABRCheckEnhance");
                }
                if (string.has("ABRCheckInterval")) {
                    this.mLiveABRCheckInterval = string.optInt("ABRCheckInterval");
                }
                if (string.has("ABRMethod")) {
                    this.mABRMethod = string.optInt("ABRMethod");
                }
                if (string.has("ABRBufferThreshold")) {
                    this.mABRBufferThreshold = string.optInt("ABRBufferThreshold");
                }
                if (string.has("MaxCacheSeconds")) {
                    this.mMaxCacheSeconds = string.optInt("MaxCacheSeconds");
                }
                if (string.has("MainBackupSwitch") && (jSONObject = string.optJSONObject("MainBackupSwitch")).has("Enabled")) {
                    this.mEnableSwitchMainAndBackupUrl = jSONObject.optInt("Enabled") != 0;
                }
                if (string.has("MinTimeShift")) {
                    this.mTslMinTimeShit = string.optInt("MinTimeShift");
                }
                if (string.has("TargetOriginBitRate")) {
                    this.mTargetOriginBitRate = string.optInt("TargetOriginBitRate");
                }
                if (string.has("AbrStallDegradeImmediately")) {
                    this.mEnableAbrStallDegradeImmediately = string.optInt("AbrStallDegradeImmediately");
                }
                if (string.has("HASSessionPath")) {
                    this.mCdnSessionPath = string.optString("HASSessionPath");
                }
                if (string.has("DecodeSEIEnabled")) {
                    this.mEnableUploadSei = string.optInt("DecodeSEIEnabled");
                }
                if (string.has("NetworkAdapt") && (jSONObject = new JSONObject(string.optString("NetworkAdapt"))).has("Enabled")) {
                    this.mEnableHurryFlag = jSONObject.optInt("Enabled");
                    if (this.mEnableHurryFlag == 1) {
                        this.mHurryType = 0;
                    }
                    if (jSONObject.has("HurryTime")) {
                        this.mHurryTime = jSONObject.optInt("HurryTime");
                        this.mPlayer.setIntOption(15, this.mHurryTime);
                    }
                    if (jSONObject.has("HurryMillisecond")) {
                        this.mHurryTime = jSONObject.optInt("HurryMillisecond");
                        this.mPlayer.setIntOption(397, this.mHurryTime);
                    }
                    if (jSONObject.has("HurrySpeed")) {
                        this.mCatchSpeed = Float.parseFloat(jSONObject.optString("HurrySpeed"));
                    }
                    if (jSONObject.has("SlowTime")) {
                        this.mSlowPlayTime = jSONObject.optInt("SlowTime");
                        this.mPlayer.setIntOption(190, this.mSlowPlayTime);
                    }
                    if (jSONObject.has("SlowMillisecond")) {
                        this.mSlowPlayTime = jSONObject.optInt("SlowMillisecond");
                        this.mPlayer.setIntOption(398, this.mSlowPlayTime);
                    }
                    if (jSONObject.has("SlowSpeed")) {
                        this.mSlowPlaySpeed = Float.parseFloat(jSONObject.optString("SlowSpeed"));
                    }
                }
                if (string.has("StartPlayAudioBufferThreshold")) {
                    this.mStartPlayBufferThres = string.optInt("StartPlayAudioBufferThreshold");
                }
                if (string.has("EnableCertVerify")) {
                    boolean bl = this.mEnableQuicCertVerify = string.optInt("EnableCertVerify") == 1;
                }
                if (string.has("EnableClosePlayRetry")) {
                    this.mEnableClosePlayRetry = string.optInt("EnableClosePlayRetry");
                }
                if (string.has("EnableDnsOptimizer")) {
                    this.mEnableDnsOptimizer = string.optInt("EnableDnsOptimizer") == 1;
                    this.mLogService.openNodeOptimizer(this.mEnableDnsOptimizer);
                }
                if (string.has("EnableMTUDiscovery")) {
                    this.mEnableQuicMTUDiscovery = string.optInt("EnableMTUDiscovery");
                }
                if (string.has("InitMTU")) {
                    this.mQuicInitMTU = string.optInt("InitMTU");
                }
                if (string.has("InitRtt")) {
                    this.mQuicInitRtt = string.optInt("InitRtt");
                }
                if (string.has("MaxCryptoRetransmissions")) {
                    this.mQuicMaxCryptoRetransmissions = string.optInt("MaxCryptoRetransmissions");
                }
                if (string.has("MaxCryptoRetransmissionTimeMs")) {
                    this.mQuicMaxCryptoRetransmissionTimeMs = string.optInt("MaxCryptoRetransmissionTimeMs");
                }
                if (string.has("MaxRetransmissions")) {
                    this.mQuicMaxRetransmissions = string.optInt("MaxRetransmissions");
                }
                if (string.has("MaxRetransmissionTimeMs")) {
                    this.mQuicMaxRetransmissionTimeMs = string.optInt("MaxRetransmissionTimeMs");
                }
                if (string.has("MaxAckDelay")) {
                    this.mQuicMaxAckDelay = string.optInt("MaxAckDelay");
                }
                if (string.has("MinReceivedBeforeAckDecimation")) {
                    this.mQuicMinReceivedBeforeAckDecimation = string.optInt("MinReceivedBeforeAckDecimation");
                }
                if (string.has("QuicVersion")) {
                    this.mQuicVersion = string.optInt("QuicVersion", 39);
                }
                if (string.has("PadHello")) {
                    this.mQuicPadHello = string.optInt("PadHello", 1);
                }
                if (string.has("FixWillingAndAbleToWrite")) {
                    this.mQuicFixWillingAndAbleToWrite = string.optInt("FixWillingAndAbleToWrite", 1);
                }
                if (string.has("FixProcessTimer")) {
                    this.mQuicFixProcessTimer = string.optInt("FixProcessTimer", 1);
                }
                if (string.has("QuicReadBlockTimeout")) {
                    this.mQuicReadBlockTimeout = string.optInt("QuicReadBlockTimeout", 100);
                }
                if (string.has("QuicReadBlockMode")) {
                    this.mQuicReadBlockMode = string.optInt("QuicReadBlockMode", 0);
                }
                if (string.has("FixStreamFinAndRst")) {
                    this.mQuicFixStreamFinAndRst = string.optInt("FixStreamFinAndRst", 0);
                }
                if (string.has("QuicTimerVersion")) {
                    this.mQuicTimerVersion = string.optInt("QuicTimerVersion", 1);
                }
                if (string.has("QuicConfigOptimize")) {
                    this.mQuicConfigOptimize = string.optInt("QuicConfigOptimize", 0);
                }
                if (string.has("QuicSessionReceiveWindow")) {
                    this.mSessionReceiveWindow = string.optInt("QuicSessionReceiveWindow", 1);
                }
                if (string.has("QuicStreamReceiveWindow")) {
                    this.mStreamReceiveWindow = string.optInt("QuicStreamReceiveWindow", 1);
                }
                if (string.has("EnableCheckDropAudio")) {
                    this.mEnableCheckDropAudio = string.optInt("EnableCheckDropAudio");
                }
                if (string.has("AVNoSyncThreshold")) {
                    this.mAVNoSyncThreshold = string.optInt("AVNoSyncThreshold");
                }
                if (string.has("AlwaysDoAVSync")) {
                    this.mIsAlwaysDoAVSync = string.optInt("AlwaysDoAVSync");
                }
                if (string.has("StallRetryTimeIntervalManager")) {
                    this.mStallRetryTimeIntervalManager = string.optLong("StallRetryTimeIntervalManager");
                }
                if (string.has("FastOpenDuration")) {
                    mFastOpenDuration = string.optInt("FastOpenDuration");
                }
                if (string.has("LLSConfig") && (jSONObject = string.optJSONObject("LLSConfig")) != null) {
                    if (jSONObject.has("FallbackThreshold")) {
                        this.mRtcFallbackThreshold = jSONObject.optInt("FallbackThreshold");
                    }
                    if (jSONObject.has("EnableDtls")) {
                        this.mRtcEnableDtls = jSONObject.optInt("EnableDtls");
                    }
                    if (jSONObject.has("MinJitterBuffer")) {
                        this.mRtcMinJitterBuffer = jSONObject.optInt("MinJitterBuffer");
                    }
                    if (jSONObject.has("MaxJitterBuffer")) {
                        this.mRtcMaxJitterBuffer = jSONObject.optInt("MaxJitterBuffer");
                    }
                    if (jSONObject.has("EnableSDKDns")) {
                        this.mRtcEnableSDKDns = jSONObject.optInt("EnableSDKDns");
                    }
                    if (jSONObject.has("EnableEarlyInitRender")) {
                        this.mRtcEarlyInitRender = jSONObject.optInt("EnableEarlyInitRender");
                    }
                    if (jSONObject.has("MaxRetryCount")) {
                        this.mRtcMaxRetryCount = jSONObject.optInt("MaxRetryCount");
                    }
                    if (jSONObject.has("EnableRTCHWDecode")) {
                        this.mHardwareRTCDecodeEnable = jSONObject.optInt("EnableRTCHWDecode");
                    }
                    if (jSONObject.has("EnableMiniSdp")) {
                        this.mRtcSupportMiniSdp = jSONObject.optInt("EnableMiniSdp");
                    }
                    if (jSONObject.has("PlayingLogInterval")) {
                        this.mRtcPlayLogInterval = jSONObject.optInt("PlayingLogInterval");
                        if (this.mLogService != null) {
                            this.mLogService.setRtcPlayLogInterval(this.mRtcPlayLogInterval);
                        }
                    }
                    if (jSONObject.has("EnableRTSFixDeadlock")) {
                        this.mRtcEnableRtcUninitLockFree = jSONObject.optInt("EnableRTSFixDeadlock");
                    }
                }
                if (string.has("NetWorkTimeoutMs")) {
                    this.mNetworkTimeout = string.optInt("NetWorkTimeoutMs");
                }
                if (string.has("EnableCheckPacketCorrupt")) {
                    this.mEnableCheckPacketCorrupt = string.optInt("EnableCheckPacketCorrupt");
                }
                if (string.has("AudioTimescaleEnable")) {
                    this.mAudioTimescaleEnable = string.optInt("AudioTimescaleEnable");
                }
                if (string.has("EnableTcpFastOpen")) {
                    this.mEnableTcpFastOpen = string.optInt("EnableTcpFastOpen");
                }
                if (string.has("HlsLiveStartIndex")) {
                    this.mHlsLiveStartIndex = string.optInt("HlsLiveStartIndex");
                }
                if (string.has("CmafOptimizeRetry")) {
                    this.mEnableCmafOptimizeRetry = string.optInt("CmafOptimizeRetry");
                }
                if (string.has("EnableFastOpen")) {
                    this.mEnableFastOpenStream = string.optInt("EnableFastOpen");
                }
                if (string.has("EnableLowLatencyFLV")) {
                    this.mEnableLowLatencyFLV = string.optInt("EnableLowLatencyFLV");
                }
                if (string.has("EnableSkipFlvNullTag")) {
                    this.mEnableSkipFlvNullTag = string.optInt("EnableSkipFlvNullTag");
                }
                if (string.has("LiveIOConfig") && (jSONObject = string.optJSONObject("LiveIOConfig")) != null) {
                    if (jSONObject.has("EnableLiveIO")) {
                        this.mEnableLiveIOPlay = jSONObject.optInt("EnableLiveIO");
                    }
                    if (jSONObject.has("EnableP2P")) {
                        this.mEnableLiveIOP2P = jSONObject.optInt("EnableP2P");
                    }
                    if (jSONObject.has("EnableHttpPrepare")) {
                        this.mEnableHttpPrepare = jSONObject.optInt("EnableHttpPrepare");
                    }
                    if (jSONObject.has("EnableP2pUp")) {
                        this.mEnableP2pUp = jSONObject.optInt("EnableP2pUp");
                    }
                    if (jSONObject.has("LiveIOABGroupID")) {
                        this.mLiveIOABGroupID = jSONObject.optInt("LiveIOABGroupID");
                    }
                }
                if (string.has("EnableNTPByApp")) {
                    this.mLogService.mEnableNTP = this.mEnableNTP = string.optInt("EnableNTPByApp");
                    if (this.mEnableNTP == 1 && this.mSettingsBundle != null) {
                        this.mLogService.mTimeDiff = this.mSettingsBundle.getSettingsValueForKey("time_diff_server_and_client", 0L);
                    }
                }
                if (string.has("NoSyncReportMinDuration")) {
                    this.mNoSyncReportMinDuration = string.optInt("NoSyncReportMinDuration");
                }
                if (string.has("NoSyncReportReportThres")) {
                    this.mNoSyncReportReportThres = string.optInt("NoSyncReportReportThres");
                }
            }
            catch (JSONException jSONException) {
                q.d(jSONException);
            }
        }
        this.mLogService.mDefaultResBitrate = this.mDefaultResBitrate;
    }

    private void _configWithLowLatencyFLVStrategy(JSONObject jSONObject) {
        if (jSONObject == null) {
            return;
        }
        if (jSONObject.has("net_effective_connection_type_strategy")) {
            try {
                jSONObject.getJSONObject("net_effective_connection_type_strategy");
                return;
            }
            catch (JSONException jSONException) {
                q.d(jSONException);
                return;
            }
        }
    }

    private void _configFlvLowLatencyWithSDKParam() {
        String string = this.mURLSource.getSDKParams(this.mResolution, this.mLevel);
        if (string != null) {
            try {
                JSONObject jSONObject;
                string = new JSONObject(string);
                if (string.has("NetworkAdapt") && (jSONObject = new JSONObject(string.optString("NetworkAdapt"))).has("Enabled")) {
                    this.mEnableHurryFlag = jSONObject.optInt("Enabled");
                    if (this.mEnableHurryFlag == 1) {
                        this.mHurryType = 0;
                    }
                    if (jSONObject.has("HurryTime")) {
                        this.mHurryTime = jSONObject.optInt("HurryTime");
                        this.mPlayer.setIntOption(15, this.mHurryTime);
                        this.mLogService.mHurryTime = this.mHurryTime;
                    }
                    if (jSONObject.has("HurryMillisecond")) {
                        this.mHurryTime = jSONObject.optInt("HurryMillisecond");
                        this.mPlayer.setIntOption(397, this.mHurryTime);
                        this.mLogService.mHurryTime = this.mHurryTime;
                    }
                    if (jSONObject.has("HurrySpeed")) {
                        this.mCatchSpeed = Float.parseFloat(jSONObject.optString("HurrySpeed"));
                        this.mPlayer.setFloatOption(80, this.mCatchSpeed);
                        this.mLogService.mCatchSpeed = this.mCatchSpeed;
                    }
                    if (jSONObject.has("SlowTime")) {
                        this.mSlowPlayTime = jSONObject.optInt("SlowTime");
                        this.mPlayer.setIntOption(190, this.mSlowPlayTime);
                        this.mLogService.mSlowPlayTime = this.mSlowPlayTime;
                    }
                    if (jSONObject.has("SlowMillisecond")) {
                        this.mSlowPlayTime = jSONObject.optInt("SlowMillisecond");
                        this.mPlayer.setIntOption(398, this.mSlowPlayTime);
                        this.mLogService.mSlowPlayTime = this.mSlowPlayTime;
                    }
                    if (jSONObject.has("SlowSpeed")) {
                        this.mSlowPlaySpeed = Float.parseFloat(jSONObject.optString("SlowSpeed"));
                        this.mPlayer.setFloatOption(191, this.mSlowPlaySpeed);
                        this.mLogService.mSlowSpeed = this.mSlowPlaySpeed;
                    }
                }
                if (string.has("FastOpenDuration")) {
                    mFastOpenDuration = string.optInt("FastOpenDuration");
                }
                if (string.has("EnableLowLatencyFLV")) {
                    this.mEnableLowLatencyFLV = string.optInt("EnableLowLatencyFLV");
                    this.mLogService.getStallTotalCount();
                    this.mLogService.getRetryTotalCount();
                }
                return;
            }
            catch (JSONException jSONException) {
                q.d(jSONException);
            }
        }
    }

    private void _checkValidAbrResolution() {
        if (!this.mAbrStrategy.equals("abr_bb_4live") || !this.mEnableResolutionAutoDegrade) {
            return;
        }
        if (!this.mURLSource.isEnableAdaptive(this.mResolution)) {
            for (int i2 = 0; i2 < LiveConfigKey.resolution.length; ++i2) {
                if (!this.mURLSource.isEnableAdaptive(LiveConfigKey.resolution[i2])) continue;
                MyLog.i(TAG, "Abr res check.modify from " + this.mResolution + " to " + LiveConfigKey.resolution[i2]);
                this.mResolution = LiveConfigKey.resolution[i2];
                return;
            }
        }
    }

    private void _requestSwitchUrlFromServer() {
        this.mLogService.mIsCdnAbrSwitch = true;
        if (this.mURLSource.getSourceType() == 2 && !this.mURLSource.isCodecSame(this.mLevel)) {
            return;
        }
        if (this.mExecutor.isShutdown()) {
            return;
        }
        this.mExecutor.submit(new Runnable(){

            @Override
            public void run() {
                VideoLiveManager.this._doRequestSwitchUrlFromServer();
            }
        });
    }

    private void _doRequestSwitchUrlFromServer() {
        if (TextUtils.isEmpty((CharSequence)this.mCdnSessionPath) || TextUtils.isEmpty((CharSequence)this.mCdnAbrResolution) || this.mCdnAbrResolution.equals(this.mResolution)) {
            return;
        }
        if (this.mPlayer == null) {
            return;
        }
        String object = this.mPlayer.getStringOption(335);
        if (object == null) {
            return;
        }
        MyLog.i(TAG, "responseHeaders: " + object);
        String string = null;
        for (String string2 : object.split("\r\n")) {
            if (!string2.startsWith("X-Has-Token: ")) continue;
            string = string2.split(": ", 2)[1];
        }
        try {
            String string3;
            String string2;
            JSONObject jSONObject = new JSONObject();
            if (!TextUtils.isEmpty((CharSequence)this.mLogService.mSessionId)) {
                jSONObject.put("live_stream_session_id", (Object)this.mLogService.mSessionId);
            }
            if (TextUtils.isEmpty((CharSequence)(string3 = this.mURLSource.getPlayURLForResolution(this.mCdnAbrResolution, "flv", this.mLevel)))) {
                return;
            }
            jSONObject.put("play_url", (Object)string3);
            if (!TextUtils.isEmpty((CharSequence)string)) {
                jSONObject.put("token", (Object)string);
            }
            String string4 = string3;
            String string5 = string4.substring(string4.indexOf("//") + 2);
            string2 = string5.substring(string5.indexOf("/"));
            if (!this.mCdnSessionPath.startsWith("/")) {
                this.mCdnSessionPath = "/" + this.mCdnSessionPath;
            }
            string = string3.substring(0, string3.indexOf(string2)) + this.mCdnSessionPath;
            MyLog.i(TAG, "sending 'POST' request to URL : " + string);
            MyLog.i(TAG, "httpBody: " + jSONObject);
            INetworkClient.Result result = this.mNetworkClient.doPost(string, jSONObject.toString());
            if (result != null) {
                MyLog.i(TAG, "response: " + result.response);
                MyLog.i(TAG, "code: " + result.code);
                this.mLogService.mCdnAbrSwitchCode = result.code;
                if (result.code == 200 && result.response.has("code")) {
                    this.mLogService.mCdnAbrSwitchCode = result.response.optInt("code");
                    if (this.mLogService.mCdnAbrSwitchCode == 0) {
                        this.mResolution = this.mCdnAbrResolution;
                    }
                }
            }
            return;
        }
        catch (Exception exception) {
            q.d(exception);
            return;
        }
    }

    private void _checkStreamData() {
        if (this.mURLSource == null) {
            return;
        }
        this.mURLSource.setEnableOriginResolution(this.mEnableOriginResolution);
        if (this.mEnableResolutionAutoDegrade && this.mURLSource.getSourceType() == 2 && this.mAbrStrategy.equals("abr_bb_4live")) {
            String string = this.mURLSource.getDefaultResolution();
            if (!TextUtils.isEmpty((CharSequence)string)) {
                if (!this.mEnableOriginResolution && string.equals("origin")) {
                    this._smartResolveDefaultResolution("uhd");
                } else {
                    this._smartResolveDefaultResolution(string);
                }
            }
            if (!this.mURLSource.isABRListMatch() || !this.mURLSource.isCodecSame(this.mLevel)) {
                this.mResolution = this.mURLSource.getDefaultResolution();
                this.mAbrStrategy = "rad";
                this.mEnableResolutionAutoDegrade = false;
                if (!this.mURLSource.isABRListMatch()) {
                    this.mLogService.mABRListMatch = 0;
                }
                if (!this.mURLSource.isCodecSame(this.mLevel)) {
                    this.mLogService.mCodecNotSame = 1;
                }
            }
        }
    }

    private void _smartResolveDefaultResolution(String string) {
        if (!this.mAbrStrategy.equals("abr_bb_4live") || !this.mEnableResolutionAutoDegrade) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        if (string.equals("ld")) {
            block28: while (!TextUtils.isEmpty((CharSequence)string)) {
                if (!TextUtils.isEmpty((CharSequence)this.mURLSource.getPlayURLForResolution(string, this.mStreamFormat, this.mLevel))) {
                    this.mURLSource.setDefaultResolution(string);
                    this.mLogService.mAutoUsingResolution = this.mURLSource.getDefaultResolution();
                    return;
                }
                int n2 = -1;
                switch (string.hashCode()) {
                    case -1008619738: {
                        if (!string.equals("origin")) break;
                        n2 = 0;
                        break;
                    }
                    case 115761: {
                        if (!string.equals("uhd")) break;
                        n2 = 1;
                        break;
                    }
                    case 3324: {
                        if (!string.equals("hd")) break;
                        n2 = 2;
                        break;
                    }
                    case 3665: {
                        if (!string.equals("sd")) break;
                        n2 = 3;
                        break;
                    }
                    case 3448: {
                        if (!string.equals("ld")) break;
                        n2 = 4;
                    }
                }
                switch (n2) {
                    case 0: {
                        string = null;
                        continue block28;
                    }
                    case 1: {
                        string = "origin";
                        continue block28;
                    }
                    case 2: {
                        string = "uhd";
                        continue block28;
                    }
                    case 3: {
                        string = "hd";
                        continue block28;
                    }
                    case 4: {
                        string = "sd";
                        continue block28;
                    }
                }
                string = null;
            }
            return;
        }
        block29: while (!TextUtils.isEmpty((CharSequence)string)) {
            if (!TextUtils.isEmpty((CharSequence)this.mURLSource.getPlayURLForResolution(string, this.mStreamFormat, this.mLevel))) {
                this.mURLSource.setDefaultResolution(string);
                this.mLogService.mAutoUsingResolution = this.mURLSource.getDefaultResolution();
                return;
            }
            int n3 = -1;
            switch (string.hashCode()) {
                case -1008619738: {
                    if (!string.equals("origin")) break;
                    n3 = 0;
                    break;
                }
                case 115761: {
                    if (!string.equals("uhd")) break;
                    n3 = 1;
                    break;
                }
                case 3324: {
                    if (!string.equals("hd")) break;
                    n3 = 2;
                    break;
                }
                case 3665: {
                    if (!string.equals("sd")) break;
                    n3 = 3;
                    break;
                }
                case 3448: {
                    if (!string.equals("ld")) break;
                    n3 = 4;
                }
            }
            switch (n3) {
                case 0: {
                    string = "uhd";
                    continue block29;
                }
                case 1: {
                    string = "hd";
                    continue block29;
                }
                case 2: {
                    string = "sd";
                    continue block29;
                }
                case 3: {
                    string = "ld";
                    continue block29;
                }
                case 4: {
                    string = null;
                    continue block29;
                }
            }
            string = null;
        }
        if (TextUtils.isEmpty((CharSequence)string)) {
            MyLog.w(TAG, string + " not found");
        }
    }

    private void _configAbrInfo() {
        JSONObject jSONObject = this.mURLSource.getAbrInfo();
        if (jSONObject != null) {
            this.mHasAbrInfo = true;
            try {
                if (jSONObject.has("enable")) {
                    int n2 = jSONObject.optInt("enable");
                    boolean bl = this.mEnableResolutionAutoDegrade = n2 == 1;
                }
                if (jSONObject.has("strategy")) {
                    this.mAbrStrategy = jSONObject.getString("strategy");
                }
                if (jSONObject.has("enable_origin_resolution")) {
                    boolean bl = this.mEnableOriginResolution = jSONObject.optInt("enable_origin_resolution") == 1;
                }
                if (jSONObject.has("disable_algorithm")) {
                    this.mABRDisableAlgorithm = jSONObject.optInt("disable_algorithm");
                }
                return;
            }
            catch (JSONException jSONException) {
                q.d(jSONException);
                this.mHasAbrInfo = false;
                this.mEnableResolutionAutoDegrade = false;
                this.mAbrStrategy = "rad";
                this.mEnableOriginResolution = false;
                this.mStallCountThresOfResolutionDegrade = 4;
                return;
            }
        }
        this.mHasAbrInfo = false;
        this.mEnableResolutionAutoDegrade = false;
        this.mEnableOriginResolution = false;
        this.mAbrStrategy = "rad";
        this.mStallCountThresOfResolutionDegrade = 4;
    }

    @Override
    public void setStringOption(int n2, String string) {
        String string2 = "";
        switch (n2) {
            case 26: {
                string2 = string2 + "cacheFilePath:" + string;
                this.mCacheFilePath = string;
                if (this.mPlayer == null) break;
                this.mCacheFileKey = "" + System.currentTimeMillis();
                this.mPlayer.setStringOption(17, this.mCacheFileKey);
                this.mPlayer.setIntOption(14, 1);
                this.mPlayer.setCacheFile(string, 1);
                break;
            }
            case 43: {
                long l2;
                string2 = string2 + "set resolution:" + string;
                this.saveCurrentResolution();
                this.mResolution = string;
                if (this.mPlayer == null || this.mURLSource == null || this.mURLSource.getSourceType() != 2 || (l2 = this.mURLSource.getBitrate(this.mResolution, this.mLevel)) <= 0L) break;
                this.mPlayer.setIntOption(650, (int)l2);
                this.mLogService.mUseExpectBitrate = 1;
                break;
            }
            case 60: {
                string2 = string2 + "set stream format:" + string;
                this.mStreamFormat = string;
                this.mLogService.setFormatInfo(this.mStreamFormat, this.mStreamFormat);
                if (this.mPlayer == null || !this.mStreamFormat.equals("avph") && !this.mStreamFormat.equals("cmaf")) break;
                this.mPlayer.setStringOption(315, string);
                break;
            }
            case 63: {
                this.mLogService.mEnterMethod = string;
                break;
            }
            case 64: {
                this.mLogService.mEnterAction = string;
                break;
            }
            case 65: {
                string2 = string2 + " abr strategy:" + string;
                this.mAbrStrategy = string;
                break;
            }
            case 66: {
                string2 = string2 + "set transport protocol:" + string;
                if (string.equals("tcp") || string.equals("quic")) {
                    this.mTransportProtocol = string;
                }
                this.mQuicPull = true;
                break;
            }
            case 72: {
                string2 = string2 + "set sr kernal bin path:" + string;
                this.mTextureSRBinPath = string;
                break;
            }
            case 73: {
                string2 = string2 + "set sr ocl module path:" + string;
                this.mTextureSROclModuleName = string;
                break;
            }
            case 74: {
                string2 = string2 + "set sr dsp module path:" + string;
                this.mTextureSRDspModuleName = string;
                break;
            }
            case 81: {
                string2 = string2 + "toB module id:" + string;
                this.mMoudleIDToB = string;
                break;
            }
            case 86: {
                string2 = string2 + "switch resolution of cdn abr:" + string;
                this.mCdnAbrResolution = string;
                this._requestSwitchUrlFromServer();
                break;
            }
            case 89: {
                string2 = string2 + "set_url_host:" + string;
                this.mURLHost = string;
            }
        }
        MyLog.i(TAG, "setStringOption " + string2);
    }

    @Override
    public String getStringOption(int n2, String string) {
        switch (n2) {
            case 57: {
                string = this.mCurrentPlayURL;
                break;
            }
            case 58: {
                string = this.mResolution;
                break;
            }
            case 65: {
                string = this.mAbrStrategy;
                break;
            }
            case 60: {
                string = this.mStreamFormat;
            }
        }
        MyLog.i(TAG, "getStringOption: " + string);
        return string;
    }

    @Override
    public void setIntOption(int n2, int n3) {
        String string = "";
        switch (n2) {
            case 1: {
                string = string + "image_enhancement:" + n3;
                this.mEnhancementType = n3;
                if (this.mPlayer == null) break;
                this.mPlayer.setIntOption(37, n3);
                break;
            }
            case 2: {
                string = string + "image_scale:" + n3;
                this.mScaleType = n3;
                if (this.mPlayer == null) break;
                this.mPlayer.setIntOption(38, n3);
                break;
            }
            case 3: {
                string = string + "forbid_os_player:" + n3;
                TTPlayerConfiger.setValue(11, n3);
                break;
            }
            case 4: {
                string = string + "image_layout:" + n3;
                this.mLayoutType = n3;
                if (this.mPlayer == null) break;
                this.mPlayer.setIntOption(36, n3);
                break;
            }
            case 5: {
                string = string + "render_type:" + n3;
                this.mRenderType = n3;
                if (this.mPlayer == null) break;
                this.mPlayer.setIntOption(56, n3);
                break;
            }
            case 7: {
                string = string + "hard_decode:" + n3;
                this.mHardwareDecodeEnable = n3;
                if (this.mPlayer == null) break;
                this.mPlayer.setIntOption(59, n3);
                break;
            }
            case 8: {
                string = string + "enable_cache_file:" + n3;
                this.mCacheFileEnable = n3;
                if (this.mPlayer == null) break;
                this.mPlayer.setIntOption(14, 1);
                break;
            }
            case 9: {
                string = string + "bytevc1_decoder_type:" + n3;
                this.mByteVC1DecoderType = n3;
                if (this.mPlayer == null) break;
                this.mPlayer.setIntOption(67, n3);
                break;
            }
            case 10: {
                string = string + "buffering_millSeconds:" + n3;
                this.mBufferDataSeconds = n3;
                if (this.mPlayer == null) break;
                this.mPlayer.setIntOption(86, n3);
                break;
            }
            case 11: {
                string = string + "buffering_timeout:" + n3;
                this.mBufferTimeout = n3;
                if (this.mPlayer == null) break;
                this.mPlayer.setIntOption(81, n3);
                break;
            }
            case 12: {
                string = string + "network_timeout:" + n3;
                this.mNetworkTimeout = n3;
                if (this.mPlayer == null) break;
                this.mPlayer.setIntOption(9, n3 * 1000000);
                break;
            }
            case 15: {
                string = string + "use_external_dir:" + n3;
                this.mUseExternalDir = n3;
                break;
            }
            case 16: {
                string = string + "use_test_action:" + n3;
                this.mTestAction = n3;
                if (this.mPlayer == null) break;
                this.mPlayer.setIntOption(83, this.mTestAction);
                break;
            }
            case 17: {
                if (this.mEnableLowLatencyFLV == 1) {
                    string = string + "invalid settings on low latency flv, hurry_time:" + n3;
                    break;
                }
                string = string + "hurry_time:" + n3;
                this.mHurryTime = n3;
                if (this.mPlayer == null) break;
                this.mPlayer.setIntOption(15, n3);
                this.mLogService.mHurryTime = n3;
                break;
            }
            case 83: {
                this.mHurryTime = n3;
                string = string + "hurry_time:" + n3;
                if (this.mPlayer == null) break;
                this.mPlayer.setIntOption(397, n3);
                this.mLogService.mHurryTime = n3;
                break;
            }
            case 18: {
                string = string + "hurry_type:" + n3;
                this.mHurryType = n3;
                if (this.mPlayer == null) break;
                this.mPlayer.setIntOption(84, n3);
                break;
            }
            case 21: {
                if (this.mEnableLowLatencyFLV == 1) {
                    string = string + "invalid settings on low latency flv, slow_play_time:" + n3;
                    break;
                }
                string = string + "slow_play_time:" + n3;
                this.mSlowPlayTime = n3;
                if (this.mPlayer == null) break;
                this.mPlayer.setIntOption(190, n3);
                this.mLogService.mSlowPlayTime = n3;
                break;
            }
            case 84: {
                string = string + "slow_play_time:" + n3;
                this.mSlowPlayTime = n3;
                if (this.mPlayer == null) break;
                this.mPlayer.setIntOption(398, n3);
                this.mLogService.mSlowPlayTime = n3;
                break;
            }
            case 25: {
                string = string + "player_degrade_mode:" + n3;
                this.mPlayerDegradeMode = n3;
                break;
            }
            case 31: {
                string = string + "url_ability:" + n3;
                this.mURLAbility = n3;
                if (n3 == 1) {
                    this.mLogService.mUrlAbility = "h264";
                    break;
                }
                if (n3 != 2) break;
                this.mLogService.mUrlAbility = "bytevc1";
                break;
            }
            case 32: {
                string = string + "enable_sharp:" + n3;
                this.mEnableSharp = n3;
                break;
            }
            case 33: {
                string = string + "asyncInit:" + n3;
                this.mEnableMediaCodecASYNCInit = n3;
                if (this.mPlayer == null || this.mHardwareDecodeEnable != 1) break;
                this.mPlayer.setIntOption(181, n3);
                this.mLogService.mMediaCodecAsyncInit = n3;
                break;
            }
            case 34: {
                string = string + "defaultCodecID:" + n3;
                this.mDefaultCodecId = n3;
                if (this.mPlayer == null) break;
                this.mPlayer.setIntOption(182, n3);
                this.mLogService.mDefaultCodecID = n3;
                break;
            }
            case 35: {
                string = string + "enable 264 hardware decode " + n3;
                this.mEnableH264HardwareDecode = n3;
                break;
            }
            case 36: {
                string = string + "enable bytevc1 hardware decode " + n3;
                this.mEnableByteVC1HardwareDecode = n3;
                break;
            }
            case 37: {
                string = string + "set max cache" + n3;
                this.mMaxCacheSeconds = n3;
                if (this.mPlayer == null) break;
                this.mPlayer.setIntOption(198, n3);
                this.mLogService.mMaxCacheSeconds = n3;
                break;
            }
            case 38: {
                string = string + "enable test split " + n3;
                this.mEnableSplitStream = n3;
                if (this.mPlayer == null) break;
                this.mPlayer.setIntOption(87, n3);
                this.mLogService.mEnableSplitStream = n3;
                break;
            }
            case 22: {
                string = string + "check side data" + n3;
                this.mOpenCheckSideData = n3;
                if (this.mPlayer == null) break;
                this.mPlayer.setIntOption(132, n3);
                break;
            }
            case 39: {
                string = string + "enable httpk degrade:" + n3;
                this.mEnableHttpkDegrade = n3;
                break;
            }
            case 40: {
                string = string + "enable fast open:" + n3;
                this.mEnableFastOpenStream = n3;
                break;
            }
            case 41: {
                string = string + "enable upload sei:" + n3;
                this.mEnableUploadSei = n3;
                break;
            }
            case 42: {
                string = string + "enable NTP:" + n3;
                this.mEnableNTPTask = n3;
                break;
            }
            case 48: {
                string = string + "enable mediaLoader:" + n3;
                this.mEnableOpenMDL = n3;
                break;
            }
            case 44: {
                string = string + "set in main looper:" + n3;
                this.mIsInMainLooper = n3;
                break;
            }
            case 46: {
                string = string + "buffering end ignore video:" + n3;
                this.mCheckBufferingEndIgnoreVideo = n3;
                if (this.mPlayer == null) break;
                this.mPlayer.setIntOption(310, n3);
                this.mLogService.mCheckBufferingEndIgnoreVideo = n3;
                break;
            }
            case 47: {
                string = string + "start direct:" + n3;
                this.mStartDirectAfterPrepared = n3;
                if (this.mPlayer == null) break;
                this.mPlayer.setIntOption(311, n3);
                this.mLogService.mStartDirectAfterPrepared = n3;
                break;
            }
            case 54: {
                string = string + "check buffering end advance:" + n3;
                this.mCheckBufferingEndAdvanceEnable = n3;
                if (this.mPlayer == null) break;
                this.mPlayer.setIntOption(313, n3);
                this.mLogService.mCheckBufferingEndAdvanceEnable = n3;
                break;
            }
            case 55: {
                string = string + "set stall count thre:" + n3;
                this.mStallCountThresOfResolutionDegrade = n3;
                break;
            }
            case 56: {
                string = string + "enable resolution degrade:" + n3;
                this.mEnableResolutionAutoDegrade = n3 == 1;
                break;
            }
            case 61: {
                string = string + "enable tcp fast open:" + n3;
                this.mEnableTcpFastOpen = n3;
                if (this.mPlayer == null) break;
                this.mPlayer.setIntOption(316, n3);
                break;
            }
            case 62: {
                string = string + "enable check packet corrupt:" + n3;
                this.mEnableCheckPacketCorrupt = n3;
                if (this.mPlayer == null) break;
                this.mPlayer.setIntOption(317, n3);
                break;
            }
            case 67: {
                string = string + "enable flv abr:" + n3;
                this.mEnableFlvABR = n3;
                break;
            }
            case 69: {
                string = string + "enable texture render:" + n3;
                this.mEnableTextureRender = n3;
                break;
            }
            case 70: {
                string = string + "enable texture sr:" + n3;
                this.mEnableTextureSR = n3;
                break;
            }
            case 77: {
                string = string + "tsl time shift:" + n3;
                this.mTslTimeShift = n3;
                this.mLogService.mTslTimeShift = n3;
                break;
            }
            case 80: {
                string = string + "toB switch :" + n3;
                this.mSwitchToB = n3;
                break;
            }
            case 82: {
                string = string + "enable mult_sei:" + n3;
                this.mEnableDecodeMultiSei = n3;
                break;
            }
            case 85: {
                string = string + "enable free flow:" + n3;
                this.mEnableFreeFlow = n3;
            }
        }
        MyLog.i(TAG, "setIntOption " + string);
    }

    public long getIntOption(int n2, long l2) {
        switch (n2) {
            case 0: {
                if (this.mPlayer != null) {
                    return this.mPlayer.getLongOption(63, 0L) * 8L / 1000L;
                }
                return l2;
            }
            case 68: {
                if (this.mPlayer != null) {
                    return this.mPlayer.getLongOption(63, 0L) * 8L / 1000L;
                }
                return l2;
            }
            case 78: {
                if (this.mPlayer != null) {
                    return this.mPlayer.getIntOption(379, 0);
                }
                return l2;
            }
            case 79: {
                return this.mTslMinTimeShit;
            }
        }
        return l2;
    }

    @Override
    public void setLongOption(int n2, long l2) {
        String string = "";
        switch (n2) {
            case 45: {
                string = string + "startPlayBufferThreshold:" + l2;
                this.mStartPlayBufferThres = l2;
                if (this.mPlayer == null || this.mStartPlayBufferThres <= 0L) break;
                this.mPlayer.setLongOption(309, l2);
                this.mLogService.mStartPlayBufferThres = l2;
                break;
            }
            case 59: {
                string = string + "set alog func:" + l2;
                this.mALogWriteAddr = l2;
            }
        }
        MyLog.i(TAG, "setLongOptin " + string);
    }

    @Override
    public void setFloatOption(int n2, float f2) {
        String string = "";
        switch (n2) {
            case 19: {
                if (this.mEnableLowLatencyFLV == 1) {
                    string = string + "invalid settings on low latency flv, catch_speed:" + f2;
                    break;
                }
                string = string + "catch_speed:" + f2;
                this.mCatchSpeed = f2;
                if (this.mPlayer == null) break;
                this.mPlayer.setFloatOption(80, f2);
                this.mLogService.mCatchSpeed = f2;
                break;
            }
            case 20: {
                if (this.mEnableLowLatencyFLV == 1) {
                    string = string + "invalid settings on low latency flv, slow_speed:" + f2;
                    break;
                }
                string = string + "slow_speed:" + f2;
                this.mSlowPlaySpeed = f2;
                if (this.mPlayer == null) break;
                this.mPlayer.setFloatOption(191, f2);
                this.mLogService.mSlowSpeed = f2;
            }
        }
        MyLog.i(TAG, "setFloatOption " + string);
    }

    private void open() {
        TTPlayerConfiger.setValue(1, this.mPlayerType != 0);
        TTPlayerConfiger.setValue(2, this.mPlayerType == 2);
        TTPlayerConfiger.setValue(6, false);
        TTPlayerConfiger.setValue(11, true);
        if (this.mPlayer != null && this.mPlayer.isOSPlayer() ^ this.mPlayerType == 0) {
            this.mPlayer.releaseAsync();
            this.mPlayer = null;
        }
        if (this.mPlayer == null) {
            this.mPlayer = MediaPlayerWrapper.create(this.mContext, this.mPlayerDegradeMode);
            MediaLoaderWrapper.getDataLoader().setMediaPlayer(this.mPlayer);
            if (this.mPlayer.getPlayerType() != 1 && this.mPlayer.getPlayerType() != 2) {
                this.mHardwareDecodeEnable = 0;
                this.mEnableH264HardwareDecode = 0;
                this.mEnableByteVC1HardwareDecode = 0;
            }
            this.configPlayerGlobalOption();
            this.configPlayerEventHandler();
        }
        if (this.mPlayer.isOSPlayer()) {
            this.mLogService.setPlayerSdkVersion("-1");
        } else {
            this.mLogService.setPlayerSdkVersion(TTPlayerConfiger.getValue(14, "0"));
        }
        this.mDnsParser.configure(this.mForceHttpDns, this.mHttpDNSServerHost);
        if (this.mFetcher == null) {
            this.mFetcher = new LiveDataFetcher(this.mExecutor, this.mNetworkClient);
        }
        this.mPlayerSetting.setPlayer(this.mPlayer);
    }

    @Override
    public void pause() {
        MyLog.i(TAG, "pause");
        this.checkMainLooper("pause");
        if (this.mPlayer != null && this.mPlayer.isPlaying()) {
            this.mLivePlayerState = LivePlayerState.PAUSED;
            this.mPlayer.pause();
        }
    }

    @Override
    public void play() {
        Object object;
        this.mListener.onReportALog(4, "play start -- " + this.hashCode());
        this.checkMainLooper("play");
        if (this.mLivePlayerState == LivePlayerState.PLAYED) {
            this.mLogService.onIllegalAPICall("play");
            this.mListener.onReportALog(6, "illegal call: play -- " + this.hashCode());
            return;
        }
        if (this.mLivePlayerState == LivePlayerState.PAUSED) {
            this.mLivePlayerState = LivePlayerState.PLAYED;
            if (this.mPlayer != null) {
                this.mPlayer.start();
            }
            return;
        }
        MyLog.i(TAG, "play");
        if (this.mURLSource.getSourceType() == 2) {
            this._configAbrInfo();
            this._setStreamFormat();
            this._setProtocol();
            this._checkStreamData();
        }
        if (this.mSettingsBundle != null) {
            this.mURLSource.setEnableSR(this.mSettingsBundle.getSettingsValueForKey("live_sdk_super_resolution_enable", 0));
            this.setIntOption(69, this.mSettingsBundle.getSettingsValueForKey("live_sdk_texture_render_enable", 0));
            if (this.mSettingsBundle.getSettingsValueForKey("live_sdk_sharpen_enable", 0) == 1) {
                this.mSharpenSdkParams = this.mURLSource.getSharpenParams(this.mResolution, this.mLevel);
                if (this.mSharpenSdkParams != null) {
                    this.mEnableSharpen = this.mSharpenSdkParams.optInt("Enabled");
                }
            }
        }
        this.setIntOption(70, this.mURLSource.getSREnabled(this.mResolution, this.mLevel) ? 1 : 0);
        this.mLivePlayerState = LivePlayerState.PLAYED;
        this.mFrameTerminatedDTS = -1L;
        this.mLatestAudioPacketDTS = -1L;
        String string = null;
        if (this.mURLSource != null) {
            if (this.mURLSource.getSourceType() == 1 && this.mURLSource.getPlayLiveURL() != null) {
                string = this.mURLSource.getPlayLiveURL().mainURL;
                object = this.mIsLocalURL ? this.mLocalURL : string;
                if (object != null) {
                    if (((String)object).startsWith("http")) {
                        this.mTransportProtocol = "tcp";
                    }
                    if (((String)object).startsWith("https")) {
                        this.mTransportProtocol = "tls";
                    }
                    if (((String)object).startsWith("httpk")) {
                        this.mTransportProtocol = "kcp";
                    }
                    this.mURLProtocol = this.mTransportProtocol;
                }
                object = "";
                if (this.mQuicPull) {
                    try {
                        LibraryLoader.loadLibrary("ttquic");
                        this.mQuicEnable = true;
                        MyLog.i(TAG, "ttquic lib is load success");
                        this.mLogService.setQuicLibLoader(1);
                        object = "quic";
                    }
                    catch (Throwable throwable) {
                        object = this.mTransportProtocol;
                        this.mQuicEnable = false;
                        MyLog.i(TAG, "ttquic lib is load failed. change default protocol");
                        this.mLogService.setQuicLibLoader(0);
                    }
                }
                this.mTransportProtocol = ((String)object).isEmpty() ? this.mTransportProtocol : object;
            } else if (this.mURLSource.getSourceType() == 2) {
                string = this.mURLSource.getPlayURLForResolution(this.mResolution.equals("auto") ? this.mURLSource.getDefaultResolution() : this.mResolution, this.mStreamFormat, this.mLevel);
            }
        }
        if (this.mIsLocalURL) {
            string = this.mLocalURL;
        }
        if (string != null) {
            this.mUuid = this.mURLSource.getSessionID();
            if (TextUtils.isEmpty((CharSequence)this.mUuid)) {
                this.mUuid = UUID.randomUUID().toString().replace("-", "").toLowerCase();
            }
            this.mLogService.setProtocolInfo(this.mSuggestProtocol, this.mTransportProtocol);
            this.mLogService.reset();
            this.mLogService.mSessionId = this.mUuid + "." + System.currentTimeMillis();
            this.mLogService.mRuleIds = this.mURLSource.getRuleIds();
            this.mLogService.mResolution = this.mResolution;
            this.mLogService.mAutoUsingResolution = this.mURLSource.getDefaultResolution();
            this.mLogService.onPlay(this.mIsLocalURL ? this.mLocalURL : string, this.mDnsParser.getDNSServerIP());
            this._play(string);
            this.mRetryProcessor.start();
        } else {
            object = new HashMap<String, String>();
            ((HashMap)object).put("url", "no playurl found while play");
            object = new LiveError(-100002, "playURL is null", (Map<String, String>)object);
            this.mRetryProcessor.onError((LiveError)object, this.mShowedFirstFrame);
        }
        if (this.mEnableStallCounter == 1) {
            this.startStallCounter();
        }
        this.mListener.onReportALog(4, "play end -- " + this.hashCode());
    }

    private void _play(String string) {
        if (this.mPrepareState == PlayerState.PREPARED && this.mPlayer != null) {
            MyLog.i(TAG, "_play resume");
            if (this.mCurrentIP != null) {
                this.mLogService.setCdnIp(this.mCurrentIP, false);
            }
            this.mPlayer.start();
        } else if (this.mPrepareState == PlayerState.IDLE || this.mPlayer == null) {
            MyLog.i(TAG, "_play start");
            this.open();
            this.mPrepareState = PlayerState.INITIALIZED;
            if (this.mIsLocalURL && !TextUtils.isEmpty((CharSequence)this.mLocalURL)) {
                this.mLogService.onCallPrepare();
                VideoLiveManager videoLiveManager = this;
                videoLiveManager.prepareToPlay(videoLiveManager.mLocalURL, null, null, null);
            } else {
                this.parsePlayDNS(string);
            }
        } else {
            this.configPlayerGlobalOption();
            if (this.mIsLocalURL && !TextUtils.isEmpty((CharSequence)this.mLocalURL)) {
                VideoLiveManager videoLiveManager = this;
                videoLiveManager.prepareToPlay(videoLiveManager.mLocalURL, null, null, null);
            } else {
                this.parsePlayDNS(string);
            }
        }
        this.mIsRequestCanceled = false;
    }

    void doResolutionChange(String string) {
    }

    @Override
    public void stop() {
        MyLog.i(TAG, "stop");
        this.mListener.onReportALog(4, "stop start -- " + this.hashCode());
        this.checkMainLooper("stop");
        this._stop(true, "stop");
        this.mRetryProcessor.stop();
        this.mListener.onReportALog(4, "stop end-- " + this.hashCode());
    }

    private void _stop(boolean bl, String string) {
        MyLog.i(TAG, "_stop");
        if (this.mLivePlayerState != LivePlayerState.PLAYED && this.mLivePlayerState != LivePlayerState.PAUSED) {
            this.mLogService.onIllegalAPICall(string);
            this.mListener.onReportALog(6, "illegal call: " + string + " -- " + this.hashCode());
            return;
        }
        if (bl) {
            this._stopPlayer();
        } else {
            this.mPrepareState = PlayerState.INITIALIZED;
        }
        this._stopLiveManager(string);
        this.mLivePlayerState = LivePlayerState.STOPPED;
        this.mSupportSRScene = 0;
        this.mTextureSRMode = 0;
        this.mEnableReportSessionStop = 0;
        this.mLogService.mMuteAudio = -1;
        this.mLogService.mVolumeSetting = -1.0f;
        this.mLogService.mPlayerVolumeSetting = -1.0f;
    }

    private void _stopPlayer() {
        MyLog.i(TAG, "_stopPlayer");
        if (this.mPlayer != null && (this.mPrepareState == PlayerState.PREPARED || this.mPrepareState == PlayerState.PREPARING)) {
            if (this.mLogService != null) {
                this.mLogService.getABRStreamInfo();
                this.mLogService.getAVPHStreamInfo();
                if (this.mEnableCheckFrame == 1 || this.mEnableCheckSEI == 1) {
                    this.mLogService.resetStreamCheckParams();
                }
            }
            if (this.mLivePlayerState != LivePlayerState.PAUSED) {
                this.mPlayer.stop();
            } else {
                this.mPlayer.reset();
            }
        }
        if (this.mIsPlayWithMdl && this.mSessionId != null) {
            MediaLoaderWrapper.getDataLoader().setInt64ValueByStrKey(8018, this.mSessionId, 0);
        }
        this.mPrepareState = PlayerState.INITIALIZED;
        MyLog.i(TAG, "prepareState: " + (Object)((Object)this.mPrepareState));
    }

    private void _stopLiveManager(String string) {
        MyLog.i(TAG, "_stopLiveManager");
        if (this.mFetcher != null) {
            this.mFetcher.cancel();
        }
        if (this.mDnsParser != null) {
            this.mDnsParser.cancel();
        }
        if (this.mLivePlayerState == LivePlayerState.PLAYED || this.mLivePlayerState == LivePlayerState.PAUSED) {
            this.onRenderStallForRetryStop();
            if (this.mIsStalling) {
                this.mLogService.onStallEnd(0);
            }
            this.mLogService.close(string);
        }
        this.setIntOption(75, 0);
        this.mLogService.reset();
        this.mRetryProcessor.reset();
        if (string.equals("reset")) {
            this.mURLSource.reset();
        }
        this.mShowedFirstFrame = false;
        this.mRenderStartEntered = false;
        this.mResolutionDisableSR = true;
        this.mMediaSupportSR = false;
        this.mStallStartTime = 0L;
        this.mStallTotalTime = 0L;
        this.mStallCount = 0;
        this.mIsRequestCanceled = true;
        this.mLivePlayerState = LivePlayerState.STOPPED;
        this.mHasSeiInfo = false;
        this.mGetSeiCurrentTime = 0L;
        this.mIsStalling = false;
        this.mIsRetrying = false;
        this.mHasRetry = false;
        this.mSupportBackupIp = true;
        this.mUrlSettingMethod = -1;
        this.mEnableDTSCheck = 0;
        this.mEnablePreventDTSBack = 0;
        this.mEnableCheckFrame = 0;
        this.mEnterStallRetryInstantly = false;
        this.mEnableAvLines = "";
        this.mEnableSaveSCFG = false;
        this.mStreamFormat = "flv";
        this.mTransportProtocol = "tcp";
        this.mSuggestProtocol = "none";
        this.mEnableVideoMpdRefresh = 1;
        this.mEnableQuicCertVerify = false;
        this.mTextureSRMode = 0;
        this.mSupportSRScene = 0;
        this.mEnableTextureSR = 0;
        this.mEnableTextureRender = 0;
        this.mQuicVersion = 39;
        this.mQuicInitMTU = 1200;
        this.mEnableQuicMTUDiscovery = 0;
        this.mQuicInitRtt = 0;
        this.mQuicMaxCryptoRetransmissions = 0;
        this.mQuicMaxCryptoRetransmissionTimeMs = 0;
        this.mQuicMaxRetransmissions = 0;
        this.mQuicMaxRetransmissionTimeMs = 0;
        this.mQuicMaxAckDelay = 0;
        this.mQuicMinReceivedBeforeAckDecimation = 0;
        this.mQuicPadHello = 1;
        this.mQuicFixWillingAndAbleToWrite = 1;
        this.mQuicFixProcessTimer = 1;
        this.mQuicReadBlockTimeout = 100;
        this.mQuicReadBlockMode = 0;
        this.mQuicFixStreamFinAndRst = 0;
        this.mQuicConfigOptimize = 0;
        this.mEnableCheckDropAudio = 0;
        this.mIsPlayWithMdl = false;
        this.mAVNoSyncThreshold = 10000;
        this.mIsAlwaysDoAVSync = 0;
        this.mRedoDns = false;
        this.mEnableLiveAbrCheckEnhance = 0;
        this.mLiveABRCheckInterval = 1000;
        this.mABRMethod = -1;
        this.mRtcEnableDtls = 0;
        this.mRtcFallbackThreshold = 5000;
        this.mRtcMinJitterBuffer = 300;
        this.mRtcPlayFallBack = 0;
        this.mEnableRtcPlay = 0;
        this.mRtcEnableSDKDns = 0;
        this.mRtcEarlyInitRender = 0;
        this.mEnableFreeFlow = 0;
        this.mABRDisableAlgorithm = 0;
        this.mTextureRenderFirstFrame = false;
        this.mUsePlayerRenderStart = false;
        mFastOpenDuration = -1;
        this.mMyHandler.removeCallbacksAndMessages(null);
        if (this.mEnableStallCounter == 1) {
            this.stopStallCounter();
        }
        this.mNoSyncReportMinDuration = 5000;
        this.mNoSyncReportReportThres = 200;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startStallCounter() {
        Object object = this.mStallCounterLock;
        synchronized (object) {
            if (this.mStallCounterIsRunning) {
                return;
            }
            if (this.mStallCounterThread == null) {
                this.mStallCounterThread = new HandlerThread("stallCounter");
                this.mStallCounterThread.start();
            }
            if (this.mStallCounterHandler == null) {
                this.mStallCounterHandler = new Handler(this.mStallCounterThread.getLooper());
            }
            this.mStallCounterHandler.post((Runnable)this.mVideoStallCountTask);
            this.mStallCounterIsRunning = true;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopStallCounter() {
        Object object = this.mStallCounterLock;
        synchronized (object) {
            if (this.mStallCounterHandler != null) {
                this.mStallCounterHandler.removeCallbacksAndMessages(null);
            }
            this.mStallCounterIsRunning = false;
            return;
        }
    }

    @Override
    public void reset() {
        MyLog.i(TAG, "reset");
        this.checkMainLooper("reset");
        if (this.mPlayer == null) {
            return;
        }
        this._reset("reset");
        this.mLogService.reset();
        this.mCacheFileKey = null;
        this.mCacheFilePath = null;
        this.mEnableResolutionAutoDegrade = false;
        this.mEnableOriginResolution = false;
        this.mEnableSwitchMainAndBackupUrl = true;
        this.mEnableTextureSR = 0;
        this.mEnableTextureRender = 0;
        this.mTextureSRMode = 0;
        this.mResolution = "origin";
        this.mResolutionIndex = -1;
        this.mStreamFormat = "flv";
        this.mTransportProtocol = "tcp";
        this.mSuggestProtocol = "none";
        this.mLevel = "main";
        this.mLocalURL = null;
        this.mIsLocalURL = false;
        this.mEnableHurryFlag = 0;
        this.mHurryType = -1;
        this.mEnableAvLines = "";
        this.mEnableSaveSCFG = false;
        this.mShowedFirstFrame = false;
        this.mEnableLLASHFastOpen = 0;
    }

    private void _resetPlayer() {
        MyLog.i(TAG, "_resetPlayer");
        if (this.mPlayer != null) {
            this.mPlayer.reset();
        }
        this.mPrepareState = PlayerState.INITIALIZED;
    }

    private void _reset(String string) {
        MyLog.i(TAG, "_reset");
        this._stopPlayer();
        this._resetPlayer();
        this._stopLiveManager(string);
        this.mResolutionIndex = -1;
        this.mLivePlayerState = LivePlayerState.IDLE;
    }

    @Override
    public void release() {
        MyLog.i(TAG, "release start");
        this.mListener.onReportALog(4, "release start -- " + this.hashCode());
        this.checkMainLooper("release");
        if (this.mLivePlayerState == LivePlayerState.PLAYED || this.mLivePlayerState == LivePlayerState.PAUSED) {
            this._stop(true, "release");
        }
        this.releaseTextureRenderRef();
        this.mExecutor.shutdown();
        this.mMyHandler.removeCallbacksAndMessages(null);
        if (this.mPlayer == null) {
            return;
        }
        this.mPlayer.release();
        this.mPlayer = null;
        this.mLogService.reset();
        this.mPrepareState = PlayerState.IDLE;
        this.mLivePlayerState = LivePlayerState.IDLE;
        MyLog.i(TAG, "release end");
        this.mListener.onReportALog(4, "release end -- " + this.hashCode());
    }

    @Override
    public void releaseAsync() {
        this.mListener.onReportALog(4, "releaseAsync start -- " + this.hashCode());
        MyLog.i(TAG, "releaseAsync");
        this.checkMainLooper("releaseAsync");
        if (this.mLivePlayerState == LivePlayerState.PLAYED || this.mLivePlayerState == LivePlayerState.PAUSED) {
            this._stop(false, "releaseAsync");
        }
        this.mExecutor.shutdown();
        this.mMyHandler.removeCallbacksAndMessages(null);
        if (this.mPlayer == null) {
            return;
        }
        if (this.mSurfaceHolder != null) {
            this.mPlayer.setDisplay(null);
        }
        this.releaseTextureRenderRef();
        MediaPlayer mediaPlayer = this.mPlayer;
        this.mPlayer = null;
        this.mLogService.reset();
        this.mPrepareState = PlayerState.IDLE;
        this.mLivePlayerState = LivePlayerState.IDLE;
        LiveThreadPool.addExecuteTask(new MyReleaseRunnable(mediaPlayer));
        MyLog.i(TAG, "releaseAsync end");
        this.mListener.onReportALog(4, "releaseAsync end -- " + this.hashCode());
    }

    @Override
    public boolean isOsPlayer() {
        return this.mPlayer != null && this.mPlayer.isOSPlayer();
    }

    @Override
    public boolean isIPPlayer() {
        return this.mPlayer != null && this.mPlayer.getPlayerType() == 2;
    }

    @Override
    public boolean isPlaying() {
        return this.mPlayer != null && this.mPlayer.isPlaying();
    }

    @Override
    public int getVideoWidth() {
        if (this.mPlayer != null) {
            return this.mPlayer.getVideoWidth();
        }
        return 0;
    }

    @Override
    public int getVideoHeight() {
        if (this.mPlayer != null) {
            return this.mPlayer.getVideoHeight();
        }
        return 0;
    }

    @Override
    public float getMaxVolume() {
        return this.mPlayerSetting.getMaxVolume();
    }

    @Override
    public float getVolume() {
        return this.mPlayerSetting.getVolume();
    }

    @Override
    public void setVolume(float f2) {
        this.mPlayerSetting.setVolume(f2);
        this.mLogService.mVolumeSetting = f2;
    }

    @Override
    public float getPlayerVolume() {
        return this.mPlayerSetting.getPlayerVolume();
    }

    @Override
    public void setPlayerVolume(float f2) {
        this.mPlayerSetting.setPlayerVolume(f2);
        this.mLogService.mPlayerVolumeSetting = f2;
    }

    @Override
    public void setMute(Boolean bl) {
        this.mPlayerSetting.setMute(bl);
        this.mLogService.mMuteAudio = bl != false ? 1 : 0;
    }

    @Override
    public void setDisableVideoRender(Boolean bl) {
        MyLog.i(TAG, "setDisableVideoRender: " + bl);
        int n2 = this.mLogService.mDisableVideoRender = bl != false ? 1 : 0;
        if (this.mEnableRadioLiveDisableRender == 1 && this.mPlayer != null) {
            this.mPlayer.setIntOption(261, bl != false ? 1 : 0);
        }
    }

    @Override
    public void setVideoFormat(String string) {
        this.mStreamFormat = string;
    }

    @Override
    public String getPlayerErrorInfo() {
        if (this.mPlayer != null) {
            return this.mPlayer.getStringOption(5002);
        }
        return "none";
    }

    @Override
    public String getServerIP() {
        return this.mCurrentIP;
    }

    @Override
    public JSONObject getStaticLog() {
        if (this.mLogService == null) {
            return null;
        }
        return this.mLogService.getStaticLog();
    }

    @Override
    public void setAsyncInit(int n2) {
        String.format("setAsyncInit enable:%b", n2);
        this.mEnableMediaCodecASYNCInit = n2;
    }

    public void getVideoCodecType() {
        if (this.mPlayer == null || this.mLogService == null) {
            return;
        }
        int n2 = this.mPlayer.getIntOption(141, -1);
        if (n2 == 0) {
            this.mLogService.setCodecType("h264");
            return;
        }
        if (n2 == 1) {
            this.mLogService.setCodecType("bytevc1");
        }
    }

    public int getUrlSettingMethod() {
        return this.mUrlSettingMethod;
    }

    public boolean getSRState() {
        return false;
    }

    public boolean getSharpenState() {
        return false;
    }

    public long getNtpTimeDiff() {
        if (this.mSettingsBundle != null) {
            return this.mSettingsBundle.getSettingsValueForKey("time_diff_server_and_client", 0L);
        }
        return 0L;
    }

    public int getEnableTexturerender() {
        return this.mEnableTextureRender;
    }

    public int getEnableSR() {
        return this.mEnableTextureSR;
    }

    public void getSessionlogInfo(LogBundle logBundle) {
        if (logBundle == null || this.mPlayer == null) {
            return;
        }
        logBundle.playerDNSTimestamp = this.mPlayer.getLongOption(68, -1L);
        logBundle.tfoFallBackTime = this.mPlayer.getLongOption(318, -1L);
        logBundle.dropAudioPts = this.mPlayer.getLongOption(345, -1L);
        logBundle.dropAudioCostTime = this.mPlayer.getLongOption(346, -1L);
        logBundle.tcpConnectTimestamp = this.mPlayer.getLongOption(69, -1L);
        logBundle.tcpFirstPacketTimestamp = this.mPlayer.getLongOption(70, -1L);
        logBundle.videoPacketTimestamp = this.mPlayer.getLongOption(75, -1L);
        logBundle.audioPacketTimestamp = this.mPlayer.getLongOption(76, -1L);
        logBundle.videoDecodeTimestamp = this.mPlayer.getLongOption(77, -1L);
        logBundle.audioDecodeTimestamp = this.mPlayer.getLongOption(78, -1L);
        logBundle.videoDeviceOpenTime = this.mPlayer.getLongOption(155, -1L);
        logBundle.videoDeviceOpenedTime = this.mPlayer.getLongOption(162, -1L);
        logBundle.audioDeviceOpenTime = this.mPlayer.getLongOption(156, -1L);
        logBundle.audioDeviceOpenedTime = this.mPlayer.getLongOption(163, -1L);
        logBundle.downloadSpeed = this.mPlayer.getLongOption(63, 0L) * 8L / 1000L;
        logBundle.audioBufferTime = this.mPlayer.getLongOption(73, 0L);
        logBundle.videoBufferTime = this.mPlayer.getLongOption(72, 0L);
        logBundle.resolution = this.mResolution;
        logBundle.videoParamSendOutletTime = this.mPlayer.getLongOption(458, 0L);
        logBundle.firstVideoFrameSendOutletTime = this.mPlayer.getLongOption(459, 0L);
        logBundle.renderType = this.mPlayer.getVideoType();
        logBundle.streamInfoFindTime = this.mPlayer.getLongOption(624, 0L);
        logBundle.streamInfoFoundTime = this.mPlayer.getLongOption(338, 0L);
        logBundle.videoDeviceWaitStartTime = this.mPlayer.getLongOption(336, 0L);
        logBundle.videoDeviceWaitEndTime = this.mPlayer.getLongOption(337, 0L);
        logBundle.videoFirstPacketPos = this.mPlayer.getLongOption(341, -1L);
        logBundle.videoFirstPacketPts = this.mPlayer.getLongOption(343, -1L);
        logBundle.audioFirstPacketPos = this.mPlayer.getLongOption(342, -1L);
        logBundle.audioFirstPacketPts = this.mPlayer.getLongOption(344, -1L);
        logBundle.httpReqFinishTimestamp = this.mPlayer.getLongOption(821, 0L);
        logBundle.httpResFinishTimestamp = this.mPlayer.getLongOption(822, 0L);
        logBundle.downloadSize = this.mPlayer.getLongOption(45, 0L);
    }

    public void getLogInfo(LogBundle logBundle, int n2) {
        String string;
        if (logBundle == null || this.mPlayer == null) {
            return;
        }
        logBundle.quicOpenResult = this.mPlayer.getIntOption(355, -1);
        logBundle.quicConfigCached = this.mPlayer.getIntOption(351, -1);
        logBundle.isTooLargeAVDiff = this.mPlayer.getIntOption(349, 0);
        if (n2 == 0 || n2 == 2) {
            logBundle.playerDNSTimestamp = this.mPlayer.getLongOption(68, -1L);
            logBundle.tfoFallBackTime = this.mPlayer.getLongOption(318, -1L);
            logBundle.dropAudioPts = this.mPlayer.getLongOption(345, -1L);
            logBundle.dropAudioCostTime = this.mPlayer.getLongOption(346, -1L);
            logBundle.downloadSize = this.mPlayer.getLongOption(45, 0L);
            if (this.mStreamFormat != null && (this.mStreamFormat.equals("cmaf") || this.mStreamFormat.equals("avph"))) {
                logBundle.videoDNSTimestamp = this.mPlayer.getLongOption(264, -1L);
                logBundle.audioDNSTimestamp = this.mPlayer.getLongOption(267, -1L);
                logBundle.videoTcpConnectTimestamp = this.mPlayer.getLongOption(265, -1L);
                logBundle.audioTcpConnectTimestamp = this.mPlayer.getLongOption(268, -1L);
                logBundle.audioTcpFirstPacketTimestamp = this.mPlayer.getLongOption(269, -1L);
                logBundle.videoTcpFirstPacketTimestamp = this.mPlayer.getLongOption(266, -1L);
                logBundle.videoHttpReqFinishTimestamp = this.mPlayer.getLongOption(272, -1L);
                logBundle.audioHttpReqFinishTimestamp = this.mPlayer.getLongOption(273, -1L);
                logBundle.videoHttpResFinishTimestamp = this.mPlayer.getLongOption(274, -1L);
                logBundle.audioHttpResFinishTimestamp = this.mPlayer.getLongOption(275, -1L);
                if (this.mStreamFormat.equals("cmaf")) {
                    logBundle.cmafMpdDNSTimestamp = this.mPlayer.getLongOption(457, -1L);
                    logBundle.cmafMpdTcpConntectTimestamp = this.mPlayer.getLongOption(450, -1L);
                    logBundle.cmafMdpTcpFirstPacketTimestamp = this.mPlayer.getLongOption(451, -1L);
                    logBundle.cmafMpdConntectTimestamp = this.mPlayer.getLongOption(452, -1L);
                    logBundle.cmafMdpHttpResFinishTimestamp = this.mPlayer.getLongOption(456, -1L);
                    logBundle.cmafAudioFirstSegConntectTimestamp = this.mPlayer.getLongOption(453, -1L);
                    logBundle.cmafVideoFirstSegConntectTimestamp = this.mPlayer.getLongOption(454, -1L);
                    logBundle.cmafMdpHttpReqFinishTimestamp = this.mPlayer.getLongOption(455, -1L);
                }
            }
            if (this.isRtcPlayAvailable()) {
                logBundle.rtcInitedTime = this.mPlayer.getLongOption(806, -1L);
                logBundle.rtcOfferSendTime = this.mPlayer.getLongOption(807, -1L);
                logBundle.rtcAnswerRecvTime = this.mPlayer.getLongOption(808, -1L);
                logBundle.rtcStartTime = this.mPlayer.getLongOption(809, -1L);
            }
            logBundle.tcpConnectTimestamp = this.mPlayer.getLongOption(69, -1L);
            logBundle.tcpFirstPacketTimestamp = this.mPlayer.getLongOption(70, -1L);
            logBundle.videoPacketTimestamp = this.mPlayer.getLongOption(75, -1L);
            logBundle.audioPacketTimestamp = this.mPlayer.getLongOption(76, -1L);
            logBundle.videoDecodeTimestamp = this.mPlayer.getLongOption(77, -1L);
            logBundle.audioDecodeTimestamp = this.mPlayer.getLongOption(78, -1L);
            logBundle.videoDeviceOpenTime = this.mPlayer.getLongOption(155, -1L);
            logBundle.videoDeviceOpenedTime = this.mPlayer.getLongOption(162, -1L);
            logBundle.audioDeviceOpenTime = this.mPlayer.getLongOption(156, -1L);
            logBundle.audioDeviceOpenedTime = this.mPlayer.getLongOption(163, -1L);
            logBundle.downloadSpeed = this.mPlayer.getLongOption(63, 0L) * 8L / 1000L;
            logBundle.audioBufferTime = this.mPlayer.getLongOption(73, 0L);
            logBundle.videoBufferTime = this.mPlayer.getLongOption(72, 0L);
            logBundle.resolution = this.mResolution;
            logBundle.videoParamSendOutletTime = this.mPlayer.getLongOption(458, 0L);
            logBundle.firstVideoFrameSendOutletTime = this.mPlayer.getLongOption(459, 0L);
            logBundle.renderType = this.mPlayer.getVideoType();
            logBundle.streamInfoFindTime = this.mPlayer.getLongOption(624, 0L);
            logBundle.streamInfoFoundTime = this.mPlayer.getLongOption(338, 0L);
            logBundle.videoDeviceWaitStartTime = this.mPlayer.getLongOption(336, 0L);
            logBundle.videoDeviceWaitEndTime = this.mPlayer.getLongOption(337, 0L);
            logBundle.videoFirstPacketPos = this.mPlayer.getLongOption(341, -1L);
            logBundle.videoFirstPacketPts = this.mPlayer.getLongOption(343, -1L);
            logBundle.audioFirstPacketPos = this.mPlayer.getLongOption(342, -1L);
            logBundle.audioFirstPacketPts = this.mPlayer.getLongOption(344, -1L);
            logBundle.httpReqFinishTimestamp = this.mPlayer.getLongOption(821, 0L);
            logBundle.httpResFinishTimestamp = this.mPlayer.getLongOption(822, 0L);
            if (n2 == 0) {
                logBundle.tfoSuccess = this.mPlayer.getIntOption(518, -1);
                logBundle.downloadSpeedOnFirstFrame = logBundle.downloadSpeed;
                logBundle.videoBufferTimeOnFirstFrame = logBundle.videoBufferTime;
                logBundle.audioBufferTimeOnFirstFrame = logBundle.audioBufferTime;
                logBundle.dnsIP = this.mDnsParser.getDNSServerIP();
                logBundle.videoRenderTimeForPlayerCore = this.mPlayer.getLongOption(210, -1L);
                logBundle.videoRenderTimestamp = System.currentTimeMillis();
                this.parseResponseHeaders(logBundle);
            }
            if (!this.mHasRetry && n2 == 2) {
                logBundle.waitingTimeAfterFirstFrame = this.mPlayer.getLongOption(314, 0L);
            }
            if (n2 == 0) {
                logBundle.quicFirstFrameCHLOCount = this.mPlayer.getIntOption(352, -1);
            }
        } else if (n2 == 1) {
            logBundle.downloadSize = this.mPlayer.getLongOption(45, 0L);
            logBundle.playedSize = this.mPlayer.getLongOption(46, 0L);
            logBundle.fps = this.mPlayer.getFloatOption(150, 0.0f);
            logBundle.downloadSpeed = this.mPlayer.getLongOption(63, 0L) * 8L / 1000L;
            logBundle.audioBufferTime = this.mPlayer.getLongOption(73, 0L);
            logBundle.videoBufferTime = this.mPlayer.getLongOption(72, 0L);
            logBundle.currentPosition = this.mPlayer.getCurrentPosition();
            logBundle.playTime = System.currentTimeMillis();
            logBundle.dnsIP = this.mDnsParser.getDNSServerIP();
            logBundle.resolution = this.mResolution;
            if (this.isRtcPlayAvailable()) {
                logBundle.rtcStatInfo = this.mPlayer.getStringOption(810);
                this.addRtcCodecInfo(logBundle.rtcStatInfo);
            }
        } else if (n2 == 3) {
            logBundle.fps = this.mPlayer.getFloatOption(150, 0.0f);
            logBundle.downloadSpeed = this.mPlayer.getLongOption(63, 0L) * 8L / 1000L;
            logBundle.audioBufferTime = this.mPlayer.getLongOption(73, 0L);
            logBundle.resolution = this.mResolution;
        } else if (n2 == 4) {
            logBundle.audioBufferTime = this.mPlayer.getLongOption(73, 0L);
            logBundle.videoBufferTime = this.mPlayer.getLongOption(72, 0L);
        } else if (n2 == 5) {
            logBundle.audioBufferTimeOnStallStart = this.mPlayer.getLongOption(73, -1L);
            logBundle.videoBufferTimeOnStallStart = this.mPlayer.getLongOption(72, -1L);
        } else if (n2 == 6) {
            logBundle.audioBufferTimeOnStallEnd = this.mPlayer.getLongOption(73, -1L);
            logBundle.videoBufferTimeOnStallEnd = this.mPlayer.getLongOption(72, -1L);
        } else if (n2 == 7) {
            n2 = this.mPlayer.getIntOption(61, -1);
            int n3 = this.mPlayer.getIntOption(62, -1);
            if (n2 == 1) {
                logBundle.mStreamType = n3 == 1 ? 2 : 1;
            } else if (n3 == 1) {
                logBundle.mStreamType = 0;
            }
        } else if (n2 == 8) {
            String string2 = this.mPlayer.getStringOption(147);
            if (string2 != null) {
                logBundle.mABRStreamInfo = this.formatABRStreamInfoToJSONArray(string2);
            }
        } else if (n2 == 9 && !TextUtils.isEmpty((CharSequence)(string = this.mPlayer.getStringOption(710)))) {
            logBundle.avphStreamInfo = this.formatAVPHStreamInfoToJSONArray(string);
        }
        if (logBundle.quicFirstFrameCHLOCount != -1) {
            logBundle.quicCHLOCount = logBundle.quicFirstFrameCHLOCount;
            return;
        }
        logBundle.quicCHLOCount = this.mPlayer.getIntOption(352, -1);
    }

    private void addRtcCodecInfo(String string) {
        if (!TextUtils.isEmpty((CharSequence)string) && (TextUtils.isEmpty((CharSequence)this.mLogService.mCodecName) || "none_codec".equals(this.mLogService.mCodecName))) {
            try {
                String string2;
                string = new JSONObject(string);
                if (string.has("video_codec_impl_name") && !TextUtils.isEmpty((CharSequence)(string2 = string.optString("video_codec_impl_name")))) {
                    if ("MediaCodec".equals(string2)) {
                        this.mLogService.mCodecName = "hardware_codec";
                        this.mLogService.mHardDecodeEnable = true;
                    } else {
                        this.mLogService.mCodecName = "software_codec";
                        this.mLogService.mHardDecodeEnable = false;
                    }
                }
                if (string.has("video_codec_name") && !TextUtils.isEmpty((CharSequence)(string2 = string.optString("video_codec_name")))) {
                    this.mLogService.mCodecType = "ByteVC1".equalsIgnoreCase(string2) ? "bytevc1" : "h264";
                }
                MyLog.i(TAG, "addRtcCodecInfo mCodecName:" + this.mLogService.mCodecName + ", mCodecType:" + this.mLogService.mCodecType + ",mHardDecodeEnable:" + this.mLogService.mHardDecodeEnable);
                return;
            }
            catch (Exception exception) {}
        }
    }

    private void updateSessionFirstFrameInfo() {
        if (this.mLogService.mSessionLogBundle == null || this.mPlayer == null) {
            return;
        }
        this.mLogService.mSessionLogBundle.downloadSpeedOnFirstFrame = this.mPlayer.getLongOption(63, 0L) * 8L / 1000L;
        this.mLogService.mSessionLogBundle.videoBufferTimeOnFirstFrame = this.mPlayer.getLongOption(72, 0L);
        this.mLogService.mSessionLogBundle.audioBufferTimeOnFirstFrame = this.mPlayer.getLongOption(73, 0L);
    }

    private JSONObject extractAvphStreamInfo(String stringArray) {
        if (TextUtils.isEmpty((CharSequence)stringArray)) {
            return null;
        }
        JSONObject jSONObject = new JSONObject();
        try {
            for (String string : stringArray.split(",")) {
                if (string.startsWith("video_key")) {
                    jSONObject.put("video_key", Integer.parseInt(string.substring(10)));
                    continue;
                }
                if (string.startsWith("video_last_dts")) {
                    jSONObject.put("video_last_dts", Integer.parseInt(string.substring(15)));
                    continue;
                }
                if (string.startsWith("video_cur_dts")) {
                    jSONObject.put("video_cur_dts", Integer.parseInt(string.substring(14)));
                    continue;
                }
                if (string.startsWith("vv_dts_diff")) {
                    jSONObject.put("vv_dts_diff", Integer.parseInt(string.substring(12)));
                    continue;
                }
                if (string.startsWith("audio_cur_dts")) {
                    jSONObject.put("audio_cur_dts", Integer.parseInt(string.substring(14)));
                    continue;
                }
                if (string.startsWith("av_dts_diff")) {
                    jSONObject.put("av_dts_diff", Integer.parseInt(string.substring(12)));
                    continue;
                }
                if (string.startsWith("audio_first_pkt_ts")) {
                    jSONObject.put("audio_first_pkt_ts", Long.parseLong(string.substring(19)));
                    continue;
                }
                if (string.startsWith("audio_first_pkt_dts")) {
                    jSONObject.put("audio_first_pkt_dts", Long.parseLong(string.substring(20)));
                    continue;
                }
                if (string.startsWith("video_first_pkt_ts")) {
                    jSONObject.put("video_first_pkt_ts", Long.parseLong(string.substring(19)));
                    continue;
                }
                if (string.startsWith("video_first_pkt_dts")) {
                    jSONObject.put("video_first_pkt_dts", Long.parseLong(string.substring(20)));
                    continue;
                }
                if (string.startsWith("audio_open_input_cost")) {
                    jSONObject.put("audio_open_input_cost", Long.parseLong(string.substring(22)));
                    continue;
                }
                if (string.startsWith("audio_find_stream_info_cost")) {
                    jSONObject.put("audio_find_stream_info_cost", Long.parseLong(string.substring(28)));
                    continue;
                }
                if (string.startsWith("video_open_input_cost")) {
                    jSONObject.put("video_open_input_cost", Long.parseLong(string.substring(22)));
                    continue;
                }
                if (!string.startsWith("video_find_stream_info_cost")) continue;
                jSONObject.put("video_find_stream_info_cost", Long.parseLong(string.substring(28)));
            }
        }
        catch (JSONException jSONException) {
            q.d(jSONException);
            jSONObject = null;
        }
        catch (Exception exception) {
            q.d(exception);
            jSONObject = null;
        }
        return jSONObject;
    }

    private JSONArray formatAVPHStreamInfoToJSONArray(String jSONObject) {
        if (TextUtils.isEmpty((CharSequence)jSONObject)) {
            return null;
        }
        ArrayList<JSONObject> arrayList = new ArrayList<JSONObject>();
        if (jSONObject.contains(";")) {
            jSONObject = jSONObject.split(";");
            for (int i2 = 0; i2 < ((JSONObject)jSONObject).length; ++i2) {
                JSONObject jSONObject2 = this.extractAvphStreamInfo((String)jSONObject[i2]);
                if (jSONObject2 == null) continue;
                arrayList.add(jSONObject2);
            }
        } else if ((jSONObject = this.extractAvphStreamInfo((String)jSONObject)) != null) {
            arrayList.add(jSONObject);
        }
        return new JSONArray(arrayList);
    }

    private JSONArray formatABRStreamInfoToJSONArray(String string) {
        if (string == null) {
            return null;
        }
        try {
            ArrayList<JSONObject> arrayList = new ArrayList<JSONObject>();
            while (true) {
                JSONObject jSONObject = new JSONObject();
                int n2 = string.indexOf("index:");
                int n3 = string.indexOf(",pts_diff:");
                if (n2 < 0 || n3 < 0 || n2 >= n3) break;
                String string2 = string.substring(n2 += 6, n3);
                jSONObject.put("index", Integer.parseInt(string2));
                string = string.substring(n3);
                n3 = string.indexOf(",drop_dur:");
                if (n3 < 0 || 10 >= n3) break;
                string2 = string.substring(10, n3);
                jSONObject.put("pts_diff", Long.parseLong(string2));
                string = string.substring(n3);
                n3 = string.indexOf(",key:");
                if (n3 < 0 || 10 >= n3) break;
                string2 = string.substring(10, n3);
                jSONObject.put("drop_dur", Long.parseLong(string2));
                string = string.substring(n3);
                n3 = string.indexOf(",index:");
                if (n3 == -1) {
                    if (string.length() == 0) break;
                    string2 = string.substring(5);
                    jSONObject.put("key_frame", Integer.parseInt(string2));
                    arrayList.add(jSONObject);
                    q.d(TAG, "key: " + string2);
                    break;
                }
                if (5 >= n3) break;
                string2 = string.substring(5, n3);
                jSONObject.put("key_frame", Integer.parseInt(string2));
                arrayList.add(jSONObject);
                string = string.substring(n3 + 1);
            }
            string = new JSONArray(arrayList);
        }
        catch (JSONException jSONException) {
            string = null;
            q.d(jSONException);
        }
        return string;
    }

    private void parseResponseHeaders(LogBundle logBundle) {
        String[] stringArray = this.mPlayer.getStringOption(335);
        if (stringArray == null) {
            return;
        }
        for (String string : stringArray.split("\r\n")) {
            if (string.startsWith("X-Server-Ip: ")) {
                logBundle.headerXServerIP = string.split(": ", 2)[1];
                continue;
            }
            if (!string.startsWith("Via: ")) continue;
            logBundle.headerVia = string.split(": ", 2)[1];
        }
    }

    private void parsePlayDNS(String string) {
        MyLog.i(TAG, "parsePlayDNS");
        if (string == null || string.length() == 0) {
            if (this.mURLSource.getSourceType() == 1 && this.bytevc1DegradeH264(-100017)) {
                return;
            }
            if (this.mEnableSwitchMainAndBackupUrl && this.mURLSource.getSourceType() == 2 && this.switchMainAndBackupUrl(-100002)) {
                return;
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("url", "try out all urls");
            LiveError liveError = new LiveError(-100002, "try out all urls", hashMap);
            this.mRetryProcessor.onError(liveError, this.mShowedFirstFrame);
            return;
        }
        String string2 = this.mURLSource.getPortNum(this.mStreamFormat, this.mLevel, this.mTransportProtocol);
        if (!string.startsWith("rtmp") && string2 == null) {
            switch (this.mTransportProtocol) {
                case "tcp": {
                    string2 = "80";
                    break;
                }
                case "kcp": {
                    string2 = "8848";
                    break;
                }
                case "tls": {
                    string2 = "443";
                    break;
                }
                case "quic": {
                    string2 = "80";
                    break;
                }
                case "quicu": {
                    string2 = "80";
                }
            }
        }
        if (this.mEnableRtcPlay == 0 || this.mRtcPlayFallBack == 1) {
            string = this.set_url_port_scheme(string, string2);
            this.mURLSource.setTransportProtocol(this.mTransportProtocol, string2);
        }
        if (this.mStreamFormat != null && this.mStreamFormat.equals("avph")) {
            this.prepareAvphPlay();
        } else if (this.mEnableAvLines.equals("true") && this.mVideoOnly.equals("only_video=1") && !this.mAudioOnly.equals("only_audio=1")) {
            string = this._addParamToURL(string, "only_video", "1");
        } else if (this.mEnableAvLines.equals("true") && !this.mVideoOnly.equals("only_video=1") && this.mAudioOnly.equals("only_audio=1")) {
            string = this._addParamToURL(string, "only_audio", "1");
        }
        final String string3 = string;
        this.mLogService.setCdnIp("none", false);
        this.mCurrentPlayURL = string3;
        final String string4 = DnsHelper.getUrlHost(string3);
        if (DnsHelper.isIP(string4) || !this.mEnableDns || string4 == null) {
            this.mLogService.onSDKDNSComplete(false, false);
            this.mLogService.onCallPrepare();
            this.mLogService.setCdnIp(string4, false);
            if (!TextUtils.isEmpty((CharSequence)this.mURLHost) && DnsHelper.isIP(string4)) {
                String string5 = string3;
                this.prepareToPlay(string5, string5, null, this.mURLHost);
            } else {
                String string6 = string3;
                this.prepareToPlay(string6, string6, null, null);
            }
            this.mCurrentIP = string4;
            return;
        }
        this.mRetryProcessor.setHost(string4);
        this.mDnsParser.parseDns(string4, new DnsHelper.OnParseCompletionListener(){

            @Override
            public void onParseComplete(String string, String string2, LiveError object, boolean bl) {
                if (string4 == null || string == null || !string4.equals(string)) {
                    return;
                }
                VideoLiveManager.this.mLogService.onSDKDNSComplete(!bl, false);
                if (!bl) {
                    string = string2;
                    object = string3;
                    if (string2 == null || string2.length() == 0) {
                        string = "none";
                    } else {
                        VideoLiveManager.this.mDnsParser;
                        object = DnsHelper.hostToIPUrl(string3, string);
                    }
                    VideoLiveManager.this.mLogService.onCallPrepare();
                    VideoLiveManager.this.mLogService.setCdnIp(string, false);
                    VideoLiveManager.this.prepareToPlay((String)object, string3, string, string4);
                    VideoLiveManager.this.mCurrentIP = string;
                    return;
                }
                VideoLiveManager.this.runOnFrontCurrentThread(new Runnable((LiveError)object, string2){
                    final /* synthetic */ LiveError val$error;
                    final /* synthetic */ String val$ip;
                    {
                        this.val$error = liveError;
                        this.val$ip = string;
                    }

                    @Override
                    public void run() {
                        if (this.val$error != null) {
                            MyLog.i("DNSError", this.val$error.toString());
                            if (VideoLiveManager.this.mCancelSDKDNSFailRetry) {
                                VideoLiveManager.this.mLogService.onSDKDNSError(this.val$error);
                            } else {
                                VideoLiveManager.this.mRetryProcessor.onError(this.val$error, VideoLiveManager.this.mShowedFirstFrame);
                                return;
                            }
                        }
                        if (VideoLiveManager.this.mIsRequestCanceled) {
                            MyLog.i("DNSCancel", "cancel");
                            return;
                        }
                        String string = this.val$ip;
                        String string2 = string3;
                        if (this.val$ip == null || this.val$ip.length() == 0) {
                            string = "none";
                        } else {
                            VideoLiveManager.this.mDnsParser;
                            string2 = DnsHelper.hostToIPUrl(string3, string);
                        }
                        VideoLiveManager.this.mLogService.onCallPrepare();
                        VideoLiveManager.this.mLogService.setCdnIp(string, false);
                        VideoLiveManager.this.prepareToPlay(string2, string3, string, string4);
                        VideoLiveManager.this.mCurrentIP = string;
                    }
                });
            }
        });
    }

    private String prepareProxyURL(String object, String string, String string2, Map<String, String> map) {
        MyLog.i(TAG, "prepareProxy play url: " + (String)object + ", host: " + string2);
        if (!this.mTransportProtocol.equals("tcp") || !this.mStreamFormat.equals("flv") || this.mEnableResolutionAutoDegrade || TextUtils.isEmpty((CharSequence)this.mSessionId)) {
            object = "proxy not support format: " + this.mStreamFormat + ", proto: " + this.mTransportProtocol + ", abr: " + this.mEnableResolutionAutoDegrade + ", sessio id invalid: " + TextUtils.isEmpty((CharSequence)this.mSessionId);
            MyLog.i(TAG, (String)object);
            this.mLogService.mLiveIOErrorMsg = object;
            return null;
        }
        if (TextUtils.isEmpty((CharSequence)object) || TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        try {
            object = new URL((String)object);
            int n2 = ((URL)object).getPort() == -1 ? ((URL)object).getDefaultPort() : ((URL)object).getPort();
            object = new URL(((URL)object).getProtocol(), string2, n2, ((URL)object).getFile()).toString();
        }
        catch (Exception exception) {
            return null;
        }
        MyLog.i(TAG, "prepareProxy proxy url: " + (String)object);
        MyLog.i(TAG, "enable liveio:" + this.mEnableOpenLiveIO + " enable liveio play:" + this.mEnableLiveIOPlay);
        MyLog.i(TAG, "live mdl enable_from_sdk:" + this.mEnableOpenMDL + " enable_from_app:" + MediaLoaderWrapper.getDataLoader().getLongValueFromLoader(8100) + " is_running:" + MediaLoaderWrapper.getDataLoader().isRunning());
        if (this.mEnableOpenMDL != 1 || MediaLoaderWrapper.getDataLoader().getLongValueFromLoader(8100) != 1L || !MediaLoaderWrapper.getDataLoader().isRunning()) {
            return null;
        }
        if (this.mALogWriteAddr != -1L) {
            MediaLoaderWrapper.getDataLoader().setLongValue(59, this.mALogWriteAddr);
        }
        this.mIsPlayWithMdl = true;
        VideoLiveManager videoLiveManager = this;
        this.runOnCurrentThread(videoLiveManager.new PlayCacheSyncRunner(videoLiveManager, this.mSessionId, false));
        MyLog.i(TAG, "setup mdl play cache sync runner of :" + this.mSessionId);
        object = MediaLoaderWrapper.getDataLoader().getProxyUrl((String)object, this.mIsMdlProtoRegister);
        MyLog.i(TAG, "proxyUrl: " + (String)object);
        if (object != null && !((String)object).isEmpty()) {
            map.put("Stream-Type", "live");
            if (this.mSessionId != null) {
                map.put("X-Tt-Traceid", this.mSessionId);
            }
            if (string != null && !string.equals("none")) {
                if (string.startsWith("[")) {
                    string = string.substring(1, string.length() - 1);
                }
                map.put("X-Given-IPs", string);
            }
            try {
                JSONObject jSONObject = new JSONObject();
                if (object != null) {
                    jSONObject.put("url", object);
                }
                if (string != null) {
                    jSONObject.put("ip", (Object)string);
                }
                if (this.mSessionId != null) {
                    jSONObject.put("traceId", (Object)this.mSessionId);
                }
                MediaLoaderWrapper.getDataLoader().setStringValue(8017, jSONObject.toString());
            }
            catch (Exception exception) {
                MyLog.w(TAG, "set play info to mdl failed");
            }
            return object;
        }
        return null;
    }

    private String prepareLiveIOURL(String string, String string2, Map<String, String> map) {
        return string;
    }

    private String packAvphHeader(String string, String string2, String string3) {
        if (!string.equals("")) {
            string = string + "&";
        }
        string = string + string2;
        string = string + "=";
        return string + string3;
    }

    private void prepareAvphPlay() {
        this.mPlayer.setIntOption(159, this.mFramesDrop);
        this.mPlayer.setIntOption(653, this.mEnableSkipFindUnnecessaryStream);
        this.mPlayer.setIntOption(655, this.mAVPHDnsParseEnable);
        this.mPlayer.setIntOption(656, this.mAVPHDnsTimeout);
        this.mPlayer.setIntOption(326, this.mAVPHVideoProbesize);
        this.mPlayer.setIntOption(327, this.mAVPHVideoMaxDuration);
        this.mPlayer.setIntOption(328, this.mAVPHAudioProbesize);
        this.mPlayer.setIntOption(329, this.mAVPHAudioMaxDuration);
        this.mPlayer.setIntOption(330, this.mAVPHOpenVideoFirst);
        this.mPlayer.setIntOption(331, this.mAVPHMaxAVDiff);
        this.mPlayer.setIntOption(332, this.mAVPHEnableAutoReopen);
        this.mPlayer.setIntOption(712, this.mAVPHAutoExit);
        this.mPlayer.setIntOption(711, this.mAVPHVideoDiffThreshold);
        this.mPlayer.setIntOption(713, this.mAVPHReadRetryCount);
        this.mPlayer.setIntOption(714, this.mAVPHReadErrorExit);
        String string = new String();
        String string2 = new String();
        if (this.mAudioOnly.equals("only_audio=1")) {
            string = this.packAvphHeader(string, "only_audio", "1");
        }
        if (this.mVideoOnly.equals("only_video=1")) {
            string2 = this.packAvphHeader(string2, "only_video", "1");
        }
        this.mPlayer.setStringOption(376, string);
        this.mPlayer.setStringOption(377, string2);
    }

    private void prepareToPlay(String string, String string2, String string3, String string4) {
        Object object;
        Object object2;
        GenericDeclaration genericDeclaration;
        long l2;
        this.mLogService.mLastPrepareTime = l2 = System.currentTimeMillis();
        if (this.mUuid != null) {
            this.mSessionId = this.mUuid + "." + l2;
        }
        MyLog.i(TAG, "prepareToPlay:" + string);
        if (string == null || this.mPlayer == null) {
            return;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (string4 != null) {
            genericDeclaration = String.format(" %s", string4);
            hashMap.put("Host", (String)((Object)genericDeclaration));
        }
        if ((genericDeclaration = this.mURLSource.getHTTPHeaders()) != null) {
            hashMap.putAll((Map<String, String>)((Object)genericDeclaration));
            MyLog.i(TAG, "headers: " + ((Object)hashMap).toString());
        }
        if (this.mTransportProtocol.equals("quic") || this.mTransportProtocol.equals("quicu")) {
            hashMap.put("suggest_protocol", "quic");
            if (this.mEnableSaveSCFG) {
                this.mPlayer.setStringOption(353, j.d(this.mContext).getAbsolutePath() + "/pullstream.scfg");
            }
            if (this.mEnableQuicCertVerify) {
                try {
                    genericDeclaration = Class.forName("com.ss.avframework.transport.ContextUtils");
                    if (genericDeclaration != null) {
                        genericDeclaration = ((Class)genericDeclaration).getMethod("initApplicationContext", Context.class);
                        ((Method)genericDeclaration).setAccessible(true);
                        ((Method)genericDeclaration).invoke(null, this.mContext.getApplicationContext());
                    }
                    if ((genericDeclaration = Class.forName("com.ss.avframework.transport.JNIUtils")) != null) {
                        object2 = ((Class)genericDeclaration).getMethod("setClassLoader", ClassLoader.class);
                        ((Method)object2).setAccessible(true);
                        ((Method)object2).invoke(null, this.mContext.getClassLoader());
                    }
                }
                catch (Throwable throwable) {
                    this.mEnableQuicCertVerify = false;
                    q.t(TAG, "disable quic cert verify, " + throwable.toString());
                }
            }
            this.mPlayer.setIntOption(925, this.mQuicVersion);
            this.mPlayer.setIntOption(354, this.mEnableQuicCertVerify ? 1 : 0);
            this.mPlayer.setIntOption(357, this.mEnableQuicMTUDiscovery);
            this.mPlayer.setIntOption(356, this.mQuicInitMTU);
            this.mPlayer.setIntOption(388, this.mQuicInitRtt);
            this.mPlayer.setIntOption(389, this.mQuicMaxCryptoRetransmissions);
            this.mPlayer.setIntOption(390, this.mQuicMaxCryptoRetransmissionTimeMs);
            this.mPlayer.setIntOption(391, this.mQuicMaxRetransmissions);
            this.mPlayer.setIntOption(392, this.mQuicMaxRetransmissionTimeMs);
            this.mPlayer.setIntOption(393, this.mQuicMaxAckDelay);
            this.mPlayer.setIntOption(394, this.mQuicMinReceivedBeforeAckDecimation);
            this.mPlayer.setIntOption(395, this.mQuicPadHello);
            this.mPlayer.setIntOption(920, this.mQuicFixWillingAndAbleToWrite);
            this.mPlayer.setIntOption(921, this.mQuicFixProcessTimer);
            this.mPlayer.setIntOption(922, this.mQuicReadBlockTimeout);
            this.mPlayer.setIntOption(923, this.mQuicReadBlockMode);
            this.mPlayer.setIntOption(924, this.mQuicFixStreamFinAndRst);
            this.mPlayer.setIntOption(926, this.mQuicTimerVersion);
            this.mPlayer.setIntOption(927, this.mQuicConfigOptimize);
            this.mPlayer.setIntOption(652, this.mEnableSkipFlvNullTag);
            this.mPlayer.setIntOption(396, this.mTransportProtocol.equals("quicu") ? 1 : 0);
            this.mPlayer.setIntOption(928, this.mSessionReceiveWindow);
            this.mPlayer.setIntOption(929, this.mStreamReceiveWindow);
            this.mLogService.mQuicMtu = this.mQuicInitMTU;
            this.mLogService.mQuicScfgConfig = this.mEnableSaveSCFG ? 1 : 0;
            this.mLogService.mQuicPadHello = this.mQuicPadHello;
            this.mLogService.mQuicTimerVersion = this.mQuicTimerVersion;
        }
        this.mPlayer.setIntOption(372, this.mEnableDecodeMultiSei);
        this.mPlayer.setIntOption(648, this.mEnableDecodeSeiOnce);
        this.mPlayer.setIntOption(374, this.mForceDecodeMsGaps);
        this.mPlayer.setIntOption(373, this.mForceDecodeSwitch);
        this.mPlayer.setIntOption(375, this.mForceRenderMsGaps);
        this._configFlvLowLatencyWithSDKParam();
        this.mPlayer.setLongOption(309, this.mStartPlayBufferThres);
        this.mLogService.mStartPlayBufferThres = this.mStartPlayBufferThres;
        this.configPlayerInstanceOption();
        if (this.mPrepareState == PlayerState.PREPARED) {
            this.mPrepareState = PlayerState.INITIALIZED;
            this.mPlayer.reset();
            if (!(this.mCacheFileEnable != 1 || TextUtils.isEmpty((CharSequence)this.mCacheFilePath) || TextUtils.isEmpty((CharSequence)this.mCacheFileKey) || this.mIsCacheHasComplete)) {
                this.mPlayer.setStringOption(17, this.mCacheFileKey);
                this.mPlayer.setIntOption(14, 1);
                this.mPlayer.setCacheFile(this.mCacheFilePath, 1);
            }
        }
        int n2 = this.mURLSource.getCheckSilenceInterval(this.mResolution, this.mLevel);
        this.mLogService.setCheckSilenceInterval(n2);
        this.mPlayer.setIntOption(339, n2);
        MyLog.i(TAG, "mEnableResolutionAutoDegrade:" + this.mEnableResolutionAutoDegrade + ";mAbrStrategy:" + this.mAbrStrategy + ";mResolution:" + this.mResolution + (this.mResolution.equals("auto") ? ";auto default resolution:" + this.mURLSource.getDefaultResolution() : ""));
        this.mLogService.mFirstAudioPacketDTS = -1L;
        if (this.mLatestAudioPacketDTS > 0L) {
            this.mLogService.mPreviousAudioPacketDTS = this.mLatestAudioPacketDTS;
        }
        this.mLogService.mResolution = this.mResolution;
        this.mLogService.mResBitrate = this.mURLSource.getBitrate(this.mResolution.equals("auto") ? this.mURLSource.getDefaultResolution() : this.mResolution, this.mLevel);
        if (this.mEnablePreventDTSBack == 1 && this.mFrameTerminatedDTS != -1L && this.mPlayer != null) {
            MyLog.i(TAG, "prepareToPlay set dts:" + this.mFrameTerminatedDTS);
            this.mPlayer.setLongOption(633, this.mFrameTerminatedDTS);
            this.mPlayer.setLongOption(635, this.mFrameDroppingDTSMaxDiff);
        }
        try {
            if (!this.mIsLocalURL) {
                string = this.addSessionIdToURL(string, l2);
            }
            if (this.mStreamFormat.equals("flv") && mFastOpenDuration != -1) {
                string = this._addParamToURL(string, "abr_pts", String.format("%d", mFastOpenDuration));
            }
            if (this.mStreamFormat.equals("cmaf")) {
                string = this._addParamToURL(string, "play_start", "1");
            }
            if (this.mStreamFormat.equals("tsl")) {
                int n3 = this.mCurrentPlayURL.indexOf("TimeShiftFormat=") + 16;
                String string5 = this.mCurrentPlayURL.substring(n3);
                String string6 = string5 = string5.indexOf("&") > 0 ? string5.substring(0, string5.indexOf("&")) : string5;
                if (this.mTslTimeShift > 0) {
                    string = this._addParamToURL(string, string5, String.format("%d", this.mTslTimeShift));
                }
            }
            if (this.mTransportProtocol.equals("quicu")) {
                string = this._addParamToURL(string, "unreliable", "1");
            }
            if (this.mResolution.equals("auto") && this.mEnableResolutionAutoDegrade && this.mAbrStrategy.equals("abr_bb_4live") && this.mURLSource.getSourceType() == 2 && this.mStreamFormat.equals("flv")) {
                this.mLogService.mAutoUsingResolution = this.mURLSource.getDefaultResolution();
                if (this.mTargetOriginBitRate > 0L && this.mURLSource.adjustOriginBitRate(this.mStreamFormat, this.mLevel, this.mTargetOriginBitRate)) {
                    this.mLogService.mBitRateAbnormalType = 1;
                }
                this.mURLSource.setRequestParamsWithDNSIp("_session_id=" + this.mLogService.mSessionId, string3, string4);
                String string7 = this.mURLSource.getPlayURLForResolution(this.mResolution, this.mStreamFormat, this.mLevel);
                MyLog.i(TAG, "mpd url:" + string7);
                String string8 = string = string7 == null ? string : HTTP_FLV_ABR_PREFIX + string7;
                if (string7 != null) {
                    this.mPlayer.setStringOption(315, "llash");
                }
                this.mPlayer.setIntOption(324, 1);
                if (this.mShowedFirstFrame && this.mEnableLLASHFastOpen == 1) {
                    this.mPlayer.setIntOption(532, this.mEnableLLASHFastOpen);
                }
                if (this.mEnableLiveAbrCheckEnhance == 1) {
                    this.mLogService.mEnableLiveAbrCheckEnhance = 1;
                    this.mPlayer.setIntOption(533, this.mEnableLiveAbrCheckEnhance);
                    this.mPlayer.setIntOption(534, this.mLiveABRCheckInterval);
                }
                if (this.mABRMethod >= 0) {
                    this.mPlayer.setIntOption(535, this.mABRMethod);
                }
                if (this.mABRBufferThreshold > 0) {
                    this.mPlayer.setIntOption(543, this.mABRBufferThreshold);
                }
            }
            if ((object = this.prepareProxyURL(string, string3, string4, hashMap)) != null) {
                string = object;
                MyLog.i(TAG, "proxyUrl: " + string + " headers: " + ((Object)hashMap).toString());
            }
            if (this.isRtcPlayAvailable()) {
                MyLog.i(TAG, "set rtc play config parameters");
                this.mLogService.mEnableRtcPlay = 1;
                this.mPlayer.setIntOption(801, 1);
                this.mPlayer.setIntOption(802, 1);
                this.mPlayer.setIntOption(803, 3);
                this.mPlayer.setIntOption(804, 1000);
                this.mPlayer.setIntOption(805, 3000);
                this.mPlayer.setIntOption(813, this.mRtcFallbackThreshold);
                this.mPlayer.setIntOption(814, this.mRtcEnableDtls);
                this.mPlayer.setIntOption(815, this.mRtcMinJitterBuffer);
                this.mPlayer.setIntOption(881, this.mRtcMaxJitterBuffer);
                this.mPlayer.setIntOption(816, this.mRtcEarlyInitRender);
                this.mPlayer.setIntOption(882, this.mRtcEnableRtcUninitLockFree);
                if (!this.mLogService.mSessionId.equals("none")) {
                    this.mPlayer.setStringOption(811, this.mLogService.mSessionId);
                    this.mLogService.mRtcSessionId = this.mLogService.mSessionId;
                }
                if (this.mRtcEnableSDKDns == 1) {
                    JSONObject jSONObject = new JSONObject();
                    jSONObject.put("s_expect_ip", (Object)string3);
                    this.mLogService.mDnsIp = string3;
                    this.mPlayer.setStringOption(812, String.valueOf(jSONObject));
                }
                this.mLogService.mCodecName = "";
                this.mLogService.mCodecType = "";
                this.mLogService.mHardDecodeEnable = false;
                if (this.mRtcSupportMiniSdp == 1) {
                    if (string2 != null && string2.startsWith("http://")) {
                        String string9 = string2.replace("http://", "webrtc://");
                        this.mPlayer.setDataSource(this.mContext, Uri.parse((String)string9), null);
                        this.mLogService.mRequestUrl = string9;
                        this.mLogService.mEnableMiniSdp = 1;
                    }
                } else {
                    this.mPlayer.setDataSource(this.mContext, Uri.parse((String)string2), null);
                    this.mLogService.mRequestUrl = string2;
                    this.mLogService.mEnableMiniSdp = 0;
                }
                this.mLogService.mRequestHeaders = null;
            } else {
                this.mPlayer.setIntOption(800, 0);
                this.mPlayer.setDataSource(this.mContext, Uri.parse((String)string), hashMap);
                this.mLogService.mRequestUrl = string;
                this.mLogService.mRequestHeaders = hashMap;
            }
            if (this.mEnableRtcPlay == 1 && this.mRtcPlayFallBack == 1) {
                MyLog.i(TAG, "rtc fallback set hardware decode: " + this.mHardwareDecodeEnable);
                this.mPlayer.setIntOption(59, this.mHardwareDecodeEnable);
                this.mLogService.enableHardDecode(this.mHardwareDecodeEnable == 1);
                if (this.mHardwareDecodeEnable == 1) {
                    MyLog.i(TAG, "rtc fallback enable hardware decode, mDefaultCodecId: " + this.mDefaultCodecId + ", mEnableMediaCodecASYNCInit: " + this.mEnableMediaCodecASYNCInit);
                    if (this.mDefaultCodecId != -1) {
                        this.mPlayer.setIntOption(181, this.mEnableMediaCodecASYNCInit);
                        this.mPlayer.setIntOption(182, this.mDefaultCodecId);
                        this.mLogService.mMediaCodecAsyncInit = this.mEnableMediaCodecASYNCInit;
                        this.mLogService.mDefaultCodecID = this.mDefaultCodecId;
                    }
                }
            }
            if (this.mNetworkTimeout != -1 && this.mNetworkTimeout >= 1000) {
                this.mPlayer.setIntOption(9, this.mNetworkTimeout * 1000);
                MyLog.i(TAG, "networktimeout: " + this.mNetworkTimeout + " microsecond");
                this.mLogService.mNetworkTimeoutMs = this.mNetworkTimeout;
            } else if (this.mNetworkTimeout != -1) {
                MyLog.e(TAG, "networktimeout so small: " + this.mNetworkTimeout + " microsecond");
                this.mLogService.mNetworkTimeoutMs = 5000;
            }
        }
        catch (Exception exception) {
            object2 = new HashMap<String, String>();
            object2.put("url", string);
            LiveError liveError = new LiveError(-100002, exception.getMessage(), (Map<String, String>)object2);
            if (this.mIsLocalURL) {
                this.mListener.onError(liveError);
                return;
            }
            this.mRetryProcessor.onError(liveError, this.mShowedFirstFrame);
            return;
        }
        if (this.mSurfaceHolder != null) {
            VideoLiveManager videoLiveManager = this;
            videoLiveManager.setSurfaceHolder(videoLiveManager.mSurfaceHolder);
        } else if (this.mSurface != null) {
            VideoLiveManager videoLiveManager = this;
            videoLiveManager.setSurface(videoLiveManager.mSurface);
        }
        if (this.mPlayer != null) {
            this.mPlayer.setScreenOnWhilePlaying(true);
        }
        if (this.mPrepareState != PlayerState.INITIALIZED) {
            return;
        }
        try {
            this.mPlayer.prepareAsync();
            this.mPrepareState = PlayerState.PREPARING;
            return;
        }
        catch (Exception exception) {
            object = new HashMap<String, String>();
            object.put("url", string);
            LiveError liveError = new LiveError(-100001, exception.getMessage(), (Map<String, String>)object);
            if (this.mIsLocalURL) {
                this.mListener.onError(liveError);
                return;
            }
            this.mRetryProcessor.onError(liveError, this.mShowedFirstFrame);
            return;
        }
    }

    private boolean abrDegradeResolution() {
        int n2 = -1;
        for (int i2 = LiveConfigKey.resolution.length - 1; i2 >= 0; --i2) {
            if (!this.mURLSource.isSupportResolution(LiveConfigKey.resolution[i2])) continue;
            n2 = i2;
            break;
        }
        if (n2 == -1) {
            return false;
        }
        MyLog.i(TAG, "abrDegradeResolution, resolution: " + LiveConfigKey.resolution[n2] + ", auto defalut resolution: " + this.mURLSource.getDefaultResolution());
        if (this.mURLSource.getDefaultResolution().equals(LiveConfigKey.resolution[n2])) {
            return false;
        }
        String string = this.mURLSource.getPlayURLForResolution(LiveConfigKey.resolution[n2], this.mStreamFormat, "main");
        if (string == null) {
            return false;
        }
        String string2 = this.mCurrentPlayURL;
        this.mCurrentPlayURL = string;
        this.mResolutionIndex = n2;
        this.mURLSource.setDefaultResolution(LiveConfigKey.resolution[n2]);
        this.mLogService.mAutoUsingResolution = LiveConfigKey.resolution[n2];
        this.saveCurrentResolution();
        this.mLogService.onSwitch(string2, this.mCurrentPlayURL, "auto_" + this.mLogService.mLastResolution + "_to_" + this.mResolution, -100015);
        this.mLogService.onSwitchURL(this.mCurrentPlayURL);
        this.mLevel = "main";
        this.mStallCount = 0;
        this.parsePlayDNS(string);
        return true;
    }

    private boolean degradeResolution() {
        int n2;
        if (this.mResolution == "ld") {
            return false;
        }
        if (this.mResolutionIndex == -1) {
            for (n2 = 0; n2 < LiveConfigKey.resolution.length; ++n2) {
                if (!LiveConfigKey.resolution[n2].equals(this.mResolution)) continue;
                this.mResolutionIndex = n2;
                break;
            }
        }
        for (n2 = this.mResolutionIndex + 1; n2 < LiveConfigKey.resolution.length && !this.mURLSource.isSupportResolution(LiveConfigKey.resolution[n2]); ++n2) {
        }
        if (n2 >= LiveConfigKey.resolution.length) {
            return false;
        }
        String string = this.mURLSource.getPlayURLForResolution(LiveConfigKey.resolution[n2], this.mStreamFormat, this.mLevel);
        if (string == null) {
            return false;
        }
        String string2 = this.mCurrentPlayURL;
        this.mCurrentPlayURL = string;
        this.mResolutionIndex = n2;
        this.saveCurrentResolution();
        this.mLogService.mResolution = this.mResolution = LiveConfigKey.resolution[n2];
        this.mLogService.onSwitch(string2, this.mCurrentPlayURL, "auto_" + this.mLogService.mLastResolution + "_to_" + this.mResolution, -100015);
        if (this.mListener != null) {
            this.mListener.onResolutionDegrade(this.mResolution);
        }
        this.mLogService.onSwitchURL(this.mCurrentPlayURL);
        this.mStallCount = 0;
        this.parsePlayDNS(string);
        return true;
    }

    private boolean switchMainAndBackupUrl(int n2) {
        String string;
        if (this.mLevel.equals("main")) {
            String string2 = this.mURLSource.getPlayURLForResolution(this.mResolution.equals("auto") ? this.mURLSource.getDefaultResolution() : this.mResolution, "flv", "backup");
            if (string2 != null) {
                this.updateDownloadSizeStat();
                this.mLogService.onSessionStop();
                this.mIsRetrying = true;
                this.mLogService.onSwitch(this.mCurrentPlayURL, string2, "main_to_backup", n2);
                this.mLogService.onSwitchURL(string2);
                this.mCurrentPlayURL = string2;
                this.mLevel = "backup";
                this._setStreamFormat();
                this.mRetryProcessor.reset();
                this._resetPlayer();
                this.mSessionStartTime = System.currentTimeMillis();
                this.mRedoDns = true;
                this.parsePlayDNS(string2);
                this.mStallCount = 0;
                return true;
            }
        } else if (this.mLevel.equals("backup") && (string = this.mURLSource.getPlayURLForResolution(this.mResolution.equals("auto") ? this.mURLSource.getDefaultResolution() : this.mResolution, "flv", "main")) != null) {
            this.updateDownloadSizeStat();
            this.mLogService.onSessionStop();
            this.mIsRetrying = true;
            this.mLogService.onSwitch(this.mCurrentPlayURL, string, "backup_to_main", n2);
            this.mLogService.onSwitchURL(string);
            this.mCurrentPlayURL = string;
            this.mLevel = "main";
            this._setStreamFormat();
            this.mRetryProcessor.reset();
            this._resetPlayer();
            this.mSessionStartTime = System.currentTimeMillis();
            this.mRedoDns = true;
            this.parsePlayDNS(string);
            this.mStallCount = 0;
            return true;
        }
        return false;
    }

    private boolean bytevc1DegradeH264(int n2) {
        if (this.mURLAbility != 2) {
            return false;
        }
        String string = this.mURLSource.getPlayURLByCodec((String)"h264").mainURL;
        if (string != null) {
            this.updateDownloadSizeStat();
            this.mLogService.onSessionStop();
            this.mIsRetrying = true;
            this.mLogService.onSwitchURL(string);
            this.mLogService.onSwitch(this.mCurrentPlayURL, string, "bytevc1_to_h264", n2);
            this.mCurrentPlayURL = string;
            this.mURLAbility = 1;
            this.mLogService.mUrlAbility = "h264";
            if (this.mHardwareDecodeEnable != 1 && this.mEnableH264HardwareDecode == 1) {
                this.mHardwareDecodeEnable = 1;
                this.mDefaultCodecId = 0;
                this.mPlayer.setIntOption(59, this.mHardwareDecodeEnable);
                this.mLogService.enableHardDecode(this.mHardwareDecodeEnable == 1);
            }
            this._resetPlayer();
            this.mSessionStartTime = System.currentTimeMillis();
            this.parsePlayDNS(string);
            return true;
        }
        return false;
    }

    private boolean QuicDegrade(int n2) {
        if (this.mCurrentPlayURL == null) {
            return false;
        }
        if (TextUtils.equals((CharSequence)this.mTransportProtocol, (CharSequence)"quic") || TextUtils.equals((CharSequence)this.mTransportProtocol, (CharSequence)"quicu")) {
            switch (n2) {
                case -499499: {
                    String string;
                    if (this.mURLProtocol.equals("tls")) {
                        this.mTransportProtocol = "tls";
                        string = this.mCurrentPlayURL.replaceAll("httpq", "https");
                    } else if (this.mURLProtocol.equals("kcp")) {
                        this.mTransportProtocol = "kcp";
                        string = this.mCurrentPlayURL.replaceAll("httpq", "httpk");
                    } else {
                        this.mTransportProtocol = "tcp";
                        string = this.mCurrentPlayURL.replaceAll("httpq", "http");
                    }
                    string = string.replaceAll(":(\\d+)/", "/");
                    this.updateDownloadSizeStat();
                    this.mLogService.onSessionStop();
                    this.mIsRetrying = true;
                    if (string != null) {
                        this.mLogService.onSwitchURL(string);
                        this.mLogService.onSwitch(this.mCurrentPlayURL, string, "quic_library_load_error", n2);
                        this.mCurrentPlayURL = string;
                        this._stopPlayer();
                        this._resetPlayer();
                        this.mSessionStartTime = System.currentTimeMillis();
                        VideoLiveManager videoLiveManager = this;
                        videoLiveManager.parsePlayDNS(videoLiveManager.mCurrentPlayURL);
                    }
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private boolean HttpKDegradeHttp(int n2) {
        String string;
        if (this.mCurrentPlayURL == null) {
            return false;
        }
        if (this.mCurrentPlayURL.startsWith("httpk") && (string = this.mCurrentPlayURL.replaceAll("httpk", "http").replaceAll(":(\\d+)/", "/")) != null) {
            this.updateDownloadSizeStat();
            this.mLogService.onSessionStop();
            this.mIsRetrying = true;
            this.mLogService.onSwitchURL(string);
            this.mLogService.onSwitch(this.mCurrentPlayURL, string, "httpk_to_http", n2);
            this.mCurrentPlayURL = string;
            this._stopPlayer();
            this._resetPlayer();
            this.mSessionStartTime = System.currentTimeMillis();
            VideoLiveManager videoLiveManager = this;
            videoLiveManager.parsePlayDNS(videoLiveManager.mCurrentPlayURL);
            return true;
        }
        return false;
    }

    private void checkMainLooper(String string) {
        if (this.mIsInMainLooper == 1 && Looper.myLooper() != Looper.getMainLooper() && this.mLogService != null) {
            this.mLogService.onCallNotInMainThread(string);
        }
    }

    private String convertCodecName(int n2) {
        switch (n2) {
            case 1: {
                return "IOSHWCodec";
            }
            case 2: {
                return "hardware_codec";
            }
            case 3: {
                return "ff_H264_codec";
            }
            case 4: {
                return "ff_ByteVC1_codec";
            }
            case 5: {
                return "KS_ByteVC1_codec";
            }
            case 6: {
                return "JX_ByteVC1_codec";
            }
        }
        return "none_codec";
    }

    private String _addParamToURL(String string, String string2, String string3) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        string2 = string2 + "=" + string3;
        int n2 = string.indexOf("?");
        if (n2 == -1) {
            string2 = "?" + string2;
        } else if (n2 != string.length() - 1) {
            string2 = "&" + string2;
        }
        return string + string2;
    }

    private String addSessionIdToURL(String string, long l2) {
        String string2;
        if (TextUtils.isEmpty((CharSequence)string) || TextUtils.isEmpty((CharSequence)this.mUuid)) {
            return null;
        }
        String string3 = "_session_id";
        this.mLogService.mSessionId = string2 = this.mUuid + "." + l2;
        if (!string.contains(string3)) {
            string = this._addParamToURL(string, string3, string2);
        }
        return string;
    }

    public void onRenderStallForRetryStop() {
        if ((this.mIsStalling || this.mIsRetrying) && this.mEnableRenderStall == 1) {
            int n2;
            if (this.mAudioLastRenderTime != -1L) {
                n2 = (int)(System.currentTimeMillis() - this.mAudioLastRenderTime);
                this.mLogService.onRenderStall(n2, 0, false, false);
            }
            if (this.mVideoLastRenderTime != -1L) {
                n2 = (int)(System.currentTimeMillis() - this.mVideoLastRenderTime);
                this.mLogService.onRenderStall(n2, 0, true, false);
            }
        }
    }

    public void getLastRenderTime() {
        if (this.mIsRetrying || this.mIsStalling) {
            return;
        }
        this.mVideoLastRenderTime = this.mPlayer.getLongOption(320, -1L);
        this.mAudioLastRenderTime = this.mPlayer.getLongOption(319, -1L);
    }

    public void setupTextureRender() {
    }

    public void setTextureRenderLogListener() {
    }

    public boolean isUsedSR() {
        return false;
    }

    public boolean isUsedSharpen() {
        return false;
    }

    public void releaseTextureRenderRef() {
    }

    public boolean disableSR(int n2, int n3) {
        ArrayList arrayList = new ArrayList();
        if (this.mSettingsBundle != null) {
            arrayList = this.mSettingsBundle.getSettingsValueForKey("live_sdk_sr_resolution_block_list", new ArrayList());
        }
        if (!arrayList.isEmpty()) {
            arrayList = arrayList.iterator();
            while (arrayList.hasNext()) {
                String[] stringArray = ((String)arrayList.next()).split("x");
                if (stringArray.length < 2) {
                    return false;
                }
                int n4 = Integer.parseInt(stringArray[0]);
                int n5 = Integer.parseInt(stringArray[1]);
                if (n2 != n4 || n3 != n5) continue;
                return true;
            }
        }
        return false;
    }

    private void updateDownloadSizeStat() {
        long l2 = this.mPlayer.getLongOption(45, 0L);
        this.mLogService.mLastTotalDownloadSize += l2;
        long l3 = this.mLogService.mLastDownloadSizeDelta;
        if (!this.mLogService.mHaveResetPlayer) {
            this.mLogService.mLastDownloadSizeDelta = l2 - this.mLogService.getPlayingDownloadSize();
            this.mLogService.mHaveResetPlayer = true;
            return;
        }
        this.mLogService.mLastDownloadSizeDelta = l2 + l3;
    }

    private void saveCurrentResolution() {
        if (this.mLivePlayerState == LivePlayerState.IDLE) {
            return;
        }
        if (this.mLogService == null) {
            return;
        }
        this.mLogService.mLastResolution = this.mResolution.equals("auto") ? this.mLogService.mAutoUsingResolution : this.mResolution;
    }

    public static Builder newBuilder(Context context) {
        return new Builder(context);
    }

    public static void setSettingsParam(Context object, Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        object = (HashMap)map;
        ((HashMap)object).put("live_pull_sdk_version", LiveUtils.versionStringToInt("1.4.6.31-lite"));
        ((HashMap)object).put("ttm_version", LiveUtils.versionStringToInt(TTPlayerConfiger.getValue(14, "")));
    }

    public static void setAppInfo(Context object, Map map) {
        if (map == null || map.size() == 0) {
            return;
        }
        AppInfo.mContext = object;
        AppInfo.mAppName = (String)map.get("app_name");
        object = map.get("app_id");
        MyLog.i(TAG, "set appid:" + (Integer)object);
        if (object != null) {
            AppInfo.mAppID = (Integer)object;
            MyLog.i(TAG, "set appid:" + AppInfo.mAppID);
        }
        AppInfo.mAppChannel = (String)map.get("app_channel");
        AppInfo.mAppVersion = (String)map.get("app_version");
        AppInfo.mDeviceId = (String)map.get("device_id");
    }

    public static void setDataLoaderListener(MediaLoaderListener mediaLoaderListener) {
        MediaLoaderWrapper.getDataLoader().setListener(mediaLoaderListener);
    }

    public static void startDataLoader(Context context) throws Exception {
        MediaLoaderWrapper.getDataLoader().start();
        return;
    }

    public static boolean dataLoaderIsRunning() {
        return MediaLoaderWrapper.getDataLoader().isRunning();
    }

    public static void closeDataLoader() {
        MediaLoaderWrapper.getDataLoader().close();
    }

    public static void setIntValue(int n2, int n3) {
        MediaLoaderWrapper.getDataLoader().setIntValue(n2, n3);
    }

    public static void enableLoadLibrary() {
        MediaLoaderWrapper.getDataLoader().enableLoadLibrary();
    }

    public void updateFrameTerminatedDTS(int n2, long l2, long l3) {
        this.mFrameTerminatedDTS = l2;
    }

    public void frameDTSNotify(int n2, long l2, long l3) {
        if (this.mEnableCheckFrame == 1 && n2 == 0 && this.mResolution.equals("origin")) {
            this.mLogService.feedVideoDTS(l2);
        }
        if (n2 == 1 && this.mEnableDTSCheck == 1) {
            if (this.mLogService.mFirstAudioPacketDTS < 0L) {
                this.mLogService.mFirstAudioPacketDTS = l2;
            } else if (l2 < this.mLatestAudioPacketDTS) {
                this.mLogService.onAudioDTSRollback(this.mLatestAudioPacketDTS, l2);
            }
            this.mLatestAudioPacketDTS = l2;
        }
    }

    public JSONObject liveInfoItems() {
        JSONObject jSONObject;
        try {
            jSONObject = this.mLogService.getLiveInfoItems();
            jSONObject.put("get_live_info_iterms", (Object)"OK");
        }
        catch (JSONException jSONException) {
            q.d(jSONException);
            return null;
        }
        return jSONObject;
    }

    public boolean isRtcPlayAvailable() {
        return this.mEnableRtcPlay == 1 && this.mRtcPlayFallBack == 0;
    }

    private class VideoStallCountTask
    implements Runnable {
        private VideoStallCountTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = VideoLiveManager.this.mStallCounterLock;
            synchronized (object) {
                if (!VideoLiveManager.this.mStallCounterIsRunning || VideoLiveManager.this.mPlayer == null) {
                    return;
                }
                long l2 = SystemClock.uptimeMillis() + (long)VideoLiveManager.this.mStallCounterInterval;
                long l3 = VideoLiveManager.this.mPlayer.getLongOption(381, 0L);
                long l4 = VideoLiveManager.this.mPlayer.getLongOption(382, 0L);
                long l5 = VideoLiveManager.this.mPlayer.getLongOption(383, 0L);
                long l6 = VideoLiveManager.this.mPlayer.getLongOption(384, 0L);
                long l7 = VideoLiveManager.this.mPlayer.getLongOption(385, 0L);
                long l8 = VideoLiveManager.this.mPlayer.getLongOption(386, 0L);
                long l9 = VideoLiveManager.this.mPlayer.getLongOption(387, 0L);
                if ((l3 != 0L || l4 != 0L || l5 != 0L || l6 != 0L || l7 != 0L || l8 != 0L || l9 != 0L) && VideoLiveManager.this.mLogService != null) {
                    VideoLiveManager.this.mLogService.onVideoStallCounter(l3, l4, l5, l6, l7, l8, l9);
                }
                if (VideoLiveManager.this.mStallCounterHandler != null) {
                    VideoLiveManager.this.mStallCounterHandler.postAtTime((Runnable)this, l2);
                }
                return;
            }
        }
    }

    private static class MyReleaseRunnable
    implements Runnable {
        private MediaPlayer mPlayer;

        public MyReleaseRunnable(MediaPlayer mediaPlayer) {
            this.mPlayer = mediaPlayer;
        }

        @Override
        public void run() {
            if (this.mPlayer != null) {
                try {
                    MyLog.i(VideoLiveManager.TAG, "MyReleaseRunnable release");
                    this.mPlayer.release();
                    this.mPlayer = null;
                    return;
                }
                catch (Exception exception) {
                    MyLog.i(VideoLiveManager.TAG, exception.toString());
                }
            }
        }
    }

    @Keep
    public static final class Builder {
        final Context mContext;
        ILiveListener mListener;
        String mProjectKey;
        INetworkClient mNetworkClient;
        ILiveSettingBundle mSettingsBundle;
        boolean mForceHttpDns = false;
        boolean mForceTTNetHttpDns = false;
        int mRetryTimeout = 60000;
        int mPlayerType = 1;
        String mResolution = "origin";
        String mVideoFormat = "flv";
        boolean mEnableResolutionAutoDegrade = false;
        boolean mEnableSwitchMainAndBackupUrl = true;
        public long mStallRetryTimeInterval = 10000L;
        public long mUploadLogInterval = 60000L;
        public long mRTCUploadLogInterval = 5000L;
        public long mSeiCheckTimeOut = 8000L;
        public ExecutorService mLiveThreadPool = null;

        private Builder(Context context) {
            this.mContext = context;
        }

        public Builder setListener(ILiveListener iLiveListener) {
            this.mListener = iLiveListener;
            return this;
        }

        public Builder setPlayerType(int n2) {
            this.mPlayerType = n2;
            return this;
        }

        public Builder setProjectKey(String string) {
            this.mProjectKey = string;
            return this;
        }

        public Builder setNetworkClient(INetworkClient iNetworkClient) {
            this.mNetworkClient = iNetworkClient;
            return this;
        }

        public Builder setForceHttpDns(boolean bl) {
            this.mForceHttpDns = bl;
            return this;
        }

        public Builder setForceTTNetHttpDns(boolean bl) {
            this.mForceTTNetHttpDns = bl;
            return this;
        }

        public Builder setRetryTimeout(int n2) {
            this.mRetryTimeout = n2;
            return this;
        }

        public Builder setStallRetryInterval(long l2) {
            this.mStallRetryTimeInterval = l2;
            return this;
        }

        public Builder setResolution(String string) {
            this.mResolution = string;
            return this;
        }

        public Builder setVideoFormat(String string) {
            this.mVideoFormat = string;
            return this;
        }

        public Builder setEnableResolutionAutoDegrade(boolean bl) {
            this.mEnableResolutionAutoDegrade = bl;
            return this;
        }

        public Builder setEnableSwitchMainAndBackUpURL(boolean bl) {
            this.mEnableSwitchMainAndBackupUrl = bl;
            return this;
        }

        public Builder setSeiCheckTimeOut(long l2) {
            this.mSeiCheckTimeOut = l2;
            return this;
        }

        public Builder setSettingsBundle(ILiveSettingBundle iLiveSettingBundle) {
            this.mSettingsBundle = iLiveSettingBundle;
            return this;
        }

        public Builder setCustomThreadPool(ExecutorService executorService) {
            MyLog.i(VideoLiveManager.TAG, "setCustomThreadPool: ".concat(String.valueOf(executorService)));
            this.mLiveThreadPool = executorService;
            return this;
        }

        public VideoLiveManager build() {
            if (this.mContext == null) {
                throw new IllegalArgumentException("mContext should not be null");
            }
            if (this.mListener == null) {
                throw new IllegalArgumentException("mListener should not be null");
            }
            if (this.mNetworkClient == null) {
                throw new IllegalArgumentException("mNetworkClient should not be null");
            }
            return new VideoLiveManager(this);
        }
    }

    private class PlayCacheSyncRunner
    implements Runnable {
        private final WeakReference<VideoLiveManager> mVideoLiveManagerRef;
        String mMdlTaskSessionId;
        boolean mIsLiveIO = false;
        static final long LongDelay = 500L;
        static final long ShortDelay = 300L;
        static final long CacheThreadshold = 5000L;

        public PlayCacheSyncRunner(VideoLiveManager videoLiveManager2, String string, boolean bl) {
            this.mVideoLiveManagerRef = new WeakReference<VideoLiveManager>(videoLiveManager2);
            this.mMdlTaskSessionId = string;
            this.mIsLiveIO = bl;
        }

        @Override
        public void run() {
            VideoLiveManager videoLiveManager = (VideoLiveManager)this.mVideoLiveManagerRef.get();
            if (videoLiveManager == null || this.mMdlTaskSessionId == null || !this.mMdlTaskSessionId.equals(videoLiveManager.mSessionId) || this.mMdlTaskSessionId.isEmpty()) {
                return;
            }
            if (videoLiveManager.mLivePlayerState != LivePlayerState.PLAYED) {
                this.nextround(500L);
                return;
            }
            long l2 = this.getPlayCache();
            if (l2 == -1L) {
                this.nextround(500L);
                return;
            }
            if (!this.mIsLiveIO) {
                MediaLoaderWrapper.getDataLoader().setInt64ValueByStrKey(7215, videoLiveManager.mSessionId, (int)l2);
            }
            videoLiveManager.mSessionId;
            if (l2 > 5000L) {
                this.nextround(500L);
                return;
            }
            this.nextround(300L);
        }

        private long getPlayCache() {
            VideoLiveManager videoLiveManager = (VideoLiveManager)this.mVideoLiveManagerRef.get();
            if (videoLiveManager == null) {
                return -1L;
            }
            long l2 = videoLiveManager.mPlayer.getLongOption(73, -1L);
            long l3 = videoLiveManager.mPlayer.getLongOption(72, -1L);
            if (l2 >= 0L && l3 >= 0L) {
                return Math.min(l2, l3);
            }
            if (l2 >= 0L) {
                return l2;
            }
            if (l3 >= 0L) {
                return l3;
            }
            return -1L;
        }

        private void nextround(long l2) {
            VideoLiveManager videoLiveManager = (VideoLiveManager)this.mVideoLiveManagerRef.get();
            if (videoLiveManager == null) {
                return;
            }
            videoLiveManager.runOnCurrentThreadDelay(new PlayCacheSyncRunner(videoLiveManager, this.mMdlTaskSessionId, this.mIsLiveIO), l2);
        }
    }

    private static final class MyFetcherCompletionListener
    implements LiveDataFetcher.OnCompletionListener {
        private final WeakReference<VideoLiveManager> mVideoLiveManagerRef;
        private final String mLiveInfoAPI;

        public MyFetcherCompletionListener(VideoLiveManager videoLiveManager, String string) {
            this.mVideoLiveManagerRef = new WeakReference<VideoLiveManager>(videoLiveManager);
            this.mLiveInfoAPI = string;
        }

        @Override
        public void onCompletion(final LiveStreamInfo liveStreamInfo) {
            final VideoLiveManager videoLiveManager = (VideoLiveManager)this.mVideoLiveManagerRef.get();
            if (videoLiveManager == null) {
                return;
            }
            videoLiveManager.runOnCurrentThread(new Runnable(){

                @Override
                public void run() {
                    if (videoLiveManager.mPlayer == null || videoLiveManager.mRetryProcessor == null) {
                        return;
                    }
                    if (liveStreamInfo == null) {
                        Serializable serializable = new HashMap<String, String>();
                        serializable.put("liveAPI", MyFetcherCompletionListener.this.mLiveInfoAPI);
                        serializable = new LiveError(-100005, "live data is null", (Map<String, String>)((Object)serializable));
                        videoLiveManager.mRetryProcessor.onError((LiveError)serializable, videoLiveManager.mShowedFirstFrame);
                        return;
                    }
                    videoLiveManager.mURLSource.setStreamInfo(liveStreamInfo);
                    Object object = videoLiveManager.mResolution.equals("auto") ? videoLiveManager.mURLSource.getDefaultResolution() : videoLiveManager.mResolution;
                    object = videoLiveManager.mURLSource.getPlayURLForResolution((String)object, videoLiveManager.mStreamFormat, videoLiveManager.mLevel);
                    if (object == null) {
                        object = new HashMap<String, String>();
                        object.put("liveAPI", MyFetcherCompletionListener.this.mLiveInfoAPI);
                        object = new LiveError(-100005, "play url is null", (Map<String, String>)object);
                        videoLiveManager.mRetryProcessor.onError((LiveError)object, videoLiveManager.mShowedFirstFrame);
                        return;
                    }
                    videoLiveManager.parsePlayDNS((String)object);
                }
            });
        }

        @Override
        public void onError(final LiveError liveError) {
            final VideoLiveManager videoLiveManager = (VideoLiveManager)this.mVideoLiveManagerRef.get();
            if (videoLiveManager == null) {
                return;
            }
            videoLiveManager.runOnCurrentThread(new Runnable(){

                @Override
                public void run() {
                    if (videoLiveManager.mPlayer == null || videoLiveManager.mRetryProcessor == null) {
                        return;
                    }
                    videoLiveManager.mRetryProcessor.onError(liveError, videoLiveManager.mShowedFirstFrame);
                }
            });
        }
    }

    private static final class MyMediaLoaderListener
    implements MediaLoaderListener {
        private final WeakReference<VideoLiveManager> mVideoLiveManagerRef;

        public MyMediaLoaderListener(VideoLiveManager videoLiveManager) {
            this.mVideoLiveManagerRef = new WeakReference<VideoLiveManager>(videoLiveManager);
        }

        @Override
        public void onDataLoaderError(int n2, String string) {
            VideoLiveManager videoLiveManager = (VideoLiveManager)this.mVideoLiveManagerRef.get();
            if (videoLiveManager == null || videoLiveManager.mPlayer == null) {
                return;
            }
            videoLiveManager.mLogService.onLoaderError(n2, string);
        }

        @Override
        public void onNotify(int n2, long l2, long l3, String string) {
        }

        @Override
        public void onLogInfo(int n2, String string, JSONObject jSONObject) {
        }

        @Override
        public void onSwitchLoaderType(int n2, String string) {
            VideoLiveManager videoLiveManager = (VideoLiveManager)this.mVideoLiveManagerRef.get();
            if (videoLiveManager == null || videoLiveManager.mPlayer == null) {
                return;
            }
            videoLiveManager.mLogService.onLoaderSwitch(n2, string);
        }

        @Override
        public long getInt64Value(int n2, long l2) {
            VideoLiveManager videoLiveManager = (VideoLiveManager)this.mVideoLiveManagerRef.get();
            if (videoLiveManager == null || videoLiveManager.mPlayer == null) {
                return l2;
            }
            switch (n2) {
                case 0: {
                    return videoLiveManager.mLogService.getInt64Value(n2, l2);
                }
            }
            return l2;
        }
    }

    private static final class MyRetryListener
    implements RetryProcessor.RetryListener {
        private final WeakReference<VideoLiveManager> mVideoLiveManagerRef;

        public MyRetryListener(VideoLiveManager videoLiveManager) {
            this.mVideoLiveManagerRef = new WeakReference<VideoLiveManager>(videoLiveManager);
        }

        @Override
        public void onRetryResetPlayer(boolean bl) {
            VideoLiveManager videoLiveManager = (VideoLiveManager)this.mVideoLiveManagerRef.get();
            if (videoLiveManager == null || videoLiveManager.mPlayer == null) {
                return;
            }
            videoLiveManager.updateDownloadSizeStat();
            videoLiveManager.mLogService.onSessionStop();
            videoLiveManager.getLastRenderTime();
            videoLiveManager.mIsRetrying = true;
            MyLog.i(VideoLiveManager.TAG, "onRetryResetPlayer ".concat(String.valueOf(bl)));
            if (!videoLiveManager.mHasRetry) {
                videoLiveManager.mHasRetry = true;
                videoLiveManager.mLogService.setWaitTime(videoLiveManager.mPlayer.getLongOption(314, 0L));
            }
            videoLiveManager._stopPlayer();
            String string = null;
            if (videoLiveManager.mURLSource.getSourceType() == 1) {
                string = videoLiveManager.mURLSource.getPlayLiveURL() != null ? ((VideoLiveManager)videoLiveManager).mURLSource.getPlayLiveURL().mainURL : null;
            } else if (videoLiveManager.mURLSource.getSourceType() == 2) {
                String string2 = videoLiveManager.mResolution.equals("auto") ? videoLiveManager.mURLSource.getDefaultResolution() : videoLiveManager.mResolution;
                string = videoLiveManager.mURLSource.getPlayURLForResolution(string2, videoLiveManager.mStreamFormat, videoLiveManager.mLevel);
            }
            MyLog.i(VideoLiveManager.TAG, "retry url: ".concat(String.valueOf(string)));
            videoLiveManager.mLogService.onSwitchURL(string);
            boolean bl2 = false;
            if (videoLiveManager.mURLSource.getSourceType() == 2 && videoLiveManager.mAbrStrategy.equals("abr_bb_4live") && videoLiveManager.mResolution.equals("auto")) {
                bl2 = true;
            }
            videoLiveManager.mRetryStartTime = System.currentTimeMillis();
            ((VideoLiveManager)videoLiveManager).mLogService.mSessionStartTime = System.currentTimeMillis();
            if (videoLiveManager.mPrepareState == PlayerState.PREPARED) {
                if (videoLiveManager.mEnableAbrStallDegradeImmediately == 1 || !bl2 || bl2 && !videoLiveManager.abrDegradeResolution()) {
                    videoLiveManager.parsePlayDNS(string);
                    return;
                }
            } else {
                videoLiveManager._resetPlayer();
                if (videoLiveManager.mEnableAbrStallDegradeImmediately == 1 || !bl2 || bl2 && !videoLiveManager.abrDegradeResolution()) {
                    videoLiveManager.parsePlayDNS(string);
                }
            }
        }

        @Override
        public void onRetryNextPlayURL() {
            VideoLiveManager videoLiveManager = (VideoLiveManager)this.mVideoLiveManagerRef.get();
            if (videoLiveManager == null || videoLiveManager.mPlayer == null) {
                return;
            }
            MyLog.i(VideoLiveManager.TAG, "onRetryNextPlayURL");
            videoLiveManager.updateDownloadSizeStat();
            videoLiveManager.mLogService.onSessionStop();
            videoLiveManager.mIsRetrying = true;
            String string = null;
            if (videoLiveManager.mURLSource.getSourceType() == 1) {
                string = videoLiveManager.mURLSource.getNextURL();
            } else if (videoLiveManager.mURLSource.getSourceType() == 2) {
                string = videoLiveManager.mResolution.equals("auto") ? videoLiveManager.mURLSource.getDefaultResolution() : videoLiveManager.mResolution;
                string = videoLiveManager.mURLSource.getPlayURLForResolution(string, videoLiveManager.mStreamFormat, videoLiveManager.mLevel);
            }
            videoLiveManager.mLogService.onSwitchURL(string);
            if (!videoLiveManager.mHasRetry) {
                videoLiveManager.mHasRetry = true;
                videoLiveManager.mLogService.setWaitTime(videoLiveManager.mPlayer.getLongOption(314, 0L));
            }
            videoLiveManager._stopPlayer();
            ((VideoLiveManager)videoLiveManager).mLogService.mSessionStartTime = System.currentTimeMillis();
            if (videoLiveManager.mPrepareState == PlayerState.PREPARED) {
                videoLiveManager.parsePlayDNS(string);
                return;
            }
            videoLiveManager._resetPlayer();
            videoLiveManager.parsePlayDNS(string);
        }

        @Override
        public void onReportOutToApplication(LiveError liveError) {
            VideoLiveManager videoLiveManager = (VideoLiveManager)this.mVideoLiveManagerRef.get();
            if (videoLiveManager == null || videoLiveManager.mPlayer == null) {
                return;
            }
            MyLog.i(VideoLiveManager.TAG, "onReportOutToApplication");
            videoLiveManager.mListener.onError(liveError);
            videoLiveManager.mFetcher.cancel();
            videoLiveManager.mRetryProcessor.reset();
        }

        @Override
        public void onRTCFallBack() {
            VideoLiveManager videoLiveManager = (VideoLiveManager)this.mVideoLiveManagerRef.get();
            if (videoLiveManager == null || videoLiveManager.mPlayer == null) {
                return;
            }
            videoLiveManager.mIsRetrying = true;
            MyLog.i(VideoLiveManager.TAG, "onRTCFallBack");
            videoLiveManager._stopPlayer();
            if (videoLiveManager.mCurrentRetryCount < videoLiveManager.mRtcMaxRetryCount) {
                VideoLiveManager videoLiveManager2 = videoLiveManager;
                videoLiveManager2.mCurrentRetryCount = videoLiveManager2.mCurrentRetryCount + 1;
            } else {
                videoLiveManager.mRtcPlayFallBack = 1;
                ((VideoLiveManager)videoLiveManager).mLogService.mRtcPlayFallBack = 1;
                videoLiveManager.mURLSource.setRtcFallback(1);
                if (!videoLiveManager.mShowedFirstFrame) {
                    if (videoLiveManager.mRtcSupportMiniSdp == 1) {
                        videoLiveManager.mRtcSupportMiniSdp = 0;
                        ((VideoLiveManager)videoLiveManager).mLogService.mEnableMiniSdp = 0;
                    }
                    ((VideoLiveManager)videoLiveManager).mLogService.mFallbackType = 1;
                } else {
                    ((VideoLiveManager)videoLiveManager).mLogService.mFallbackType = 2;
                }
            }
            String string = null;
            if (videoLiveManager.mURLSource.getSourceType() == 1) {
                string = videoLiveManager.mURLSource.getNextURL();
            } else if (videoLiveManager.mURLSource.getSourceType() == 2) {
                string = videoLiveManager.mResolution.equals("auto") ? videoLiveManager.mURLSource.getDefaultResolution() : videoLiveManager.mResolution;
                string = videoLiveManager.mURLSource.getPlayURLForResolution(string, videoLiveManager.mStreamFormat, videoLiveManager.mLevel);
            }
            MyLog.i(VideoLiveManager.TAG, "onRTCFallBack url: " + string + ",mCurrentRetryCount:" + videoLiveManager.mCurrentRetryCount);
            videoLiveManager.mLogService.onSwitchURL(string);
            if (videoLiveManager.mPrepareState == PlayerState.PREPARED) {
                videoLiveManager.parsePlayDNS(string);
                return;
            }
            videoLiveManager._resetPlayer();
            videoLiveManager.parsePlayDNS(string);
        }
    }

    private static class MyOnVideoSizeChangedListener
    implements MediaPlayer.OnVideoSizeChangedListener {
        private final WeakReference<VideoLiveManager> mVideoLiveManagerRef;

        public MyOnVideoSizeChangedListener(VideoLiveManager videoLiveManager) {
            this.mVideoLiveManagerRef = new WeakReference<VideoLiveManager>(videoLiveManager);
        }

        @Override
        public void onVideoSizeChanged(MediaPlayer object, int n2, int n3) {
            MyLog.i(VideoLiveManager.TAG, "onVideoSizeChanged, width: " + n2 + ", height: " + n3);
            object = (VideoLiveManager)this.mVideoLiveManagerRef.get();
            if (object == null || ((VideoLiveManager)object).mPlayer == null) {
                return;
            }
            if (((VideoLiveManager)object).mListener != null) {
                ((VideoLiveManager)object).mListener.onVideoSizeChanged(n2, n3);
                ((VideoLiveManager)object).mLogService.onVideoSizeChanged(n2, n3);
            }
        }
    }

    private static final class MyCompletionListener
    implements MediaPlayer.OnCompletionListener {
        private final WeakReference<VideoLiveManager> mVideoLiveManagerRef;

        public MyCompletionListener(VideoLiveManager videoLiveManager) {
            this.mVideoLiveManagerRef = new WeakReference<VideoLiveManager>(videoLiveManager);
        }

        @Override
        public void onCompletion(MediaPlayer object) {
            object = (VideoLiveManager)this.mVideoLiveManagerRef.get();
            if (object == null || ((VideoLiveManager)object).mPlayer == null) {
                return;
            }
            MyLog.i(VideoLiveManager.TAG, "onCompletion");
            ((VideoLiveManager)object).mListener.onCompletion();
            ((VideoLiveManager)object).mLogService.onPrepare(-100009);
            ((VideoLiveManager)object).mSupportBackupIp = false;
            if (((VideoLiveManager)object).mIsLocalURL) {
                return;
            }
            if (((VideoLiveManager)object).mEnableSwitchMainAndBackupUrl && ((VideoLiveManager)object).mURLSource.getSourceType() == 2 && ((VideoLiveManager)object).switchMainAndBackupUrl(-100009)) {
                return;
            }
            if (((VideoLiveManager)object).mURLSource.getSourceType() == 1 && ((VideoLiveManager)object).bytevc1DegradeH264(-100009)) {
                return;
            }
            if (((VideoLiveManager)object).mCacheFileEnable == 1) {
                ((VideoLiveManager)object).mListener.onCacheFileCompletion();
                ((VideoLiveManager)object).mIsCacheHasComplete = true;
                if (((VideoLiveManager)object).mLooping && !TextUtils.isEmpty((CharSequence)((VideoLiveManager)object).mCacheFilePath)) {
                    Object object2 = object;
                    ((VideoLiveManager)object2).setLocalURL(((VideoLiveManager)object2).mCacheFilePath);
                    ((VideoLiveManager)object).setLooping(true);
                    Object object3 = object;
                    ((VideoLiveManager)object3).parsePlayDNS(((VideoLiveManager)object3).mCacheFilePath);
                    return;
                }
                return;
            }
            Serializable serializable = new HashMap<String, String>();
            serializable = new LiveError(-100009, "live stream dry up, push stream may occur error", (Map<String, String>)((Object)serializable));
            ((VideoLiveManager)object).mRetryProcessor.onError((LiveError)serializable, ((VideoLiveManager)object).mShowedFirstFrame);
        }
    }

    private static final class MyInfoListener
    implements MediaPlayer.OnInfoListener {
        private final WeakReference<VideoLiveManager> mVideoLiveManagerRef;

        public MyInfoListener(VideoLiveManager videoLiveManager) {
            this.mVideoLiveManagerRef = new WeakReference<VideoLiveManager>(videoLiveManager);
        }

        @Override
        public boolean onInfo(MediaPlayer object, int n2, int n3) {
            object = (VideoLiveManager)this.mVideoLiveManagerRef.get();
            if (object == null || ((VideoLiveManager)object).mPlayer == null) {
                return false;
            }
            switch (n2) {
                case 0xF00000C: {
                    if (object == null || ((VideoLiveManager)object).mPlayer == null) {
                        return false;
                    }
                    long l2 = ((VideoLiveManager)object).mPlayer.getLongOption(628, -1L);
                    ((VideoLiveManager)object).mLogService.onAudioRenderStart(l2);
                    if (((VideoLiveManager)object).mPlayer.getIntOption(62, -1) != 0) break;
                }
                case 3: {
                    if (((VideoLiveManager)object).mEnableRtcPlay == 1 && ((VideoLiveManager)object).mRtcPlayFallBack == 0 && ((VideoLiveManager)object).mCurrentRetryCount > 0) {
                        ((VideoLiveManager)object).mCurrentRetryCount = 0;
                    }
                    if (object == null || ((VideoLiveManager)object).mPlayer == null) {
                        return false;
                    }
                    if (object != null && ((VideoLiveManager)object).mPlayer != null) {
                        String string = ((VideoLiveManager)object).mPlayer.getStringOption(142);
                        ((VideoLiveManager)object).mLogService.onUpdateMetaData(string);
                    }
                    if (object != null && ((VideoLiveManager)object).mPlayer != null) {
                        int n4 = ((VideoLiveManager)object).mPlayer.getIntOption(141, -1);
                        if (n4 == 0) {
                            ((VideoLiveManager)object).mLogService.setCodecType("h264");
                        } else if (n4 == 1) {
                            ((VideoLiveManager)object).mLogService.setCodecType("bytevc1");
                        }
                    }
                    if (object != null && ((VideoLiveManager)object).mPlayer != null) {
                        int n5 = ((VideoLiveManager)object).mPlayer.getIntOption(157, -1);
                        ((VideoLiveManager)object).mLogService.mCodecName = ((VideoLiveManager)object).convertCodecName(n5);
                    }
                    ((VideoLiveManager)object).mLogService.onPrepare(0);
                    ((VideoLiveManager)object).mIsStalling = false;
                    if (object != null && ((VideoLiveManager)object).mPlayer != null) {
                        String string = ((VideoLiveManager)object).mPlayer.getStringOption(71);
                        if (((VideoLiveManager)object).mCurrentIP != null && ((VideoLiveManager)object).mCurrentIP.startsWith("[") && string != null && !string.startsWith("[")) {
                            string = String.format("[%s]", string);
                        }
                        if (string != null && !string.equals(((VideoLiveManager)object).mCurrentIP)) {
                            ((VideoLiveManager)object).mLogService.setCdnIp(string, true);
                            ((VideoLiveManager)object).mCurrentIP = string;
                        }
                    }
                    if (((VideoLiveManager)object).mEnableReportSessionStop == 1) {
                        ((VideoLiveManager)object).mLogService.mSessionHasFirstFrame = true;
                        ((VideoLiveManager)object).mLogService.mSessionVideoRenderStartTime = System.currentTimeMillis();
                        ((VideoLiveManager)object).updateSessionFirstFrameInfo();
                    }
                    if (!((VideoLiveManager)object).mShowedFirstFrame) {
                        if (((VideoLiveManager)object).mEnableTextureRender != 1 || ((VideoLiveManager)object).mUsePlayerRenderStart) {
                            MyLog.i(VideoLiveManager.TAG, "render start report first frame");
                            ((VideoLiveManager)object).mLogService.onFirstFrame(0L, ((VideoLiveManager)object).mStallTotalTime);
                            ((VideoLiveManager)object).mLogService.start();
                            ((VideoLiveManager)object).mShowedFirstFrame = true;
                            ((VideoLiveManager)object).mListener.onFirstFrame(true);
                            ((VideoLiveManager)object).setIntOption(75, 1);
                        }
                        if (((VideoLiveManager)object).mIsPlayWithMdl) {
                            MediaLoaderWrapper.getDataLoader().setInt64ValueByStrKey(8015, ((VideoLiveManager)object).mLogService.mSessionId, -1);
                        }
                        if (((VideoLiveManager)object).mLogService.isPreview() && ((VideoLiveManager)object).mIsPlayWithMdl) {
                            MediaLoaderWrapper.getDataLoader().setInt64ValueByStrKey(8016, ((VideoLiveManager)object).mLogService.mSessionId, -1);
                        }
                    } else if (((VideoLiveManager)object).mRenderStartEntered && ((VideoLiveManager)object).mIsRetrying) {
                        ((VideoLiveManager)object).mListener.onFirstFrame(false);
                        if (((VideoLiveManager)object).mUserSwitchResoultion) {
                            ((VideoLiveManager)object).mUserSwitchResoultion = false;
                        } else {
                            ((VideoLiveManager)object).mLogService.onRetry(0);
                            if (((VideoLiveManager)object).mLogService.isStalling()) {
                                ((VideoLiveManager)object).mListener.onStallEnd();
                                ((VideoLiveManager)object).mLogService.onStallEnd(2);
                            }
                        }
                        if (((VideoLiveManager)object).mLogService.isInErrorRecovering()) {
                            ((VideoLiveManager)object).mLogService.onErrorRecovered();
                        }
                        ((VideoLiveManager)object).onRenderStallForRetryStop();
                    }
                    ((VideoLiveManager)object).mRenderStartEntered = true;
                    ((VideoLiveManager)object).mIsRetrying = false;
                    ((VideoLiveManager)object).mRetryProcessor.reset();
                    break;
                }
                case 0xF00000B: {
                    ((VideoLiveManager)object).mListener.onVideoRenderStall(n3);
                    ((VideoLiveManager)object).mLogService.onRenderStall(n3, mVideoRenderStallThreshold, true, true);
                    break;
                }
                case 0xF00000A: {
                    ((VideoLiveManager)object).mListener.onAudioRenderStall(n3);
                    ((VideoLiveManager)object).mLogService.onRenderStall(n3, mAudioRenderStallThreshold, false, true);
                    break;
                }
                case -268435442: {
                    ((VideoLiveManager)object).mLogService.onDemuxerStall(n3, mDemuxerStallThreshold, true);
                    break;
                }
                case -268435441: {
                    ((VideoLiveManager)object).mLogService.onDemuxerStall(n3, mDemuxerStallThreshold, false);
                    break;
                }
                case -268435440: {
                    ((VideoLiveManager)object).mLogService.onDecoderStall(n3, mDecoderStallThreshold, true);
                    break;
                }
                case -268435439: {
                    ((VideoLiveManager)object).mLogService.onDecoderStall(n3, mDecoderStallThreshold, false);
                    break;
                }
                case -268435437: {
                    ((VideoLiveManager)object).mLogService.onPtsBack(n3, false);
                    break;
                }
                case -268435424: {
                    q.d(VideoLiveManager.TAG, "MEDIA_INFO_RTC_VIDEO_DECODE_STALL");
                    ((VideoLiveManager)object).mLogService.onRtcDecoderStall(n3, true);
                    break;
                }
                case -268435423: {
                    q.d(VideoLiveManager.TAG, "MEDIA_INFO_RTC_AUDIO_DECODE_STALL");
                    ((VideoLiveManager)object).mLogService.onRtcDecoderStall(n3, false);
                    break;
                }
                case 702: {
                    ((VideoLiveManager)object).mIsStalling = false;
                    ((VideoLiveManager)object).mListener.onStallEnd();
                    ((VideoLiveManager)object).mRetryProcessor.onStall(false, ((VideoLiveManager)object).mEnterStallRetryInstantly);
                    if (((VideoLiveManager)object).mShowedFirstFrame && ((VideoLiveManager)object).mLogService.isStalling()) {
                        ((VideoLiveManager)object).mLogService.onStallEnd(1);
                    } else if (!((VideoLiveManager)object).mShowedFirstFrame && ((VideoLiveManager)object).mStallStartTime != 0L) {
                        ((VideoLiveManager)object).mStallTotalTime = System.currentTimeMillis() - ((VideoLiveManager)object).mStallStartTime;
                    }
                    if (!((VideoLiveManager)object).mIsPlayWithMdl) break;
                    MediaLoaderWrapper.getDataLoader().setInt64ValueByStrKey(7214, ((VideoLiveManager)object).mLogService.mSessionId, n3);
                    break;
                }
                case 701: {
                    ((VideoLiveManager)object).mStallCount++;
                    ((VideoLiveManager)object).getLastRenderTime();
                    ((VideoLiveManager)object).mIsStalling = true;
                    ((VideoLiveManager)object).mListener.onStallStart();
                    if (!((VideoLiveManager)object).mShowedFirstFrame) {
                        ((VideoLiveManager)object).mStallStartTime = System.currentTimeMillis();
                        ((VideoLiveManager)object).mLogService.onStallStart(n3, false);
                    } else {
                        ((VideoLiveManager)object).mLogService.onStallStart(n3, true);
                        if (((VideoLiveManager)object).mIsPlayWithMdl) {
                            MediaLoaderWrapper.getDataLoader().setInt64ValueByStrKey(7213, ((VideoLiveManager)object).mLogService.mSessionId, n3);
                        }
                    }
                    if (((VideoLiveManager)object).mEnableResolutionAutoDegrade && ((VideoLiveManager)object).mURLSource.getSourceType() == 2 && (!((VideoLiveManager)object).mAbrStrategy.equals("rad") || ((VideoLiveManager)object).mStallCount < ((VideoLiveManager)object).mStallCountThresOfResolutionDegrade ? ((VideoLiveManager)object).mAbrStrategy.equals("abr_bb_4live") && ((VideoLiveManager)object).mResolution.equals("auto") && ((VideoLiveManager)object).mEnableAbrStallDegradeImmediately == 1 && ((VideoLiveManager)object).abrDegradeResolution() : ((VideoLiveManager)object).degradeResolution())) break;
                    if (((VideoLiveManager)object).mIsLocalURL) break;
                    if (((VideoLiveManager)object).mEnableStallRetryInstantly == 1 && ((VideoLiveManager)object).mPlayer.getLongOption(530, -1L) == 0L && ((VideoLiveManager)object).mPlayer.getLongOption(531, -1L) == 0L) {
                        ((VideoLiveManager)object).mEnterStallRetryInstantly = true;
                    }
                    ((VideoLiveManager)object).mRetryProcessor.onStall(true, ((VideoLiveManager)object).mEnterStallRetryInstantly);
                    break;
                }
                case 0xF000007: {
                    ++((VideoLiveManager)object).mLogService.mSpeedSwitchCount;
                    ((VideoLiveManager)object).mLogService.mSpeedSwitchInfo = ((VideoLiveManager)object).mLogService.mSpeedSwitchInfo + "," + (double)n3 / 1000.0 + ":" + System.currentTimeMillis();
                    break;
                }
                case 0xF000009: {
                    String string;
                    n3 /= 1000;
                    if (!((VideoLiveManager)object).mEnableResolutionAutoDegrade || !((VideoLiveManager)object).mAbrStrategy.equals("abr_bb_4live") || ((VideoLiveManager)object).mURLSource.getSourceType() != 2) break;
                    String string2 = ((VideoLiveManager)object).mURLSource.getLabelfromBitrate(n3, ((VideoLiveManager)object).mLevel);
                    if (TextUtils.isEmpty((CharSequence)string2) && ((VideoLiveManager)object).mLogService.mBitRateAbnormalType == 1 && (long)n3 == ((VideoLiveManager)object).mTargetOriginBitRate / 1000L) {
                        string2 = "origin";
                    }
                    if ((string = ((VideoLiveManager)object).mURLSource.getDefaultResolution()) == null || string.equals(string2)) break;
                    if (string2 != null) {
                        ((VideoLiveManager)object).mLogService.mAbrSwitchInfo = "abr_" + ((VideoLiveManager)object).mURLSource.getDefaultResolution() + "_to_" + string2;
                        ((VideoLiveManager)object).mURLSource.setDefaultResolution(string2);
                        ((VideoLiveManager)object).mLogService.mAutoUsingResolution = string2;
                    } else {
                        ((VideoLiveManager)object).mLogService.mAbrSwitchInfo = "none";
                    }
                    ++((VideoLiveManager)object).mLogService.mAbrSwitchCount;
                    ((VideoLiveManager)object).mLogService.mAbrSwitchCountInfo = ((VideoLiveManager)object).mLogService.mAbrSwitchCountInfo + "," + n3 + ":" + System.currentTimeMillis();
                    ((VideoLiveManager)object).mLogService.mCurDownloadSpeed = ((VideoLiveManager)object).mPlayer.getLongOption(63, 0L) * 8L / 1000L;
                    ((VideoLiveManager)object).mLogService.mCurAudioBufferTime = ((VideoLiveManager)object).mPlayer.getLongOption(73, 0L);
                    ((VideoLiveManager)object).mLogService.mCurVideoBufferTime = ((VideoLiveManager)object).mPlayer.getLongOption(72, 0L);
                    ((VideoLiveManager)object).mLogService.mAbrSwitchCost = ((VideoLiveManager)object).mPlayer.getLongOption(930, -1L);
                    ((VideoLiveManager)object).mListener.onAbrSwitch(string2);
                    ((VideoLiveManager)object).mLogService.onAbrSwitch(n3, string2, true);
                    break;
                }
                case 0xF00000D: {
                    ++((VideoLiveManager)object).mLogService.mSilenceDetectedCount;
                    break;
                }
                case -268435407: {
                    System.currentTimeMillis();
                    ((VideoLiveManager)object).mLogService.mNoSyncStartTime = System.currentTimeMillis();
                    ((VideoLiveManager)object).mLogService.mNoSyncStartPts = n3;
                    break;
                }
                case -268435406: {
                    String string;
                    System.currentTimeMillis();
                    long l3 = System.currentTimeMillis();
                    long l4 = (long)n3 - ((VideoLiveManager)object).mLogService.mNoSyncStartPts;
                    long l5 = l3 - ((VideoLiveManager)object).mLogService.mNoSyncStartTime;
                    if (l4 <= (long)((VideoLiveManager)object).mNoSyncReportMinDuration) break;
                    ++((VideoLiveManager)object).mLogService.mNoSyncCount;
                    ++((VideoLiveManager)object).mLogService.mNoSyncPlayingCount;
                    ((VideoLiveManager)object).mLogService.mNoSyncTimeDuration += l5;
                    ((VideoLiveManager)object).mLogService.mNoSyncPlayingTimeDuration += l5;
                    ((VideoLiveManager)object).mLogService.mNoSyncPtsDuration += l4;
                    ((VideoLiveManager)object).mLogService.mNoSyncPlayingPtsDuration += l4;
                    String string3 = ((VideoLiveManager)object).mPlayer.getStringOption(825);
                    try {
                        string = new JSONObject().put("start_time", ((VideoLiveManager)object).mLogService.mNoSyncStartTime).put("end_time", l3).put("start_pts", ((VideoLiveManager)object).mLogService.mNoSyncStartPts).put("end_pts", n3).put("info", (Object)string3).toString();
                    }
                    catch (JSONException jSONException) {
                        string = null;
                        q.d(jSONException);
                    }
                    if ((long)(((VideoLiveManager)object).mLogService.mNoSyncPlayingInfoStr.length() + string.length()) < (long)((VideoLiveManager)object).mLogService.mNoSyncPlayingInfoLen) {
                        ((VideoLiveManager)object).mLogService.mNoSyncPlayingInfoStr = ((VideoLiveManager)object).mLogService.mNoSyncPlayingInfoStr + string;
                    }
                    if ((long)(((VideoLiveManager)object).mLogService.mNoSyncInfoStr.length() + string.length()) >= (long)((VideoLiveManager)object).mLogService.mNoSyncInfoLen) break;
                    ((VideoLiveManager)object).mLogService.mNoSyncInfoStr = ((VideoLiveManager)object).mLogService.mNoSyncInfoStr + string;
                }
            }
            return false;
        }
    }

    private static final class MyErrorListener
    implements MediaPlayer.OnErrorListener {
        private final WeakReference<VideoLiveManager> mVideoLiveManagerRef;

        public MyErrorListener(VideoLiveManager videoLiveManager) {
            this.mVideoLiveManagerRef = new WeakReference<VideoLiveManager>(videoLiveManager);
        }

        @Override
        public boolean onError(MediaPlayer mediaPlayer, int n2, int n3) {
            MyLog.e(VideoLiveManager.TAG, "onError ".concat(String.valueOf(n2)));
            VideoLiveManager videoLiveManager = (VideoLiveManager)this.mVideoLiveManagerRef.get();
            if (videoLiveManager == null || videoLiveManager.mPlayer == null) {
                return false;
            }
            if (n2 != 0) {
                videoLiveManager.mLogService.onPrepare(n2);
            }
            Serializable serializable = new LiveError(n2, "player on error", null);
            videoLiveManager.mListener.onError((LiveError)serializable);
            if (videoLiveManager.mIsLocalURL) {
                return true;
            }
            if (videoLiveManager.mEnableQuicDegrade == 1 && videoLiveManager.QuicDegrade(n2)) {
                return true;
            }
            if (videoLiveManager.mEnableHttpkDegrade == 1 && videoLiveManager.HttpKDegradeHttp(n2)) {
                return true;
            }
            if ((videoLiveManager.mEnableRtcPlay != 1 || videoLiveManager.mRtcPlayFallBack != 0) && videoLiveManager.mEnableSwitchMainAndBackupUrl && videoLiveManager.mURLSource.getSourceType() == 2 && videoLiveManager.switchMainAndBackupUrl(n2)) {
                return true;
            }
            if (videoLiveManager.mURLSource.getSourceType() == 1 && videoLiveManager.bytevc1DegradeH264(n2)) {
                return true;
            }
            serializable = new HashMap<String, Integer>();
            serializable.put("internalCode", n2);
            serializable.put("internalExtra", n3);
            serializable.put("playerType", mediaPlayer.getPlayerType());
            serializable = new LiveError(-100003, "player on error", (Map<String, String>)((Object)serializable));
            videoLiveManager.mRetryProcessor.onError((LiveError)serializable, videoLiveManager.mShowedFirstFrame);
            return false;
        }
    }

    private static final class MyPreparedListener
    implements MediaPlayer.OnPreparedListener {
        private final WeakReference<VideoLiveManager> mVideoLiveManagerRef;

        public MyPreparedListener(VideoLiveManager videoLiveManager) {
            this.mVideoLiveManagerRef = new WeakReference<VideoLiveManager>(videoLiveManager);
        }

        @Override
        public void onPrepared(MediaPlayer object) {
            object = (VideoLiveManager)this.mVideoLiveManagerRef.get();
            if (object == null || ((VideoLiveManager)object).mPrepareState != PlayerState.PREPARING || ((VideoLiveManager)object).mPlayer == null) {
                return;
            }
            ((VideoLiveManager)object).mPrepareState;
            ((VideoLiveManager)object).mLogService.onPrepareEnd();
            ((VideoLiveManager)object).mPrepareState = PlayerState.PREPARED;
            if (((VideoLiveManager)object).mStartDirectAfterPrepared == 0) {
                ((VideoLiveManager)object).mPlayer.start();
            }
            ((VideoLiveManager)object).mListener.onPrepared();
        }
    }

    private static class NamedThreadFactory
    implements ThreadFactory {
        private NamedThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            runnable = new pl(runnable, VideoLiveManager.TAG);
            ((Thread)runnable).setPriority(10);
            return runnable;
        }
    }

    private static enum LivePlayerState {
        IDLE,
        PLAYED,
        PAUSED,
        STOPPED;

    }

    private static enum PlayerState {
        IDLE,
        INITIALIZED,
        PREPARING,
        PREPARED;

    }
}

