/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.sdk.openadsdk.widget;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.widget.ImageView;

public class TTRoundRectImageView
extends ImageView {
    private Paint d = new Paint();
    private int j = 25;
    private int pl = 25;
    private Matrix t;

    public TTRoundRectImageView(Context context) {
        this(context, null);
    }

    public TTRoundRectImageView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public TTRoundRectImageView(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        this.d.setAntiAlias(true);
        this.d.setFilterBitmap(true);
        this.t = new Matrix();
    }

    public TTRoundRectImageView(Context context, int n2, int n3) {
        this(context);
        this.j = n2;
        this.pl = n3;
    }

    public void setXRound(int n2) {
        this.j = n2;
        this.postInvalidate();
    }

    public void setYRound(int n2) {
        this.pl = n2;
        this.postInvalidate();
    }

    protected void onDraw(Canvas canvas) {
        Drawable drawable = this.getDrawable();
        if (drawable != null) {
            if ((drawable = this.d(drawable)) != null) {
                Shader.TileMode tileMode = Shader.TileMode.REPEAT;
                BitmapShader bitmapShader = new BitmapShader((Bitmap)drawable, tileMode, tileMode);
                float f2 = 1.0f;
                if (drawable.getWidth() != this.getWidth() || drawable.getHeight() != this.getHeight()) {
                    f2 = Math.max((float)this.getWidth() * 1.0f / (float)drawable.getWidth(), (float)this.getHeight() * 1.0f / (float)drawable.getHeight());
                }
                float f3 = f2;
                this.t.setScale(f3, f3);
                bitmapShader.setLocalMatrix(this.t);
                this.d.setShader((Shader)bitmapShader);
                canvas.drawRoundRect(new RectF(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight()), (float)this.j, (float)this.pl, this.d);
                return;
            }
            super.onDraw(canvas);
            return;
        }
        super.onDraw(canvas);
    }

    private Bitmap d(Drawable drawable) {
        if (drawable == null) {
            return null;
        }
        if (drawable instanceof BitmapDrawable) {
            return ((BitmapDrawable)drawable).getBitmap();
        }
        int n2 = drawable.getIntrinsicWidth() <= 0 ? this.getWidth() : drawable.getIntrinsicWidth();
        int n3 = drawable.getIntrinsicHeight() <= 0 ? this.getHeight() : drawable.getIntrinsicHeight();
        Bitmap bitmap = Bitmap.createBitmap((int)n2, (int)n3, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        drawable.setBounds(0, 0, n2, n3);
        drawable.draw(canvas);
        return bitmap;
    }
}

