/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.pangle;

import android.content.ComponentCallbacks;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.pm.ApplicationInfo;
import android.content.res.AssetManager;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.support.annotation.Keep;
import android.support.annotation.RequiresApi;
import android.support.v7.view.ContextThemeWrapper;
import android.view.LayoutInflater;
import com.bytedance.pangle.j.j.d;
import com.bytedance.pangle.plugin.Plugin;
import com.bytedance.pangle.res.j;
import com.bytedance.pangle.transform.ZeusTransformUtils;
import com.bytedance.pangle.util.FieldUtils;
import com.bytedance.pangle.wc;
import com.bytedance.pangle.wrapper.PluginApplicationWrapper;

@Keep
public class PluginContext
extends wc {
    public Plugin mPlugin;
    public Context mOriginContext;
    public boolean mIsHostApplicationContext;
    private LayoutInflater mInflater;
    private Configuration mOverrideConfiguration;

    public PluginContext() {
    }

    public PluginContext(Context context, Plugin plugin, boolean bl) {
        super(PluginContext.getContextWithoutTheme(context), PluginContext.getThemeResourceId(context));
        this.mPlugin = plugin;
        this.mOriginContext = context;
        this.mIsHostApplicationContext = bl;
    }

    public static int getThemeResourceId(Context context) {
        if (context instanceof android.view.ContextThemeWrapper) {
            try {
                return (Integer)FieldUtils.readField(context, "mThemeResource");
            }
            catch (IllegalAccessException illegalAccessException) {
                com.bytedance.sdk.openadsdk.api.wc.d(illegalAccessException);
            }
        }
        if (context instanceof ContextThemeWrapper) {
            return ((ContextThemeWrapper)context).getThemeResId();
        }
        return 0;
    }

    @Override
    protected String getPluginPkg() {
        return this.mPlugin.mPkgName;
    }

    public static Context getContextWithoutTheme(Context context) {
        if (context instanceof android.view.ContextThemeWrapper) {
            return PluginContext.getContextWithoutTheme(((android.view.ContextThemeWrapper)context).getBaseContext());
        }
        if (context instanceof ContextThemeWrapper) {
            return PluginContext.getContextWithoutTheme(((ContextThemeWrapper)context).getBaseContext());
        }
        return context;
    }

    public void applyOverrideConfiguration(Configuration configuration) {
        if (this.mPlugin.mResources != null) {
            throw new IllegalStateException("getResources() or getAssets() has already been called");
        }
        if (this.mOverrideConfiguration != null) {
            throw new IllegalStateException("Override configuration has already been set");
        }
        this.mOverrideConfiguration = new Configuration(configuration);
    }

    public Configuration getOverrideConfiguration() {
        return this.mOverrideConfiguration;
    }

    public AssetManager getAssets() {
        return this.mPlugin.mResources.getAssets();
    }

    public Resources getResources() {
        return this.mPlugin.mResources;
    }

    @RequiresApi(api=17)
    private Resources getResourcesInternal() {
        return this.mPlugin.mResources;
    }

    public Context createConfigurationContext(Configuration configuration) {
        configuration = super.createConfigurationContext(configuration);
        try {
            FieldUtils.writeField(configuration, "mResources", (Object)this.mPlugin.mResources);
        }
        catch (Throwable throwable) {
            try {
                d.d(configuration.getClass(), "mResources").set(configuration, this.mPlugin.mResources);
            }
            catch (Throwable throwable2) {
                com.bytedance.sdk.openadsdk.api.wc.d(throwable2);
            }
        }
        return configuration;
    }

    public Object getSystemService(String string) {
        if ("layout_inflater".equals(string)) {
            if (this.mInflater == null) {
                this.mInflater = LayoutInflater.from((Context)this.getBaseContext()).cloneInContext((Context)this);
                j.d(this.mInflater);
            }
            return this.mInflater;
        }
        if (this.mOriginContext != null) {
            return this.mOriginContext.getSystemService(string);
        }
        return this.getBaseContext().getSystemService(string);
    }

    public Context getBaseContext() {
        Context context = super.getBaseContext();
        if (context instanceof ContextWrapper) {
            return ((ContextWrapper)context).getBaseContext();
        }
        return context;
    }

    public ClassLoader getClassLoader() {
        return this.mPlugin.mClassLoader;
    }

    public ApplicationInfo getApplicationInfo() {
        return this.mPlugin.mHostApplicationInfoHookSomeField;
    }

    public Context getApplicationContext() {
        if (this.mOriginContext instanceof PluginApplicationWrapper) {
            return this.mOriginContext;
        }
        return ZeusTransformUtils.wrapperContext(this.mOriginContext.getApplicationContext(), this.mPlugin.mPkgName);
    }

    public void registerComponentCallbacks(ComponentCallbacks componentCallbacks) {
        if (this.mIsHostApplicationContext) {
            this.mOriginContext.registerComponentCallbacks(componentCallbacks);
            return;
        }
        super.registerComponentCallbacks(componentCallbacks);
    }

    public void unregisterComponentCallbacks(ComponentCallbacks componentCallbacks) {
        if (this.mIsHostApplicationContext) {
            this.mOriginContext.unregisterComponentCallbacks(componentCallbacks);
            return;
        }
        super.unregisterComponentCallbacks(componentCallbacks);
    }

    public String getPluginPackageName() {
        return this.mPlugin.mPkgName;
    }
}

