/*
 * Decompiled with CFR 0.152.
 */
package com.bykv.vk.component.ttvideo.medialoader;

import android.text.TextUtils;
import com.bykv.vk.component.ttvideo.AppInfo;
import com.bykv.vk.component.ttvideo.log.LiveLoggerService;
import com.bykv.vk.component.ttvideo.log.MyLog;
import com.bykv.vk.component.ttvideo.mediakit.medialoader.AVMDLDataLoader;
import com.bykv.vk.component.ttvideo.mediakit.medialoader.AVMDLDataLoaderConfigure;
import com.bykv.vk.component.ttvideo.mediakit.medialoader.AVMDLDataLoaderListener;
import com.bykv.vk.component.ttvideo.mediakit.medialoader.AVMDLDataLoaderNotifyInfo;
import com.bykv.vk.component.ttvideo.medialoader.LibraryLoadProxy;
import com.bykv.vk.component.ttvideo.medialoader.MediaLoaderListener;
import com.bykv.vk.component.ttvideo.player.MediaPlayer;
import com.bytedance.sdk.component.utils.q;
import java.net.URLEncoder;
import org.json.JSONException;
import org.json.JSONObject;

public class MediaLoaderWrapper
implements AVMDLDataLoaderListener {
    static final String TAG = "MediaLoaderWrapper";
    static final String HTTP_PROTO_PREFIX = "http://";
    static final String MDL_PROTO_PREFIX = "mdl://";
    public static final int DATALOADER_KEY_NOTIFY_TASKLOG = 0;
    public static final int DATALOADER_KEY_NOTIFY_OWNVDPLOG = 1;
    public static final int DATALOADER_KEY_NOTIFY_SPEEDINFO = 2;
    public AVMDLDataLoaderConfigure mConfigure = AVMDLDataLoaderConfigure.getDefaultonfigure();
    private volatile boolean isProxyLibraryLoaded = false;
    private volatile LibraryLoadProxy mProxy = null;
    private MediaLoaderListener mListener;
    private MediaPlayer mPlayer;
    private LiveLoggerService mLogService;
    private boolean mIsRunning = false;
    private boolean mEnableLoadLibrary = false;

    private MediaLoaderWrapper() {
    }

    public MediaLoaderWrapper(MediaLoaderListener mediaLoaderListener) {
        this.mListener = mediaLoaderListener;
    }

    public static MediaLoaderWrapper getDataLoader() {
        return Holder.instance;
    }

    public void setMediaPlayer(MediaPlayer mediaPlayer) {
        this.mPlayer = mediaPlayer;
    }

    public void setLogService(LiveLoggerService liveLoggerService) {
        this.mLogService = liveLoggerService;
    }

    public void setListener(MediaLoaderListener object) {
        this.mListener = object;
        try {
            AVMDLDataLoader.getInstance().setListener(107, this);
            return;
        }
        catch (Exception exception) {
            object = exception;
            q.d(exception);
            MyLog.i(TAG, String.format("create loader failed: exception is" + ((Throwable)object).toString(), new Object[0]));
            return;
        }
    }

    public void setLoadProxy(LibraryLoadProxy libraryLoadProxy) {
        this.mProxy = libraryLoadProxy;
    }

    public void enableLoadLibrary() {
        this.mEnableLoadLibrary = true;
    }

    public void start() throws Exception {
        if (this.mIsRunning) {
            return;
        }
        if (!this.initInternal()) {
            throw new Exception("init mediaLoader fail");
        }
        JSONObject jSONObject = new JSONObject();
        try {
            if (AppInfo.mAppChannel != null) {
                if (!TextUtils.isEmpty((CharSequence)AppInfo.mAppChannel)) {
                    jSONObject.put("app_channel", (Object)AppInfo.mAppChannel);
                }
                if (!TextUtils.isEmpty((CharSequence)AppInfo.mAppName)) {
                    jSONObject.put("app_name", (Object)AppInfo.mAppName);
                }
                if (!TextUtils.isEmpty((CharSequence)AppInfo.mDeviceId)) {
                    jSONObject.put("device_id", (Object)AppInfo.mDeviceId);
                }
                if (!TextUtils.isEmpty((CharSequence)AppInfo.mAppVersion)) {
                    jSONObject.put("app_version", (Object)AppInfo.mAppVersion);
                }
                jSONObject.put("app_id", AppInfo.mAppID);
            }
        }
        catch (JSONException jSONException) {
            jSONObject = null;
            q.d(jSONException);
        }
        if (jSONObject == null) {
            return;
        }
        this.mConfigure.mAppInfo = jSONObject.toString();
        if (AppInfo.mAppID != -1) {
            MyLog.i(TAG, "set config");
            AVMDLDataLoader.getInstance().setConfigure(this.mConfigure);
        }
        if (AVMDLDataLoader.getInstance().start() < 0) {
            throw new Exception("start mediaLoader fail");
        }
        this.mIsRunning = true;
    }

    public void close() {
        if (!this.mIsRunning) {
            MyLog.e(TAG, "MediaLoader not started, not need close");
            return;
        }
        this.mListener = null;
        AVMDLDataLoader.getInstance().close();
        AVMDLDataLoader.getInstance().cancelAll();
        this.mIsRunning = false;
    }

    public boolean isRunning() {
        if (AVMDLDataLoader.getInstance() == null) {
            return false;
        }
        return AVMDLDataLoader.getInstance().isRunning();
    }

    public long getLongValueFromLoader(int n2) {
        MyLog.i(TAG, "get long value from loader");
        AVMDLDataLoader aVMDLDataLoader = AVMDLDataLoader.getInstance();
        switch (n2) {
            case 8100: {
                if (aVMDLDataLoader == null) {
                    return -1L;
                }
                return aVMDLDataLoader.getLongValue(8100);
            }
            case 8101: {
                if (aVMDLDataLoader == null) {
                    return -1L;
                }
                return aVMDLDataLoader.getLongValue(8101);
            }
            case 7218: {
                if (aVMDLDataLoader == null) {
                    return -1L;
                }
                return aVMDLDataLoader.getLongValue(7218);
            }
            case 8102: {
                if ((aVMDLDataLoader == null ? -1L : aVMDLDataLoader.getLongValue(8102)) == 1L) {
                    return 1L;
                }
                return 0L;
            }
        }
        return -1L;
    }

    public String getStringValueFromLoader(int n2) {
        MyLog.i(TAG, "get string value from loader");
        AVMDLDataLoader aVMDLDataLoader = AVMDLDataLoader.getInstance();
        switch (n2) {
            case 11: {
                if (aVMDLDataLoader == null) {
                    return null;
                }
                return aVMDLDataLoader.getStringValue(11);
            }
        }
        return null;
    }

    public void setIntValue(int n2, int n3) {
        if (n2 == 51) {
            this.mConfigure.mRWTimeOut = n3;
            return;
        }
        if (n2 == 52) {
            this.mConfigure.mOpenTimeOut = n3;
            return;
        }
        if (n2 == 53) {
            this.mConfigure.mTryCount = n3;
            return;
        }
        if (n2 == 49) {
            MyLog.i(TAG, "allow p2p:".concat(String.valueOf(n3)));
            this.mConfigure.mLiveP2pAllow = n3;
            return;
        }
        if (n2 == 50) {
            MyLog.i(TAG, "loader type:".concat(String.valueOf(n3)));
            this.mConfigure.mLiveLoaderType = n3;
        }
    }

    public void setLongValue(int n2, long l2) {
        AVMDLDataLoader aVMDLDataLoader = AVMDLDataLoader.getInstance();
        if (aVMDLDataLoader == null) {
            return;
        }
        switch (n2) {
            case 59: {
                aVMDLDataLoader.setLongValue(1100, l2);
                return;
            }
        }
    }

    public void setInt64ValueByStrKey(int n2, String string, int n3) {
        AVMDLDataLoader aVMDLDataLoader = AVMDLDataLoader.getInstance();
        if (aVMDLDataLoader == null) {
            return;
        }
        switch (n2) {
            case 7213: 
            case 7215: {
                aVMDLDataLoader.setInt64ValueByStrKey(n2, string, n3);
                return;
            }
        }
        aVMDLDataLoader.setInt64ValueByStrKey(n2, string, System.currentTimeMillis());
    }

    public void setStringValue(int n2, String string) {
        AVMDLDataLoader aVMDLDataLoader = AVMDLDataLoader.getInstance();
        if (aVMDLDataLoader == null) {
            return;
        }
        aVMDLDataLoader.setStringValue(n2, string);
    }

    public String getProxyUrl(String string, Boolean bl) {
        if (string == null) {
            return null;
        }
        if (!this.supportProxy(string)) {
            return string;
        }
        String string2 = AVMDLDataLoader.getInstance().getLocalAddr();
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        String string3 = null;
        try {
            string3 = URLEncoder.encode(string, "UTF-8");
        }
        catch (Throwable throwable) {
            q.d(throwable);
        }
        string = string2 + "?rk=v02004b50000bh9ajqhdli3lfv2rgsgg&k=426161df8c5ce110209a6fc6641e049ddfrfgaf&u0=" + string3;
        if (bl.booleanValue()) {
            return MDL_PROTO_PREFIX.concat(String.valueOf(string));
        }
        return HTTP_PROTO_PREFIX.concat(String.valueOf(string));
    }

    private boolean initInternal() {
        if (this.mEnableLoadLibrary) {
            if (!this.loadLibrary()) {
                MyLog.i(TAG, String.format("library load fail", new Object[0]));
                return false;
            }
            if (AVMDLDataLoader.init(this.mProxy != null) != 0) {
                String.format("library has not been loaded", new Object[0]);
                return false;
            }
        }
        try {
            AVMDLDataLoader.getInstance().setListener(107, this);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            q.d(exception);
            MyLog.i(TAG, String.format("create loader failed: exception is" + exception2.toString(), new Object[0]));
            return false;
        }
        return true;
    }

    private boolean loadLibrary() {
        if (this.mProxy == null) {
            return true;
        }
        if (this.mProxy != null && !this.isProxyLibraryLoaded) {
            this.isProxyLibraryLoaded = this.mProxy.loadLibrary("avmdl");
        }
        return this.isProxyLibraryLoaded;
    }

    private boolean supportProxy(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        if ((string = string.toLowerCase()).startsWith("http://127.0.0.1") || string.startsWith("http://localhost")) {
            return false;
        }
        if (string.startsWith("file://") || string.startsWith("/")) {
            return false;
        }
        return !string.endsWith(".mpd") && !string.contains(".mpd?") && !string.contains(".m3u8?") && !string.endsWith(".m3u8");
    }

    @Override
    public void onNotify(AVMDLDataLoaderNotifyInfo aVMDLDataLoaderNotifyInfo) {
        if (aVMDLDataLoaderNotifyInfo == null || this.mListener == null) {
            return;
        }
        MyLog.i(TAG, "what:" + aVMDLDataLoaderNotifyInfo.what);
        switch (aVMDLDataLoaderNotifyInfo.what) {
            case 2: {
                return;
            }
            case 0: {
                return;
            }
            case 1: {
                return;
            }
            case 9: {
                if (this.mListener != null) {
                    this.mListener.onDataLoaderError((int)aVMDLDataLoaderNotifyInfo.parameter, aVMDLDataLoaderNotifyInfo.logInfo);
                }
                MyLog.i(TAG, "live loader errorCode:" + aVMDLDataLoaderNotifyInfo.parameter + " errorInfo:" + aVMDLDataLoaderNotifyInfo.logInfo);
                return;
            }
            case 12: {
                if (this.mListener != null) {
                    this.mListener.onSwitchLoaderType((int)aVMDLDataLoaderNotifyInfo.parameter, aVMDLDataLoaderNotifyInfo.logInfo);
                }
                MyLog.i(TAG, "switch reason:" + aVMDLDataLoaderNotifyInfo.parameter + " switchInfo:" + aVMDLDataLoaderNotifyInfo.logInfo);
            }
        }
    }

    @Override
    public long getInt64Value(int n2, long l2) {
        MyLog.i(TAG, "getInt64Value:".concat(String.valueOf(n2)));
        switch (n2) {
            case 8003: {
                if (this.mPlayer != null) {
                    return this.mPlayer.getLongOption(73, 0L);
                }
                return l2;
            }
            case 8004: {
                if (this.mListener != null) {
                    return this.mListener.getInt64Value(0, l2);
                }
                return l2;
            }
        }
        return l2;
    }

    @Override
    public String getCheckSumInfo(String string) {
        return null;
    }

    @Override
    public String getStringValue(int n2, long l2, String string) {
        return null;
    }

    private static class Holder {
        private static MediaLoaderWrapper instance = new MediaLoaderWrapper();

        private Holder() {
        }
    }
}

