/*
 * Decompiled with CFR 0.152.
 */
package com.bykv.vk.component.ttvideo.player;

import android.annotation.TargetApi;
import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaFormat;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Pair;
import android.view.Surface;
import com.bykv.vk.component.ttvideo.player.AJMediaCodecFrame;
import com.bykv.vk.component.ttvideo.player.AJMediaCodecRank;
import com.bykv.vk.component.ttvideo.player.AVThreadPool;
import com.bykv.vk.component.ttvideo.player.CalledByNative;
import com.bykv.vk.component.ttvideo.player.DummySurface;
import com.bykv.vk.component.ttvideo.player.Keep;
import com.bykv.vk.component.ttvideo.player.MediaCodecUtil;
import com.bykv.vk.component.ttvideo.player.VendorQTI;
import com.bykv.vk.component.ttvideo.utils.Util;
import com.bytedance.sdk.component.utils.q;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Locale;

@TargetApi(value=16)
@Keep
class AJMediaCodec {
    private static final String TAG = "aj_media_codec";
    private static final long INPUT_TIMEOUT_US = 30000L;
    private static final int PIXEL_FORMAT_NV12 = 3;
    private static final int PIXEL_FORMAT_YUV420P = 0;
    private static final int NO_VALUE = -1;
    private static final String KEY_CROP_LEFT = "crop-left";
    private static final String KEY_CROP_RIGHT = "crop-right";
    private static final String KEY_CROP_BOTTOM = "crop-bottom";
    private static final String KEY_CROP_TOP = "crop-top";
    private ByteBuffer[] mOutputBuffers;
    private ByteBuffer[] mInputBuffers;
    private boolean mInputBuffersValid = false;
    private static ArrayList<MediaCodecInfo> mVideoHWDecoderCodecs = new ArrayList();
    private static Object mCodecListLock = new Object();
    private static boolean mEvaluatedDeviceNeedsSetOutputSurfaceWorkaround = false;
    private static boolean mDeviceNeedsSetOutputSurfaceWorkaround = false;
    private MediaCodec mMediaCodec;
    private MediaCodec.BufferInfo mBufferInfo;
    private MediaFormat mOutputMediaFormat = null;
    private static boolean mIsInitDetected = false;
    private static boolean mIsByteVC1Blocklist = false;
    private static final String VERSION_PROPERTY = "ro.config.hw_codec_support";
    private static final double FIX_VERSION = 0.18041;
    private static final String VENDOR_OPPO_PROPERTY = "persist.sys.aweme.hdsupport";
    private Surface mDummySurface;
    private static boolean mNeedByteVC1WorkAround = false;
    private static final int CODEC_ERROR = -10000;
    private static final int CODEC_EXCEPTION_ERROR = -10001;
    private static final int CODEC_ILLEGAL_STATE = -10002;
    private static final int CODEC_ILLEGAL_ARGUMENT = -10003;
    private static final int AV_TRC_SMPTE2084 = 16;
    private static final int AV_TRC_ARIB_STD_B67 = 18;
    private String mExceptionInfo;

    public boolean MTKByteVC1NeedWorkAround() {
        return mNeedByteVC1WorkAround;
    }

    public static String getProperty(String string, String string2) {
        String string3 = string2;
        try {
            Class<?> clazz = Class.forName("android.os.SystemProperties");
            string3 = (String)clazz.getMethod("get", String.class, String.class).invoke(clazz, string, string2);
            return string3;
        }
        catch (Exception exception) {
            try {
                q.d(exception);
                return string3;
            }
            catch (Throwable throwable) {
                return string3;
            }
        }
    }

    @CalledByNative
    public AJMediaCodec() {
        if (!mIsInitDetected) {
            boolean bl = mNeedByteVC1WorkAround = Util.HARDWARE.toLowerCase(Locale.US).startsWith("mt") && Util.SDK_INT < 26;
            if (this.isHisiByteVC1BlockList() || this.isMtkByteVC1BlockList()) {
                mIsByteVC1Blocklist = true;
            }
        }
        AJMediaCodec.codecNeedsSetOutputSurfaceWorkaround();
        mIsInitDetected = true;
        q.d(TAG, "initialize, need workaround " + mDeviceNeedsSetOutputSurfaceWorkaround);
    }

    @CalledByNative
    public String getErrorInfo() {
        return this.mExceptionInfo;
    }

    private boolean isHisiByteVC1BlockList() {
        String string = AJMediaCodec.getProperty("ro.board.platform", null);
        if (Util.SDK_INT == 26 && string != null && (string.startsWith("kirin960") || string.startsWith("hi3660"))) {
            double d2 = 0.0;
            string = AJMediaCodec.getProperty(VERSION_PROPERTY, "0.0");
            try {
                d2 = Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                q.j(TAG, "vendor property abnormal");
            }
            if (d2 < 0.18041) {
                return true;
            }
        }
        return false;
    }

    @CalledByNative
    private boolean supportSetSurface() {
        return !mDeviceNeedsSetOutputSurfaceWorkaround;
    }

    private boolean isMtkByteVC1BlockList() {
        String string = Util.HARDWARE.toLowerCase(Locale.US);
        return string.startsWith("mt6763") || string.startsWith("mt6757") || string.startsWith("mt6739") || string.startsWith("mt6750");
    }

    @CalledByNative
    public int vendorOppoHWEnable() {
        int n2 = 1;
        if (Util.BARND.equals("OPPO")) {
            String string = AJMediaCodec.getProperty(VENDOR_OPPO_PROPERTY, "1");
            q.d(TAG, "oppo property = ".concat(String.valueOf(string)));
            try {
                n2 = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                q.j(TAG, "vendor oppo property abnormal");
            }
        }
        return n2;
    }

    @CalledByNative
    public int createByCodecName(String string) {
        q.d(TAG, "createByCodecName = ".concat(String.valueOf(string)));
        try {
            this.mMediaCodec = MediaCodec.createByCodecName((String)string);
        }
        catch (Exception exception) {
            this.handleCodecException(exception);
            return -1;
        }
        return 0;
    }

    private static void maybeSetInteger(MediaFormat mediaFormat, String string, int n2) {
        if (n2 != -1) {
            mediaFormat.setInteger(string, n2);
        }
    }

    private static void maybeSetCsdBuffers(MediaFormat mediaFormat, ByteBuffer byteBuffer, int n2) {
        if (byteBuffer == null) {
            return;
        }
        mediaFormat.setByteBuffer("csd-".concat(String.valueOf(n2)), byteBuffer);
    }

    private void createDummySurface() {
        this.mDummySurface = DummySurface.newInstanceV17(false);
    }

    @CalledByNative
    public int configure(int n2, int n3, int n4, int n5, int n6, String string, ByteBuffer byteBuffer, ByteBuffer byteBuffer2, ByteBuffer byteBuffer3, Surface surface, boolean bl, boolean bl2, int n7, int n8, boolean bl3, int n9, boolean bl4, boolean bl5, int n10, int n11) {
        q.d(TAG, "configure =" + surface + ", surfaceConfigure =" + bl);
        MediaFormat mediaFormat = new MediaFormat();
        mediaFormat.setString("mime", string);
        AJMediaCodec.maybeSetInteger(mediaFormat, "width", n2);
        AJMediaCodec.maybeSetInteger(mediaFormat, "height", n3);
        if (n7 != -1 && n8 != -1) {
            AJMediaCodec.maybeSetInteger(mediaFormat, "max-width", n7 > n2 ? n7 : n2);
            AJMediaCodec.maybeSetInteger(mediaFormat, "max-height", n8 > n3 ? n8 : n3);
        }
        AJMediaCodec.maybeSetInteger(mediaFormat, "sample-rate", n5);
        AJMediaCodec.maybeSetInteger(mediaFormat, "channel-count", n6);
        q.d(TAG, "format  = ".concat(String.valueOf(mediaFormat)));
        n2 = AJMediaCodec.getMaxInputSize(string, n2, n3);
        q.d(TAG, "max input = ".concat(String.valueOf(n2)));
        AJMediaCodec.maybeSetInteger(mediaFormat, "max-input-size", n2);
        AJMediaCodec.maybeSetCsdBuffers(mediaFormat, byteBuffer, 0);
        AJMediaCodec.maybeSetCsdBuffers(mediaFormat, byteBuffer2, 1);
        AJMediaCodec.maybeSetCsdBuffers(mediaFormat, byteBuffer3, 2);
        if (bl) {
            if (Util.SDK_INT >= 21) {
                AJMediaCodec.maybeSetInteger(mediaFormat, "rotation-degrees", n4);
            }
            if (!(surface != null && surface.isValid() || this.mDummySurface != null || Util.SDK_INT < 23 || mDeviceNeedsSetOutputSurfaceWorkaround)) {
                q.d(TAG, "create dummy surface");
                this.createDummySurface();
                surface = this.mDummySurface;
            }
            if (surface == null) {
                this.mExceptionInfo = "Error: configure with null surface";
                return -10003;
            }
        }
        if (Util.SDK_INT >= 23 && bl2) {
            mediaFormat.setInteger("priority", 0);
        }
        if (bl3) {
            VendorQTI.setupVpp(mediaFormat, n9);
        }
        if (bl4) {
            VendorQTI.debugEffect(mediaFormat);
        }
        if (bl5) {
            VendorQTI.enableLowLatency(mediaFormat);
        }
        if (n11 > 0 && n10 >= 0) {
            Pair<Integer, Integer> pair = MediaCodecUtil.getDolbyCodecs(n10, n11);
            String[] stringArray = pair.split("\\.");
            if ((pair = MediaCodecUtil.getDolbyVisionProfileAndLevel((String)pair, stringArray)) != null) {
                AJMediaCodec.maybeSetInteger(mediaFormat, "profile", (Integer)pair.first);
            }
        }
        try {
            this.mMediaCodec.configure(mediaFormat, surface, null, 0);
        }
        catch (Exception exception) {
            this.handleCodecException(exception);
            if (exception instanceof IllegalArgumentException) {
                return -10003;
            }
            return -1;
        }
        return 0;
    }

    @CalledByNative
    public int start() {
        q.d(TAG, "start");
        try {
            this.mMediaCodec.start();
            this.mInputBuffers = this.mMediaCodec.getInputBuffers();
            if (Util.SDK_INT >= 21) {
                this.mOutputBuffers = this.mMediaCodec.getOutputBuffers();
            }
            this.mInputBuffersValid = true;
            this.mBufferInfo = new MediaCodec.BufferInfo();
        }
        catch (Exception exception) {
            this.handleCodecException(exception);
            return -1;
        }
        q.d(TAG, "start end");
        return 0;
    }

    public int open(int n2, int n3, int n4, String string, String string2, ByteBuffer byteBuffer, Surface surface) {
        q.d(TAG, "open, rotation = " + n4 + "; codecName = " + string + "; codecType =" + string2);
        try {
            this.mMediaCodec = MediaCodec.createByCodecName((String)string);
        }
        catch (Exception exception) {
            return -1;
        }
        q.d(TAG, "configure mediacodec");
        string = new MediaFormat();
        string.setString("mime", string2);
        AJMediaCodec.maybeSetInteger((MediaFormat)string, "width", n2);
        AJMediaCodec.maybeSetInteger((MediaFormat)string, "height", n3);
        if (byteBuffer != null) {
            string.setByteBuffer("csd-0", byteBuffer);
        }
        if (surface != null && Util.SDK_INT >= 21) {
            AJMediaCodec.maybeSetInteger((MediaFormat)string, "rotation-degrees", n4);
        }
        try {
            this.mMediaCodec.configure((MediaFormat)string, surface, null, 0);
        }
        catch (Exception exception) {
            return -1;
        }
        q.d(TAG, "mediacodec start");
        try {
            this.mMediaCodec.start();
        }
        catch (Exception exception) {
            return -1;
        }
        this.mInputBuffers = this.mMediaCodec.getInputBuffers();
        this.mInputBuffersValid = true;
        String.format(Locale.US, "open() input params. width:%d,height:%d", n2, n3);
        return 0;
    }

    @CalledByNative
    public int stop() {
        if (this.mInputBuffersValid) {
            q.d(TAG, "stop");
            try {
                this.mInputBuffersValid = false;
                this.mMediaCodec.stop();
            }
            catch (Exception exception) {
                return -1;
            }
        }
        return 0;
    }

    private void releaseCodec(MediaCodec mediaCodec) {
        if (mediaCodec == null) {
            return;
        }
        try {
            mediaCodec.release();
            return;
        }
        catch (Exception exception) {
            return;
        }
        finally {
            if (this.mDummySurface != null) {
                this.mDummySurface.release();
                this.mDummySurface = null;
            }
            q.d(TAG, "codec release end");
        }
    }

    @CalledByNative
    public void close() {
        q.d(TAG, "close start");
        if (this.mMediaCodec != null) {
            this.stop();
            final MediaCodec mediaCodec = this.mMediaCodec;
            this.mInputBuffers = null;
            this.mOutputBuffers = null;
            this.mMediaCodec = null;
            try {
                AVThreadPool.addTask(new Runnable(){

                    @Override
                    public void run() {
                        q.d(AJMediaCodec.TAG, "start releaseCodec task");
                        AJMediaCodec.this.releaseCodec(mediaCodec);
                    }
                });
            }
            catch (Throwable throwable) {
                q.j(TAG, "new thread failed");
                this.releaseCodec(mediaCodec);
            }
        }
        q.d(TAG, "close end");
    }

    @TargetApi(value=21)
    private int renderOutputBufferV21(int n2, long l2) {
        try {
            this.mMediaCodec.releaseOutputBuffer(n2, l2);
        }
        catch (Exception exception) {
            return -10000;
        }
        return 0;
    }

    @TargetApi(value=21)
    public int handleCodecExceptionV21(Exception exception) {
        if (exception instanceof MediaCodec.CodecException) {
            MediaCodec.CodecException codecException = (MediaCodec.CodecException)exception;
            if (Util.SDK_INT >= 23) {
                codecException.isRecoverable();
                codecException.getErrorCode();
                if (!codecException.isRecoverable() && codecException.getErrorCode() != 1100 && codecException.getErrorCode() != 1101) {
                    return -10001;
                }
            } else {
                codecException.isRecoverable();
                if (!codecException.isRecoverable()) {
                    return -10001;
                }
            }
        }
        if (exception instanceof IllegalStateException) {
            return -10002;
        }
        return -10000;
    }

    public int handleCodecException(Exception exception) {
        this.mExceptionInfo = exception.toString();
        if (Util.SDK_INT >= 21) {
            return this.handleCodecExceptionV21(exception);
        }
        if (exception instanceof IllegalStateException) {
            return -10002;
        }
        return -10000;
    }

    @CalledByNative
    public int dequeueInputBuffer(long l2) {
        try {
            return this.mMediaCodec.dequeueInputBuffer(l2);
        }
        catch (Exception exception) {
            return this.handleCodecException(exception);
        }
    }

    @CalledByNative
    public ByteBuffer[] getInputBuffers() {
        if (this.mInputBuffersValid) {
            return this.mInputBuffers;
        }
        return null;
    }

    @CalledByNative
    public int queueInputBuffer(int n2, int n3, int n4, long l2, int n5) {
        try {
            this.mMediaCodec.queueInputBuffer(n2, n3, n4, l2, n5);
        }
        catch (Exception exception) {
            return this.handleCodecException(exception);
        }
        return 0;
    }

    @CalledByNative
    public int setOutputSurface(Surface surface) {
        if (!mDeviceNeedsSetOutputSurfaceWorkaround && this.mInputBuffersValid) {
            if (surface == null) {
                if (this.mDummySurface == null) {
                    this.createDummySurface();
                }
                surface = this.mDummySurface;
                q.d(TAG, "use dummy surface");
            }
            AJMediaCodec aJMediaCodec = this;
            return aJMediaCodec.setOutputSurfaceV23(aJMediaCodec.mMediaCodec, surface);
        }
        return -1;
    }

    @CalledByNative
    public int write(AJMediaCodecFrame aJMediaCodecFrame) {
        if (aJMediaCodecFrame == null || aJMediaCodecFrame.data == null) {
            return -1;
        }
        try {
            int n2 = this.mMediaCodec.dequeueInputBuffer(30000L);
            if (n2 >= 0) {
                this.mInputBuffers[n2].put(aJMediaCodecFrame.data);
                this.mMediaCodec.queueInputBuffer(n2, 0, aJMediaCodecFrame.size, aJMediaCodecFrame.pts, 0);
                return 0;
            }
            if (n2 == -1) {
                return 4;
            }
            return -1;
        }
        catch (Exception exception) {
            q.t(TAG, "write meet exception =".concat(String.valueOf(exception)));
            return -1;
        }
    }

    @CalledByNative
    public int read(AJMediaCodecFrame aJMediaCodecFrame, long l2) {
        int n2;
        while (true) {
            try {
                n2 = this.mMediaCodec.dequeueOutputBuffer(this.mBufferInfo, l2);
            }
            catch (Exception exception) {
                q.d(TAG, "dequeueOutputBuffer e :".concat(String.valueOf(exception)));
                return this.handleCodecException(exception);
            }
            if (n2 >= 0) {
                ByteBuffer byteBuffer;
                aJMediaCodecFrame.data = byteBuffer = this.mOutputBuffers[n2];
                aJMediaCodecFrame.pts = this.mBufferInfo.presentationTimeUs;
                aJMediaCodecFrame.index = n2;
                aJMediaCodecFrame.size = this.mBufferInfo.size;
                aJMediaCodecFrame.flags = this.mBufferInfo.flags;
                return 0;
            }
            if (n2 != -3) break;
            q.d(TAG, "INFO_OUTPUT_BUFFERS_CHANGED");
            try {
                this.mOutputBuffers = this.mMediaCodec.getOutputBuffers();
            }
            catch (Exception exception) {
                q.d(TAG, "getOutputBuffers e = ".concat(String.valueOf(exception)));
                return this.handleCodecException(exception);
            }
        }
        if (n2 == -2) {
            q.d(TAG, "INFO_OUTPUT_FORMAT_CHANGED");
            try {
                this.mOutputMediaFormat = this.mMediaCodec.getOutputFormat();
            }
            catch (Exception exception) {
                q.d(TAG, "getOutputFormat e =".concat(String.valueOf(exception)));
                return this.handleCodecException(exception);
            }
            if (this.mOutputBuffers == null) {
                try {
                    this.mOutputBuffers = this.mMediaCodec.getOutputBuffers();
                }
                catch (Exception exception) {
                    q.d(TAG, "getOutputBuffers e = ".concat(String.valueOf(exception)));
                    return this.handleCodecException(exception);
                }
            }
            return n2;
        }
        if (n2 != -1) {
            q.t(TAG, "error, idx = ".concat(String.valueOf(n2)));
        }
        return -1;
    }

    @CalledByNative
    public void flush() {
        q.d(TAG, "flush");
        try {
            this.mMediaCodec.flush();
        }
        catch (Exception exception) {}
        q.d(TAG, "flush done");
    }

    @CalledByNative
    public int releaseBuffer(int n2, boolean bl, long l2) {
        if (Util.SDK_INT >= 21 && bl) {
            return this.renderOutputBufferV21(n2, l2);
        }
        try {
            this.mMediaCodec.releaseOutputBuffer(n2, bl);
        }
        catch (Exception exception) {
            return this.handleCodecException(exception);
        }
        return 0;
    }

    @CalledByNative
    public int getFormatWidth() {
        if (this.mOutputMediaFormat != null) {
            try {
                if (this.mOutputMediaFormat.containsKey(KEY_CROP_RIGHT) && this.mOutputMediaFormat.containsKey(KEY_CROP_LEFT) && this.mOutputMediaFormat.containsKey(KEY_CROP_BOTTOM) && this.mOutputMediaFormat.containsKey(KEY_CROP_TOP)) {
                    return this.mOutputMediaFormat.getInteger(KEY_CROP_RIGHT) - this.mOutputMediaFormat.getInteger(KEY_CROP_LEFT) + 1;
                }
                return this.mOutputMediaFormat.getInteger("width");
            }
            catch (Exception exception) {
                return 0;
            }
        }
        return 0;
    }

    @CalledByNative
    public int getFormatHeight() {
        if (this.mOutputMediaFormat != null) {
            try {
                if (this.mOutputMediaFormat.containsKey(KEY_CROP_RIGHT) && this.mOutputMediaFormat.containsKey(KEY_CROP_LEFT) && this.mOutputMediaFormat.containsKey(KEY_CROP_BOTTOM) && this.mOutputMediaFormat.containsKey(KEY_CROP_TOP)) {
                    return this.mOutputMediaFormat.getInteger(KEY_CROP_BOTTOM) - this.mOutputMediaFormat.getInteger(KEY_CROP_TOP) + 1;
                }
                return this.mOutputMediaFormat.getInteger("height");
            }
            catch (Exception exception) {
                return 0;
            }
        }
        return 0;
    }

    @CalledByNative
    public int getStride() {
        if (this.mOutputMediaFormat != null) {
            try {
                return this.mOutputMediaFormat.getInteger("stride");
            }
            catch (Exception exception) {
                return 0;
            }
        }
        return 0;
    }

    @CalledByNative
    public int getSliceHeight() {
        if (this.mOutputMediaFormat != null) {
            try {
                return this.mOutputMediaFormat.getInteger("slice-height");
            }
            catch (Exception exception) {
                return 0;
            }
        }
        return 0;
    }

    @CalledByNative
    public int getSampleRate() {
        if (this.mOutputMediaFormat != null) {
            try {
                return this.mOutputMediaFormat.getInteger("sample-rate");
            }
            catch (Exception exception) {
                return 0;
            }
        }
        return 0;
    }

    @CalledByNative
    public int getChannelCount() {
        if (this.mOutputMediaFormat != null) {
            try {
                return this.mOutputMediaFormat.getInteger("channel-count");
            }
            catch (Exception exception) {
                return 0;
            }
        }
        return 0;
    }

    @CalledByNative
    public int getColorFormat() {
        if (this.mOutputMediaFormat != null) {
            try {
                switch (this.mOutputMediaFormat.getInteger("color-format")) {
                    case 21: 
                    case 2130706688: 
                    case 2141391872: {
                        return 3;
                    }
                }
                return 0;
            }
            catch (Exception exception) {
                return 0;
            }
        }
        return 0;
    }

    @CalledByNative
    public int getColorTransfer() {
        if (this.mOutputMediaFormat != null) {
            try {
                switch (this.mOutputMediaFormat.getInteger("color-transfer")) {
                    case 6: {
                        return 16;
                    }
                    case 7: {
                        return 18;
                    }
                }
                return 0;
            }
            catch (Exception exception) {
                return 0;
            }
        }
        return 0;
    }

    @CalledByNative
    public int getOSVerion() {
        return Util.SDK_INT;
    }

    @TargetApi(value=23)
    @CalledByNative
    public void speedEnhance(float f2) {
        if (this.mMediaCodec != null && this.mInputBuffersValid && Util.SDK_INT >= 23 && f2 > 30.0f) {
            q.d(TAG, "rate ".concat(String.valueOf(f2)));
            Bundle bundle = new Bundle();
            bundle.putFloat("operating-rate", f2);
            try {
                this.mMediaCodec.setParameters(bundle);
                return;
            }
            catch (Exception exception) {
                q.j(TAG, "setParameters failed ret = ".concat(String.valueOf(exception)));
            }
        }
    }

    @TargetApi(value=23)
    @CalledByNative
    public void decodeFRC(int n2) {
        if (this.mMediaCodec != null && this.mInputBuffersValid && Util.SDK_INT >= 23) {
            q.d(TAG, "frc level = ".concat(String.valueOf(n2)));
            Bundle bundle = new Bundle();
            bundle.putInt("vivo.video-dec.dynamic-frc", n2);
            try {
                this.mMediaCodec.setParameters(bundle);
                return;
            }
            catch (Exception exception) {
                q.j(TAG, "setParameters failed ret = ".concat(String.valueOf(exception)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    public String getBestCodecName(String string) {
        if (Util.SDK_INT < 16) {
            return null;
        }
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        if (string.equals("video/hevc") && mIsByteVC1Blocklist) {
            q.j(TAG, "the device is hw decoder blocklist," + Util.HARDWARE);
            return null;
        }
        q.d(TAG, "detect hardware codec by codecType = ".concat(String.valueOf(string)));
        boolean bl = false;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object object = mCodecListLock;
        synchronized (object) {
            int n2;
            if (!mVideoHWDecoderCodecs.isEmpty()) {
                bl = true;
            }
            try {
                n2 = bl ? mVideoHWDecoderCodecs.size() : MediaCodecList.getCodecCount();
            }
            catch (Exception exception) {
                q.j(TAG, "mediaserver died");
                return null;
            }
            for (int i2 = 0; i2 < n2 && (!bl || arrayList.isEmpty()); ++i2) {
                String[] stringArray;
                MediaCodecInfo mediaCodecInfo = bl ? mVideoHWDecoderCodecs.get(i2) : MediaCodecList.getCodecInfoAt((int)i2);
                Object object2 = mediaCodecInfo.getName();
                if (mediaCodecInfo.isEncoder() || ((String)object2).startsWith("OMX.google") || ((String)object2).startsWith("c2.android") || (stringArray = mediaCodecInfo.getSupportedTypes()) == null) continue;
                int n3 = stringArray.length;
                for (int i3 = 0; i3 < n3; ++i3) {
                    Object object3 = stringArray[i3];
                    if (TextUtils.isEmpty((CharSequence)object3)) continue;
                    if (!bl && ((String)object3).startsWith("video/")) {
                        mVideoHWDecoderCodecs.add(mediaCodecInfo);
                    }
                    if (!((String)object3).equalsIgnoreCase(string) || !((String)object2).startsWith("OMX.") && !((String)object2).startsWith("c2.") || ((String)object2).startsWith("OMX.pv") || ((String)object2).startsWith("OMX.ittiam") || ((String)object2).contains("ffmpeg") || ((String)object2).contains("avcodec") || ((String)object2).contains("secure") || ((String)object2).startsWith("OMX.MTK.") && Util.SDK_INT < 18 || AJMediaCodec.codecNeedsFlushWorkaround((String)object2) || (object3 = AJMediaCodecRank.setupRank(mediaCodecInfo, string)) == null) continue;
                    q.d(TAG, "codec : " + ((AJMediaCodecRank)object3).mMediaCodecInfo.getName() + ",  rank : " + ((AJMediaCodecRank)object3).mRank);
                    if (((AJMediaCodecRank)object3).mRank == 40 && Util.SDK_INT < 21) {
                        q.j(TAG, "skip vendor mediacodec api impl ambiguous");
                        continue;
                    }
                    if (((AJMediaCodecRank)object3).mRank == 20) {
                        q.j(TAG, "skip vendor software codec");
                        continue;
                    }
                    arrayList.add(object3);
                }
            }
            if (arrayList.isEmpty()) {
                return null;
            }
            Object object4 = (AJMediaCodecRank)arrayList.get(0);
            for (Object object2 : arrayList) {
                if (((AJMediaCodecRank)object2).mRank <= ((AJMediaCodecRank)object4).mRank) continue;
                object4 = object2;
            }
            return ((AJMediaCodecRank)object4).mMediaCodecInfo.getName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static boolean codecNeedsSetOutputSurfaceWorkaround() {
        var0 = AJMediaCodec.class;
        synchronized (AJMediaCodec.class) {
            block20: {
                block21: {
                    if (AJMediaCodec.mEvaluatedDeviceNeedsSetOutputSurfaceWorkaround) break block20;
                    if (Util.SDK_INT <= 27 && "dangal".equals(Util.DEVICE)) ** GOTO lbl-1000
                    if (Util.SDK_INT >= 27) break block21;
                    var1_1 = Util.DEVICE;
                    var2_3 = -1;
                    switch (var1_1.hashCode()) {
                        case 99329: {
                            if (!var1_1.equals("deb")) break;
                            var2_3 = 0;
                            break;
                        }
                        case 0x332327: {
                            if (!var1_1.equals("mido")) break;
                            var2_3 = 1;
                            break;
                        }
                        case 1865889110: {
                            if (!var1_1.equals("santoni")) break;
                            var2_3 = 2;
                        }
                    }
                    switch (var2_3) {
                        case 0: 
                        case 1: 
                        case 2: {
                            AJMediaCodec.mDeviceNeedsSetOutputSurfaceWorkaround = true;
                        }
                    }
                    var1_1 = Util.MODEL;
                    var2_3 = -1;
                    switch (var1_1.hashCode()) {
                        case 2006354: {
                            if (!var1_1.equals("AFTA")) break;
                            var2_3 = 0;
                            break;
                        }
                        case 2006367: {
                            if (!var1_1.equals("AFTN")) break;
                            var2_3 = 1;
                        }
                    }
                    switch (var2_3) {
                        case 0: 
                        case 1: lbl-1000:
                        // 2 sources

                        {
                            AJMediaCodec.mDeviceNeedsSetOutputSurfaceWorkaround = true;
                        }
                    }
                }
                AJMediaCodec.mEvaluatedDeviceNeedsSetOutputSurfaceWorkaround = true;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return AJMediaCodec.mDeviceNeedsSetOutputSurfaceWorkaround;
        }
    }

    @TargetApi(value=23)
    private int setOutputSurfaceV23(MediaCodec mediaCodec, Surface surface) {
        try {
            mediaCodec.setOutputSurface(surface);
        }
        catch (Exception exception) {
            this.handleCodecException(exception);
            q.j(TAG, "setoutputsurface failed = ".concat(String.valueOf(exception)));
            return -1;
        }
        return 0;
    }

    public static int ceilDivide(int n2, int n3) {
        return (n2 + n3 - 1) / n3;
    }

    private static int getMaxInputSize(String string, int n2, int n3) {
        int n4;
        if (n2 == -1 || n3 == -1) {
            return -1;
        }
        if (string.equals("video/3gpp") || string.equals("video/mp4v-es")) {
            n4 = n2 * n3;
            n2 = 2;
        } else if (string.equals("video/avc")) {
            if ("BRAVIA 4K 2015".equals(Util.MODEL)) {
                return -1;
            }
            n4 = AJMediaCodec.ceilDivide(n2, 16) * AJMediaCodec.ceilDivide(n3, 16) * 16 * 16;
            n2 = 2;
        } else if (string.equals("video/x-vnd.on2.vp8")) {
            n4 = n2 * n3;
            n2 = 2;
        } else if (string.equals("video/hevc") || string.equals("video/x-vnd.on2.vp9")) {
            n4 = n2 * n3;
            n2 = 4;
        } else {
            return -1;
        }
        return n4 * 3 / (2 * n2);
    }

    private static boolean codecNeedsFlushWorkaround(String string) {
        return Util.SDK_INT < 18 || Util.SDK_INT == 18 && ("OMX.SEC.avc.dec".equals(string) || "OMX.SEC.avc.dec.secure".equals(string)) || Util.SDK_INT == 19 && Util.MODEL.startsWith("SM-G800") && ("OMX.Exynos.avc.dec".equals(string) || "OMX.Exynos.avc.dec.secure".equals(string));
    }
}

