/*
 * Decompiled with CFR 0.152.
 */
package com.bykv.vk.component.ttvideo.utils;

import android.content.Context;
import android.os.Build;
import android.os.Environment;
import android.os.Process;
import android.os.StatFs;
import com.bytedance.sdk.component.utils.q;
import com.bytedance.sdk.openadsdk.api.plugin.j;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Locale;

public class HardWareInfo {
    public static final int CPU_FAMILY_UNKNOWN = 0;
    public static final int CPU_FAMILY_ARM = 1;
    public static final int CPU_FAMILY_X86 = 2;
    public static final int CPU_FAMILY_MIPS = 3;
    private static int mCpuType = 0;
    private static int[] mArmArchitecture = new int[3];
    private static final int NEON = 0;
    private static final int ATOM = 1;

    public static int[] getCpuInfo() {
        try {
            FileInputStream fileInputStream = new FileInputStream("/proc/cpuinfo");
            InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            try {
                Object object;
                String string = "processor";
                String string2 = "features";
                String string3 = "model name";
                while ((object = bufferedReader.readLine()) != null) {
                    if (((String[])(object = ((String)object).replaceAll("\t", "").toLowerCase(Locale.US).split(":"))).length != 2) continue;
                    String string4 = object[0].trim();
                    if ((object = object[1].trim()) == null || string4 == null) continue;
                    if (string4.compareTo(string) == 0) {
                        if (((String)object).contains("armv") || ((String)object).contains("aarch64")) {
                            HardWareInfo.mArmArchitecture[0] = 1;
                        } else {
                            if (!((String)object).contains("intel")) continue;
                            HardWareInfo.mArmArchitecture[0] = 2;
                        }
                    } else {
                        if (string4.compareToIgnoreCase(string2) == 0) {
                            if (!((String)object).contains("neon") && !((String)object).contains("thumb") && !((String)object).contains("vfpv") && !((String)object).contains("asimd") && !((String)object).contains("simd")) continue;
                            HardWareInfo.mArmArchitecture[0] = 1;
                            continue;
                        }
                        if (string4.compareToIgnoreCase(string3) != 0) continue;
                        if (((String)object).contains("intel")) {
                            HardWareInfo.mArmArchitecture[0] = 2;
                        } else {
                            if (!((String)object).contains("arm")) continue;
                            HardWareInfo.mArmArchitecture[0] = 1;
                        }
                    }
                    break;
                }
            }
            finally {
                bufferedReader.close();
                inputStreamReader.close();
                ((InputStream)fileInputStream).close();
            }
        }
        catch (Exception exception) {
            q.d(exception);
        }
        return mArmArchitecture;
    }

    public static int[] getCpuArchitecture() {
        try {
            FileInputStream fileInputStream = new FileInputStream("/proc/cpuinfo");
            InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            try {
                Object object;
                String string = "Processor";
                String string2 = "Features";
                String string3 = "model name";
                String string4 = "cpu family";
                while ((object = bufferedReader.readLine()) != null) {
                    if (((String[])(object = ((String)object).replace("\t", "").split(":"))).length != 2) continue;
                    CharSequence charSequence = object[0].trim();
                    object = object[1].trim();
                    if (((String)charSequence).compareTo(string) == 0) {
                        String string5;
                        charSequence = new StringBuilder();
                        for (int i2 = ((String)object).indexOf("ARMv") + 4; i2 < ((String)object).length() && (string5 = "" + ((String)object).charAt(i2)).matches("\\d"); ++i2) {
                            ((StringBuilder)charSequence).append(string5);
                        }
                        HardWareInfo.mArmArchitecture[0] = 1;
                        HardWareInfo.mArmArchitecture[1] = Integer.parseInt(((StringBuilder)charSequence).toString());
                        continue;
                    }
                    if (((String)charSequence).compareToIgnoreCase(string2) == 0) {
                        if (!((String)object).contains("neon")) continue;
                        HardWareInfo.mArmArchitecture[2] = 0;
                        continue;
                    }
                    if (((String)charSequence).compareToIgnoreCase(string3) == 0) {
                        if (!((String)object).contains("Intel")) continue;
                        HardWareInfo.mArmArchitecture[0] = 2;
                        HardWareInfo.mArmArchitecture[2] = 1;
                        continue;
                    }
                    if (((String)charSequence).compareToIgnoreCase(string4) != 0) continue;
                    HardWareInfo.mArmArchitecture[1] = Integer.parseInt((String)object);
                }
            }
            finally {
                bufferedReader.close();
                inputStreamReader.close();
                ((InputStream)fileInputStream).close();
            }
        }
        catch (Exception exception) {
            q.d(exception);
        }
        return mArmArchitecture;
    }

    private static boolean isAndroidJB2() {
        return Build.VERSION.SDK_INT >= 18;
    }

    private static long getDirectoryAvailableSize(String string) {
        try {
            long l2;
            long l3;
            string = new StatFs(string);
            if (HardWareInfo.isAndroidJB2()) {
                l3 = string.getBlockSizeLong();
                l2 = string.getAvailableBlocksLong();
            } else {
                l3 = string.getBlockSize();
                l2 = string.getAvailableBlocks();
            }
            return l3 * l2;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return -1L;
        }
    }

    private static long getDirectoryTotalSize(String string) {
        try {
            long l2;
            long l3;
            string = new StatFs(string);
            if (HardWareInfo.isAndroidJB2()) {
                l3 = string.getBlockSizeLong();
                l2 = string.getBlockCountLong();
            } else {
                l3 = string.getBlockSize();
                l2 = string.getBlockCount();
            }
            return l3 * l2;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return -1L;
        }
    }

    private static long getTotalStorageSize(Context context) {
        if (context == null) {
            return -1L;
        }
        if (Environment.getDataDirectory() != null) {
            return HardWareInfo.getDirectoryTotalSize(j.d(context).getParent());
        }
        return -1L;
    }

    private static long getAvailableStorageSize(Context context) {
        if (context == null) {
            return -1L;
        }
        if (Environment.getDataDirectory() != null) {
            return HardWareInfo.getDirectoryAvailableSize(j.d(context).getParent());
        }
        return -1L;
    }

    public static long[] getSDCardSize(Context context) {
        long[] lArray = new long[2];
        String string = Environment.getExternalStorageState();
        if ("mounted".equals(string)) {
            long l2;
            long l3 = HardWareInfo.getAvailableStorageSize(context);
            lArray[0] = l2 = HardWareInfo.getTotalStorageSize(context);
            lArray[1] = l3;
        }
        return lArray;
    }

    /*
     * Loose catch block
     */
    public static long getProcessCpuInfo() {
        long l2;
        String[] stringArray;
        block13: {
            BufferedReader bufferedReader = null;
            int n2 = Process.myPid();
            bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream("/proc/" + n2 + "/stat")), 1000);
            String string = bufferedReader.readLine();
            bufferedReader.close();
            stringArray = string.split(" ");
            try {
                bufferedReader.close();
            }
            catch (Exception exception) {
                q.d(exception);
            }
            break block13;
            catch (IOException iOException) {
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (Exception exception) {
                    q.d(exception);
                }
                return 0L;
            }
            catch (Throwable throwable) {
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (Exception exception) {
                    q.d(exception);
                }
                throw throwable;
            }
        }
        try {
            l2 = Long.parseLong(stringArray[13]) + Long.parseLong(stringArray[14]) + Long.parseLong(stringArray[15]) + Long.parseLong(stringArray[16]);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return 0L;
        }
        return l2;
    }

    public static int getCpuFamily() {
        if (mCpuType == 0) {
            HardWareInfo.getCpuInfo();
            mCpuType = mArmArchitecture[0];
        }
        return mCpuType;
    }
}

