/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.android.openliveplugin.process;

import android.app.ActivityManager;
import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.os.Process;
import android.text.TextUtils;
import com.bytedance.sdk.openadsdk.api.wc;
import java.lang.reflect.Method;

public class LiveProcessUtils {
    private static String currentProcessName;

    public static Boolean inLiveProcess(Context context) {
        if (context == null || context.getApplicationContext() == null) {
            return Boolean.FALSE;
        }
        return LiveProcessUtils.getCurrentProcessName(context).endsWith(":bytelive");
    }

    public static boolean isMainProcess(Context object) {
        if (object == null || object.getApplicationContext() == null) {
            return false;
        }
        String string = object.getApplicationContext().getPackageName();
        object = LiveProcessUtils.getCurrentProcessName(object);
        return TextUtils.equals((CharSequence)string, (CharSequence)object);
    }

    public static String getCurrentProcessName(Context context) {
        if (!TextUtils.isEmpty((CharSequence)currentProcessName)) {
            return currentProcessName;
        }
        currentProcessName = LiveProcessUtils.getCurrentProcessNameByApplication();
        if (!TextUtils.isEmpty((CharSequence)currentProcessName)) {
            return currentProcessName;
        }
        currentProcessName = LiveProcessUtils.getCurrentProcessNameByActivityThread();
        if (!TextUtils.isEmpty((CharSequence)currentProcessName)) {
            return currentProcessName;
        }
        currentProcessName = LiveProcessUtils.getCurrentProcessNameByActivityManager(context);
        return currentProcessName;
    }

    private static String getCurrentProcessNameByApplication() {
        if (Build.VERSION.SDK_INT >= 28) {
            try {
                return Application.getProcessName();
            }
            catch (Exception exception) {
                wc.d(exception);
            }
        }
        return null;
    }

    private static String getCurrentProcessNameByActivityThread() {
        String string = null;
        try {
            Object object = Class.forName("android.app.ActivityThread", false, Application.class.getClassLoader()).getDeclaredMethod("currentProcessName", new Class[0]);
            ((Method)object).setAccessible(true);
            object = ((Method)object).invoke(null, new Object[0]);
            if (object instanceof String) {
                string = (String)object;
            }
        }
        catch (Throwable throwable) {
            wc.d(throwable);
        }
        return string;
    }

    private static String getCurrentProcessNameByActivityManager(Context object) {
        if (object == null) {
            return null;
        }
        int n2 = Process.myPid();
        if ((object = (ActivityManager)object.getSystemService("activity")) != null && (object = object.getRunningAppProcesses()) != null) {
            object = object.iterator();
            while (object.hasNext()) {
                ActivityManager.RunningAppProcessInfo runningAppProcessInfo = (ActivityManager.RunningAppProcessInfo)object.next();
                if (runningAppProcessInfo.pid != n2) continue;
                return runningAppProcessInfo.processName;
            }
        }
        return null;
    }
}

