/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.pangle.provider;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.pm.ProviderInfo;
import android.content.res.XmlResourceParser;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.CancellationSignal;
import android.support.annotation.Keep;
import android.support.annotation.RequiresApi;
import android.text.TextUtils;
import com.bytedance.pangle.FileProvider;
import com.bytedance.pangle.GlobalParam;
import com.bytedance.pangle.Zeus;
import com.bytedance.pangle.log.ZeusLogger;
import com.bytedance.pangle.nc.t;
import com.bytedance.pangle.plugin.Plugin;
import com.bytedance.pangle.provider.PluginContentProvider;
import com.bytedance.pangle.provider.a;
import com.bytedance.pangle.transform.ZeusTransformUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@Keep
public class ContentProviderManager {
    public static final String PLUGIN_PROCESS_NAME = "process_name";
    public static final String PLUGIN_PKG_NAME = "plugin_pkg_name";
    public static final String PROVIDER_URI = "uri";
    public static final String PROVIDER_PARAM_FEILD = "provider_params";
    public static final String PROVIDER_PLUGIN_AUTHORITY = "provider_params";
    public static final String PROVIDER_PROXY_URI = "provider_proxy_uri";
    private final Map<j, d> mContentProviderMap = new HashMap<j, d>();
    private final Map<String, String> mAuthorityProcessNameMap = new HashMap<String, String>();
    private final Map<String, pl> mSystemProviderInfoMap = new HashMap<String, pl>();
    private static ContentProviderManager sInstance = null;

    private ContentProviderManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ContentProviderManager getInstance() {
        if (sInstance != null) return sInstance;
        Class<ContentProviderManager> clazz = ContentProviderManager.class;
        synchronized (ContentProviderManager.class) {
            if (sInstance != null) return sInstance;
            sInstance = new ContentProviderManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    public Map<String, pl> getSystemProviderInfoMap() {
        return this.mSystemProviderInfoMap;
    }

    public String getPluginProcessNameByAuthority(String string) {
        return this.mAuthorityProcessNameMap.get(string);
    }

    @RequiresApi(api=16)
    public Cursor query(ContentResolver contentResolver, Uri uri, String[] stringArray, String string, String[] stringArray2, String string2, CancellationSignal cancellationSignal, String string3) {
        return a.a(contentResolver, uri, stringArray, string, stringArray2, string2, cancellationSignal, string3);
    }

    public Cursor query(ContentResolver contentResolver, Uri uri, String[] stringArray, String string, String[] stringArray2, String string2, String string3) {
        return a.a(contentResolver, uri, stringArray, string, stringArray2, string2, string3);
    }

    @RequiresApi(api=26)
    public Cursor query(ContentResolver contentResolver, Uri uri, String[] stringArray, Bundle bundle, CancellationSignal cancellationSignal, String string) {
        return a.a(contentResolver, uri, stringArray, bundle, cancellationSignal, string);
    }

    public String getType(ContentResolver contentResolver, Uri uri, String string) {
        return a.a(contentResolver, uri, string);
    }

    public Uri insert(ContentResolver contentResolver, Uri uri, ContentValues contentValues, String string) {
        return a.a(contentResolver, uri, contentValues, string);
    }

    public Uri insert(ContentResolver contentResolver, Uri uri, ContentValues contentValues, Bundle bundle, String string) {
        return a.a(contentResolver, uri, contentValues, bundle, string);
    }

    public int delete(ContentResolver contentResolver, Uri uri, String string, String[] stringArray, String string2) {
        return a.a(contentResolver, uri, string, stringArray, string2);
    }

    public int delete(ContentResolver contentResolver, Uri uri, Bundle bundle, String string) {
        return a.a(contentResolver, uri, bundle, string);
    }

    public int update(ContentResolver contentResolver, Uri uri, ContentValues contentValues, String string, String[] stringArray, String string2) {
        return a.a(contentResolver, uri, contentValues, string, stringArray, string2);
    }

    public int update(ContentResolver contentResolver, Uri uri, ContentValues contentValues, Bundle bundle, String string) {
        return a.b(contentResolver, uri, contentValues, bundle, string);
    }

    public Bundle call(ContentResolver contentResolver, Uri uri, String string, String string2, Bundle bundle, String string3) {
        return a.a(contentResolver, uri, string, string2, bundle, string3);
    }

    public final Bundle call(ContentResolver contentResolver, String string, String string2, String string3, Bundle bundle, String string4) {
        return a.a(contentResolver, string, string2, string3, bundle, string4);
    }

    protected boolean isPluginProvider(Uri object) {
        if (object == null) {
            return true;
        }
        object = object.getAuthority();
        Set<String> set = this.mAuthorityProcessNameMap.keySet();
        return set != null && set.contains(object);
    }

    public PluginContentProvider getPluginProvider(j object) {
        if ((object = this.mContentProviderMap.get(object)) == null) {
            return null;
        }
        return ((d)object).pl;
    }

    public void installContentProviders(Collection<ProviderInfo> object, Plugin plugin) {
        if (object == null || object.size() == 0 || plugin == null) {
            return;
        }
        String string = t.d(t.d((Context)Zeus.getAppApplication()));
        object = object.iterator();
        while (object.hasNext()) {
            ProviderInfo providerInfo = (ProviderInfo)object.next();
            if (ZeusLogger.isDebug()) {
                StringBuilder stringBuilder = new StringBuilder(128);
                stringBuilder.append("Install plugin provider [authority:");
                stringBuilder.append(providerInfo.authority);
                stringBuilder.append("] - [className:");
                stringBuilder.append(providerInfo.name).append("]");
                ZeusLogger.v("Zeus/provider_pangle", stringBuilder.toString());
            }
            this.installProvider(string, providerInfo, plugin);
        }
    }

    private void installProvider(String object, ProviderInfo providerInfo, Plugin object2) {
        if (providerInfo == null) {
            ZeusLogger.w("Zeus/provider_pangle", "ProviderInfo is null !! can not install plugin provider \uff0c plugin-mPkgName\uff1a\u3010" + ((Plugin)object2).mPkgName + "\u3011");
            return;
        }
        if (TextUtils.equals((CharSequence)object, (CharSequence)providerInfo.processName)) {
            ZeusLogger.v("Zeus/provider_pangle", "Start install plugin provider [authority:" + providerInfo.authority + "] [className:" + providerInfo.name + "]");
            try {
                object = this.instantiateProvider((Plugin)object2, providerInfo);
                if (object == null) {
                    return;
                }
                object.attachInfo(ZeusTransformUtils.wrapperContext((Object)((Plugin)object2).mHostApplication, ((Plugin)object2).mPkgName), providerInfo);
                ZeusLogger.v("Zeus/provider_pangle", "Install plugin provider finish and invoke plugin provider attachInfo(onCreate) method finish [className:" + providerInfo.name + "]");
            }
            catch (Exception exception) {
                ZeusLogger.w("Zeus/provider_pangle", "Instantiating Exception : ", exception);
                return;
            }
            object2 = new j(providerInfo.packageName, providerInfo.processName, providerInfo.authority);
            object = new d((j)object2, providerInfo, (PluginContentProvider)((Object)object));
            this.mContentProviderMap.put((j)object2, (d)object);
        }
        this.mAuthorityProcessNameMap.put(providerInfo.authority, providerInfo.processName);
    }

    private PluginContentProvider instantiateProvider(Plugin plugin, ProviderInfo providerInfo) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Object t2 = plugin.mClassLoader.loadClass(providerInfo.name).newInstance();
        if (t2 instanceof android.support.v4.content.FileProvider) {
            if (providerInfo.metaData == null) {
                throw new IllegalArgumentException("Missing android.support.FILE_PROVIDER_PATHS meta-data. provider:".concat(String.valueOf(t2)));
            }
            providerInfo = plugin.mResources.getXml(providerInfo.metaData.getInt("android.support.FILE_PROVIDER_PATHS"));
            FileProvider.d(plugin, (XmlResourceParser)providerInfo);
            return null;
        }
        return (PluginContentProvider)((Object)t2);
    }

    public void initSystemContentProviderInfo() {
        GlobalParam.getInstance().getReporter().saveRecord("zeus_stage_content_provider", "start");
        try {
            ProviderInfo[] providerInfoArray = Zeus.getAppApplication().getPackageManager().getPackageInfo((String)Zeus.getAppApplication().getPackageName(), (int)8).providers;
            if (Zeus.getAppApplication().getPackageManager().getPackageInfo((String)Zeus.getAppApplication().getPackageName(), (int)8).providers != null && providerInfoArray.length != 0) {
                for (ProviderInfo providerInfo : providerInfoArray) {
                    if (providerInfo == null || providerInfo.authority == null || !providerInfo.authority.contains(".pangle.provider.proxy.")) continue;
                    try {
                        ZeusLogger.d("Zeus/provider_pangle", "Need to init system provider info start [packageNam:=" + providerInfo.packageName + "],[processName=" + providerInfo.processName + "],[authority:" + providerInfo.authority + "]");
                        if (!providerInfo.authority.contains(Zeus.getAppApplication().getPackageName() + ".pangle.provider.proxy.")) continue;
                        String string = t.d(providerInfo.processName);
                        pl pl2 = new pl(Zeus.getAppApplication().getPackageName(), string, providerInfo);
                        this.mSystemProviderInfoMap.put(string, pl2);
                        ZeusLogger.d("Zeus/provider_pangle", "Init system provider info finish [packageNam:=" + providerInfo.packageName + "],[processName=" + providerInfo.processName + "],[authority:" + providerInfo.authority + "]");
                    }
                    catch (Exception exception) {
                        ZeusLogger.errReport("Zeus/provider_pangle", "Init system contentProviderInfo [authority:" + providerInfo.authority + "],exception\uff1a", exception);
                    }
                }
            }
            return;
        }
        catch (Throwable throwable) {
            ZeusLogger.errReport("Zeus/provider_pangle", "init System ContentProviderInfo exception\uff1a", throwable);
            return;
        }
    }

    public static final class d {
        public final j d;
        public final ProviderInfo j;
        public final PluginContentProvider pl;

        public d(j j2, ProviderInfo providerInfo, PluginContentProvider pluginContentProvider) {
            this.j = providerInfo;
            this.d = j2;
            this.pl = pluginContentProvider;
        }
    }

    protected static final class pl
    extends j {
        public final ProviderInfo t;

        public pl(String string, String string2, ProviderInfo providerInfo) {
            super(string, string2, providerInfo.authority);
            this.t = providerInfo;
        }
    }

    public static class j {
        public final String d;
        public final String j;
        public final String pl;

        public j(String string, String string2, String string3) {
            this.d = string2;
            this.j = string3;
            this.pl = string;
        }

        public boolean equals(Object object) {
            if (object instanceof j) {
                object = (j)object;
                return TextUtils.equals((CharSequence)this.pl, (CharSequence)((j)object).pl) && TextUtils.equals((CharSequence)this.j, (CharSequence)((j)object).j) && TextUtils.equals((CharSequence)this.d, (CharSequence)((j)object).d);
            }
            return false;
        }

        public int hashCode() {
            if (Build.VERSION.SDK_INT >= 19) {
                return Objects.hash(this.d, this.j, this.pl);
            }
            return (this.d + this.j + this.d).hashCode();
        }
    }
}

