/*
 * Decompiled with CFR 0.152.
 */
package com.bykv.vk.component.ttvideo.mediakit.net;

import android.text.TextUtils;
import com.bykv.vk.component.ttvideo.mediakit.medialoader.AVMDLLog;
import com.bykv.vk.component.ttvideo.mediakit.net.AVMDLDNSInfo;
import com.bykv.vk.component.ttvideo.mediakit.net.AVMDLDNSParser;
import com.bykv.vk.component.ttvideo.mediakit.net.AVMDLDNSParserListener;
import com.bykv.vk.component.ttvideo.mediakit.net.IPCache;
import java.util.Locale;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class AVMDLDNSParserBridge
implements AVMDLDNSParserListener {
    private static final String TAG = "AVMDLDNSParserBridge";
    private static boolean v2Usable = true;
    public String host;
    boolean isFinish = false;
    String ipList = null;
    private Lock lock = new ReentrantLock();
    private long handle = 0L;

    public int start(long l2, String string) {
        int n2 = 0;
        if (v2Usable) {
            n2 = this.parserResult(l2, string, 2);
        }
        if (n2 <= 0) {
            return this.parserResult(l2, string, 1);
        }
        return n2;
    }

    private int parserResult(long l2, String string, int n2) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return -1;
        }
        int n3 = 0;
        this.lock.lock();
        this.handle = l2;
        AVMDLDNSParserBridge aVMDLDNSParserBridge = null;
        boolean bl = true;
        try {
            this.host = string;
            AVMDLDNSInfo aVMDLDNSInfo = IPCache.getInstance().get(string);
            if (aVMDLDNSInfo != null) {
                this.ipList = aVMDLDNSInfo.mIpList;
                n3 = 1;
                long l3 = System.currentTimeMillis();
                String.format("get result from cache expiredT:%d curT:%d ", aVMDLDNSInfo.mExpiredTime, l3);
                if (aVMDLDNSInfo.mExpiredTime <= l3) {
                    String.format("cache has expired need try call but not need listener", new Object[0]);
                } else {
                    bl = false;
                }
                if (this.handle != 0L) {
                    if (n2 == 1) {
                        v2Usable = false;
                        AVMDLDNSParserBridge._notifyParserResult(this.handle, string, this.ipList, aVMDLDNSInfo.mExpiredTime, null);
                    } else {
                        v2Usable = true;
                        AVMDLDNSParserBridge._notifyParserResultV2(this.handle, string, this.ipList, aVMDLDNSInfo.mExpiredTime, null, aVMDLDNSInfo.mType);
                    }
                }
            } else {
                aVMDLDNSParserBridge = this;
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            AVMDLLog.e(TAG, unsatisfiedLinkError.toString());
            if (v2Usable) {
                v2Usable = false;
            }
            n3 = 0;
        }
        finally {
            this.lock.unlock();
        }
        if (bl) {
            String.format("call add host to parser listener:%s", aVMDLDNSParserBridge);
            AVMDLDNSParser.getInstance().addHost(string, aVMDLDNSParserBridge);
        }
        String.format("****call start end, listener:%s", aVMDLDNSParserBridge);
        return n3;
    }

    boolean isFinish() {
        return this.isFinish;
    }

    public String getResult() {
        String string;
        this.lock.lock();
        try {
            string = this.ipList;
        }
        finally {
            this.lock.unlock();
        }
        return string;
    }

    public String getBackUp(String object) {
        String string = null;
        if (AVMDLDNSParser.getIntValue(5) == 1 && (object = IPCache.getInstance().getBackUpIp((String)object)) != null) {
            string = ((AVMDLDNSInfo)object).mIpList;
        }
        return string;
    }

    public void release() {
        String.format("----start release:%s", this);
        this.lock.lock();
        try {
            this.handle = 0L;
        }
        finally {
            this.lock.unlock();
        }
        String.format("remove host:%s", this.host);
        AVMDLDNSParser.getInstance().removeHost(this.host, this);
        String.format("****end call release:%s", this);
    }

    @Override
    public void onCompletion(int n2, String string, String string2, long l2, String string3, int n3) {
        if (!this.isFinish && v2Usable) {
            this.parserResult(n2, string, string2, l2, string3, n3, 2);
        }
        if (!this.isFinish) {
            this.parserResult(n2, string, string2, l2, string3, n3, 1);
        }
    }

    private void parserResult(int n2, String string, String string2, long l2, String string3, int n3, int n4) {
        this.lock.lock();
        try {
            if (!this.isFinish) {
                AVMDLDNSInfo aVMDLDNSInfo;
                String.format(Locale.ENGLISH, "receive completion code:%d result:%s type:%d", n2, TextUtils.isEmpty((CharSequence)string2) ? "null" : string2, n3);
                if (TextUtils.isEmpty((CharSequence)string2) && AVMDLDNSParser.getIntValue(5) == 1 && (aVMDLDNSInfo = IPCache.getInstance().getBackUpIp(string)) != null) {
                    string2 = aVMDLDNSInfo.mIpList;
                    l2 = 0L;
                    n3 = aVMDLDNSInfo.mType;
                    String.format(Locale.ENGLISH, "get backup ip, result:%s type:%d", string2, n3);
                }
                this.ipList = string2;
                this.isFinish = true;
                if (this.handle != 0L) {
                    if (n4 == 2) {
                        v2Usable = true;
                        AVMDLDNSParserBridge._notifyParserResultV2(this.handle, string, string2, l2, string3, n3);
                    } else {
                        v2Usable = false;
                        AVMDLDNSParserBridge._notifyParserResult(this.handle, string, string2, l2, string3);
                    }
                }
            } else {
                String.format(Locale.ENGLISH, "has finished not nedd cur completion code:%d result:%s expiredTime:%d", n2, string2, l2);
            }
            return;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            if (v2Usable) {
                v2Usable = false;
            }
            this.isFinish = false;
            return;
        }
        finally {
            this.lock.unlock();
        }
    }

    private static native void _notifyParserResult(long var0, String var2, String var3, long var4, String var6);

    private static native void _notifyParserResultV2(long var0, String var2, String var3, long var4, String var6, int var7);
}

