/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.pangle.log;

import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.bytedance.pangle.GlobalParam;
import com.bytedance.sdk.openadsdk.api.wc;
import java.util.Arrays;

@Keep
public class ZeusLogger {
    public static final String TAG = "Zeus_pangle";
    public static final String TAG_INIT = "Zeus/init_pangle";
    public static final String TAG_DOWNLOAD = "Zeus/download_pangle";
    public static final String TAG_RESOURCES = "Zeus/resources_pangle";
    public static final String TAG_INSTALL = "Zeus/install_pangle";
    public static final String TAG_LOAD = "Zeus/load_pangle";
    public static final String TAG_ACTIVITY = "Zeus/activity_pangle";
    public static final String TAG_SERVICE = "Zeus/service_pangle";
    public static final String TAG_RECEIVER = "Zeus/receiver_pangle";
    public static final String TAG_PROVIDER = "Zeus/provider_pangle";
    public static final String TAG_SERVER = "Zeus/server_pangle";
    public static final String TAG_SO = "Zeus/so_pangle";
    public static final String TAG_PPM = "Zeus/ppm_pangle";
    public static final String TAG_PAM = "Zeus/pam_pangle";
    public static final String TAG_REPORTER = "Zeus/reporter_pangle";
    private static boolean sDebug = true;
    private static boolean sEnableTrace = false;

    public static void setDebug(boolean bl) {
        sDebug = bl;
    }

    public static boolean isDebug() {
        return sDebug;
    }

    public static void setEnableTrace(boolean bl) {
        sEnableTrace = bl;
    }

    public static boolean isEnableTrace() {
        return sEnableTrace;
    }

    public static void v(String string) {
        ZeusLogger.v(null, string);
    }

    public static void v(String string, String string2) {
        string2 = ZeusLogger.prefixTraceInfo(string2);
        GlobalParam.getInstance().getReporter().saveRecord(string, string2);
        if (sDebug) {
            wc.d(string, string2);
            return;
        }
        if (GlobalParam.getInstance().getLogger() != null) {
            GlobalParam.getInstance().getLogger().v(string, string2);
        }
    }

    public static void d(String string) {
        ZeusLogger.d(null, string);
    }

    public static void d(String string, String string2) {
        ZeusLogger.i(string, string2);
    }

    public static void i(String string) {
        ZeusLogger.i(null, string);
    }

    public static void i(String string, String string2) {
        string2 = ZeusLogger.prefixTraceInfo(string2);
        GlobalParam.getInstance().getReporter().saveRecord(string, string2);
        if (sDebug) {
            wc.pl(string, string2);
            return;
        }
        if (GlobalParam.getInstance().getLogger() != null) {
            GlobalParam.getInstance().getLogger().i(string, string2);
        }
    }

    public static void w(String string) {
        ZeusLogger.w(null, string);
    }

    public static void w(String string, String string2) {
        string2 = ZeusLogger.prefixTraceInfo(string2);
        GlobalParam.getInstance().getReporter().saveRecord(string, string2);
        if (sDebug) {
            wc.t(string, string2);
            return;
        }
        if (GlobalParam.getInstance().getLogger() != null) {
            GlobalParam.getInstance().getLogger().w(string, string2);
        }
    }

    public static void w(String string, String string2, Throwable throwable) {
        string2 = ZeusLogger.prefixTraceInfo(string2);
        GlobalParam.getInstance().getReporter().saveRecord(string, string2 + " ; " + throwable);
        if (sDebug) {
            wc.t(string, string2, throwable);
            return;
        }
        if (GlobalParam.getInstance().getLogger() != null) {
            GlobalParam.getInstance().getLogger().w(string, string2, throwable);
        }
    }

    public static void errReport(String string, String string2) {
        RuntimeException runtimeException = new RuntimeException();
        StackTraceElement[] stackTraceElementArray = runtimeException.getStackTrace();
        stackTraceElementArray = Arrays.copyOfRange(stackTraceElementArray, 1, stackTraceElementArray.length - 1);
        runtimeException.setStackTrace(stackTraceElementArray);
        ZeusLogger.errReport(string, string2, runtimeException, false);
    }

    public static void errReport(String string, String string2, @NonNull Throwable throwable) {
        ZeusLogger.errReport(string, string2, throwable, true);
    }

    private static void errReport(String string, String string2, @NonNull Throwable throwable, boolean bl) {
        GlobalParam.getInstance().getReporter().saveRecord(string, string2 + " ; " + throwable);
        if (sDebug) {
            wc.nc(string, string2, bl ? throwable : null);
            return;
        }
        if (GlobalParam.getInstance().getLogger() != null) {
            GlobalParam.getInstance().getLogger().e(string, string2, bl ? throwable : null);
        }
    }

    private static String prefixTraceInfo(String string) {
        if (sEnableTrace) {
            string = string + ZeusLogger.getTraceInfo();
        }
        return string;
    }

    private static String getTraceInfo() {
        String string = "\t\t[No Trace Info]";
        try {
            StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
            StackTraceElement stackTraceElement = null;
            for (int i2 = 1; i2 < stackTraceElementArray.length; ++i2) {
                if (TextUtils.equals((CharSequence)stackTraceElementArray[i2].getClassName(), (CharSequence)ZeusLogger.class.getName())) continue;
                stackTraceElement = stackTraceElementArray[i2];
                break;
            }
            if (stackTraceElement != null) {
                string = "\t\t[" + stackTraceElement.toString() + "]";
            }
        }
        catch (Exception exception) {
            wc.d(exception);
        }
        return string;
    }
}

